/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateTaskRequest
implements Validatable {
    private final String applicationId;
    private final String command;
    private final Map<String, String> environmentVariables;
    private final Integer memoryInMb;
    private final String name;

    CreateTaskRequest(String applicationId, String command, Map<String, String> environmentVariables, String name, Integer memoryInMb) {
        this.applicationId = applicationId;
        this.command = command;
        this.environmentVariables = environmentVariables;
        this.name = name;
        this.memoryInMb = memoryInMb;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.command == null) {
            builder.message("command must be specified");
        }
        if (this.name == null) {
            builder.message("name must be specified");
        }
        return builder.build();
    }

    public static CreateTaskRequestBuilder builder() {
        return new CreateTaskRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTaskRequest)) {
            return false;
        }
        CreateTaskRequest other = (CreateTaskRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Map<String, String> this$environmentVariables = this.getEnvironmentVariables();
        Map<String, String> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Integer this$memoryInMb = this.getMemoryInMb();
        Integer other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !((Object)this$memoryInMb).equals(other$memoryInMb)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Map<String, String> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Integer $memoryInMb = this.getMemoryInMb();
        result = result * 59 + ($memoryInMb == null ? 43 : ((Object)$memoryInMb).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "CreateTaskRequest(applicationId=" + this.getApplicationId() + ", command=" + this.getCommand() + ", environmentVariables=" + this.getEnvironmentVariables() + ", memoryInMb=" + this.getMemoryInMb() + ", name=" + this.getName() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="environment_variables")
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @JsonProperty(value="memory_in_mb")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public static class CreateTaskRequestBuilder {
        private String applicationId;
        private String command;
        private ArrayList<String> environmentVariables$key;
        private ArrayList<String> environmentVariables$value;
        private String name;
        private Integer memoryInMb;

        CreateTaskRequestBuilder() {
        }

        public CreateTaskRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CreateTaskRequestBuilder command(String command) {
            this.command = command;
            return this;
        }

        public CreateTaskRequestBuilder environmentVariable(String environmentVariableKey, String environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        public CreateTaskRequestBuilder environmentVariables(Map<? extends String, ? extends String> environmentVariables) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateTaskRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateTaskRequestBuilder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public CreateTaskRequest build() {
            Map<String, String> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
                case 0: {
                    environmentVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentVariables = Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                    break;
                }
                default: {
                    environmentVariables = new LinkedHashMap(this.environmentVariables$key.size() < 0x40000000 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentVariables$key.size(); ++$i) {
                        environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                    }
                    environmentVariables = Collections.unmodifiableMap(environmentVariables);
                }
            }
            return new CreateTaskRequest(this.applicationId, this.command, environmentVariables, this.name, this.memoryInMb);
        }

        public String toString() {
            return "CreateTaskRequest.CreateTaskRequestBuilder(applicationId=" + this.applicationId + ", command=" + this.command + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", name=" + this.name + ", memoryInMb=" + this.memoryInMb + ")";
        }
    }
}

