/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v3.PaginatedResponse;
import org.cloudfoundry.client.v3.tasks.TaskResource;

public final class ListTasksResponse
extends PaginatedResponse<TaskResource> {
    ListTasksResponse(@JsonProperty(value="pagination") PaginatedResponse.Pagination pagination, @JsonProperty(value="resources") List<TaskResource> resources) {
        super(pagination, resources);
    }

    public static ListTasksResponseBuilder builder() {
        return new ListTasksResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTasksResponse)) {
            return false;
        }
        ListTasksResponse other = (ListTasksResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListTasksResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListTasksResponse(super=" + super.toString() + ")";
    }

    public static class ListTasksResponseBuilder {
        private PaginatedResponse.Pagination pagination;
        private ArrayList<TaskResource> resources;

        ListTasksResponseBuilder() {
        }

        public ListTasksResponseBuilder pagination(PaginatedResponse.Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public ListTasksResponseBuilder resource(TaskResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListTasksResponseBuilder resources(Collection<? extends TaskResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListTasksResponse build() {
            List<TaskResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<TaskResource>(this.resources));
                }
            }
            return new ListTasksResponse(this.pagination, resources);
        }

        public String toString() {
            return "ListTasksResponse.ListTasksResponseBuilder(pagination=" + this.pagination + ", resources=" + this.resources + ")";
        }
    }
}

