/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.cloudfoundry.logging.LoggregatorProtocolBuffers;

public final class LogMessage {
    private final String applicationId;
    private final List<String> drainUrls;
    private final String message;
    private final MessageType messageType;
    private final String sourceId;
    private final String sourceName;
    private final Date timestamp;

    LogMessage(String applicationId, List<String> drainUrls, String message, MessageType messageType, String sourceId, String sourceName, Date timestamp) {
        this.applicationId = applicationId;
        this.drainUrls = drainUrls;
        this.message = message;
        this.messageType = messageType;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.timestamp = timestamp;
    }

    public static LogMessage from(LoggregatorProtocolBuffers.LogMessage logMessage) {
        return LogMessage.builder().applicationId(logMessage.getAppId()).drainUrls((Collection<? extends String>)logMessage.getDrainUrlsList()).message(logMessage.getMessage().toStringUtf8()).messageType(MessageType.valueOf(logMessage.getMessageType().toString())).sourceId(logMessage.getSourceId()).sourceName(logMessage.getSourceName()).timestamp(new Date(TimeUnit.NANOSECONDS.toMillis(logMessage.getTimestamp()))).build();
    }

    public static LogMessageBuilder builder() {
        return new LogMessageBuilder();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public List<String> getDrainUrls() {
        return this.drainUrls;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogMessage)) {
            return false;
        }
        LogMessage other = (LogMessage)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        List<String> this$drainUrls = this.getDrainUrls();
        List<String> other$drainUrls = other.getDrainUrls();
        if (this$drainUrls == null ? other$drainUrls != null : !((Object)this$drainUrls).equals(other$drainUrls)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        List<String> $drainUrls = this.getDrainUrls();
        result = result * 59 + ($drainUrls == null ? 43 : ((Object)$drainUrls).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "LogMessage(applicationId=" + this.getApplicationId() + ", drainUrls=" + this.getDrainUrls() + ", message=" + this.getMessage() + ", messageType=" + (Object)((Object)this.getMessageType()) + ", sourceId=" + this.getSourceId() + ", sourceName=" + this.getSourceName() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class LogMessageBuilder {
        private String applicationId;
        private ArrayList<String> drainUrls;
        private String message;
        private MessageType messageType;
        private String sourceId;
        private String sourceName;
        private Date timestamp;

        LogMessageBuilder() {
        }

        public LogMessageBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public LogMessageBuilder drainUrl(String drainUrl) {
            if (this.drainUrls == null) {
                this.drainUrls = new ArrayList();
            }
            this.drainUrls.add(drainUrl);
            return this;
        }

        public LogMessageBuilder drainUrls(Collection<? extends String> drainUrls) {
            if (this.drainUrls == null) {
                this.drainUrls = new ArrayList();
            }
            this.drainUrls.addAll(drainUrls);
            return this;
        }

        public LogMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public LogMessageBuilder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public LogMessageBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public LogMessageBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public LogMessageBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public LogMessage build() {
            List<String> drainUrls;
            switch (this.drainUrls == null ? 0 : this.drainUrls.size()) {
                case 0: {
                    drainUrls = Collections.emptyList();
                    break;
                }
                case 1: {
                    drainUrls = Collections.singletonList(this.drainUrls.get(0));
                    break;
                }
                default: {
                    drainUrls = Collections.unmodifiableList(new ArrayList<String>(this.drainUrls));
                }
            }
            return new LogMessage(this.applicationId, drainUrls, this.message, this.messageType, this.sourceId, this.sourceName, this.timestamp);
        }

        public String toString() {
            return "LogMessage.LogMessageBuilder(applicationId=" + this.applicationId + ", drainUrls=" + this.drainUrls + ", message=" + this.message + ", messageType=" + (Object)((Object)this.messageType) + ", sourceId=" + this.sourceId + ", sourceName=" + this.sourceName + ", timestamp=" + this.timestamp + ")";
        }
    }

    public static enum MessageType {
        ERR,
        OUT;

    }
}

