/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzonemanagement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateIdentityZoneRequest
implements Validatable {
    private final String description;
    private final String identityZoneId;
    private final String name;
    private final String subdomain;
    private final Integer version;

    UpdateIdentityZoneRequest(String description, String identityZoneId, String name, String subdomain, Integer version) {
        this.description = description;
        this.identityZoneId = identityZoneId;
        this.name = name;
        this.subdomain = subdomain;
        this.version = version;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.description == null) {
            builder.message("description must be specified");
        }
        if (this.identityZoneId == null) {
            builder.message("identity zone id must be specified");
        }
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.subdomain == null) {
            builder.message("sub domain must be specified");
        }
        return builder.build();
    }

    public static UpdateIdentityZoneRequestBuilder builder() {
        return new UpdateIdentityZoneRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateIdentityZoneRequest)) {
            return false;
        }
        UpdateIdentityZoneRequest other = (UpdateIdentityZoneRequest)o;
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$identityZoneId = this.getIdentityZoneId();
        String other$identityZoneId = other.getIdentityZoneId();
        if (this$identityZoneId == null ? other$identityZoneId != null : !this$identityZoneId.equals(other$identityZoneId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$subdomain = this.getSubdomain();
        String other$subdomain = other.getSubdomain();
        if (this$subdomain == null ? other$subdomain != null : !this$subdomain.equals(other$subdomain)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $identityZoneId = this.getIdentityZoneId();
        result = result * 59 + ($identityZoneId == null ? 43 : $identityZoneId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $subdomain = this.getSubdomain();
        result = result * 59 + ($subdomain == null ? 43 : $subdomain.hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateIdentityZoneRequest(description=" + this.getDescription() + ", identityZoneId=" + this.getIdentityZoneId() + ", name=" + this.getName() + ", subdomain=" + this.getSubdomain() + ", version=" + this.getVersion() + ")";
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="subdomain")
    public String getSubdomain() {
        return this.subdomain;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public static class UpdateIdentityZoneRequestBuilder {
        private String description;
        private String identityZoneId;
        private String name;
        private String subdomain;
        private Integer version;

        UpdateIdentityZoneRequestBuilder() {
        }

        public UpdateIdentityZoneRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public UpdateIdentityZoneRequestBuilder identityZoneId(String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public UpdateIdentityZoneRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateIdentityZoneRequestBuilder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public UpdateIdentityZoneRequestBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public UpdateIdentityZoneRequest build() {
            return new UpdateIdentityZoneRequest(this.description, this.identityZoneId, this.name, this.subdomain, this.version);
        }

        public String toString() {
            return "UpdateIdentityZoneRequest.UpdateIdentityZoneRequestBuilder(description=" + this.description + ", identityZoneId=" + this.identityZoneId + ", name=" + this.name + ", subdomain=" + this.subdomain + ", version=" + this.version + ")";
        }
    }
}

