package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _ApplicationInstanceInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ApplicationInstanceInfo.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ApplicationInstanceInfo"})
public final class ApplicationInstanceInfo
    extends org.cloudfoundry.client.v2.applications._ApplicationInstanceInfo {
  private final @Nullable String consoleIp;
  private final @Nullable Integer consolePort;
  private final @Nullable String debugIp;
  private final @Nullable Integer debugPort;
  private final @Nullable Double since;
  private final @Nullable String state;
  private final @Nullable Long uptime;

  private ApplicationInstanceInfo(ApplicationInstanceInfo.Builder builder) {
    this.consoleIp = builder.consoleIp;
    this.consolePort = builder.consolePort;
    this.debugIp = builder.debugIp;
    this.debugPort = builder.debugPort;
    this.since = builder.since;
    this.state = builder.state;
    this.uptime = builder.uptime;
  }

  /**
   * The console IP
   */
  @JsonProperty("console_ip")
  @Override
  public @Nullable String getConsoleIp() {
    return consoleIp;
  }

  /**
   * The console port
   */
  @JsonProperty("console_port")
  @Override
  public @Nullable Integer getConsolePort() {
    return consolePort;
  }

  /**
   * The debug IP
   */
  @JsonProperty("debug_ip")
  @Override
  public @Nullable String getDebugIp() {
    return debugIp;
  }

  /**
   * The debug port
   */
  @JsonProperty("debug_port")
  @Override
  public @Nullable Integer getDebugPort() {
    return debugPort;
  }

  /**
   * The since
   */
  @JsonProperty("since")
  @Override
  public @Nullable Double getSince() {
    return since;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * The update
   */
  @JsonProperty("uptime")
  @Override
  public @Nullable Long getUptime() {
    return uptime;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationInstanceInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationInstanceInfo
        && equalTo((ApplicationInstanceInfo) another);
  }

  private boolean equalTo(ApplicationInstanceInfo another) {
    return Objects.equals(consoleIp, another.consoleIp)
        && Objects.equals(consolePort, another.consolePort)
        && Objects.equals(debugIp, another.debugIp)
        && Objects.equals(debugPort, another.debugPort)
        && Objects.equals(since, another.since)
        && Objects.equals(state, another.state)
        && Objects.equals(uptime, another.uptime);
  }

  /**
   * Computes a hash code from attributes: {@code consoleIp}, {@code consolePort}, {@code debugIp}, {@code debugPort}, {@code since}, {@code state}, {@code uptime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(consoleIp);
    h = h * 17 + Objects.hashCode(consolePort);
    h = h * 17 + Objects.hashCode(debugIp);
    h = h * 17 + Objects.hashCode(debugPort);
    h = h * 17 + Objects.hashCode(since);
    h = h * 17 + Objects.hashCode(state);
    h = h * 17 + Objects.hashCode(uptime);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationInstanceInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationInstanceInfo{"
        + "consoleIp=" + consoleIp
        + ", consolePort=" + consolePort
        + ", debugIp=" + debugIp
        + ", debugPort=" + debugPort
        + ", since=" + since
        + ", state=" + state
        + ", uptime=" + uptime
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.applications._ApplicationInstanceInfo {
    String consoleIp;
    Integer consolePort;
    String debugIp;
    Integer debugPort;
    Double since;
    String state;
    Long uptime;
    @JsonProperty("console_ip")
    public void setConsoleIp(@Nullable String consoleIp) {
      this.consoleIp = consoleIp;
    }
    @JsonProperty("console_port")
    public void setConsolePort(@Nullable Integer consolePort) {
      this.consolePort = consolePort;
    }
    @JsonProperty("debug_ip")
    public void setDebugIp(@Nullable String debugIp) {
      this.debugIp = debugIp;
    }
    @JsonProperty("debug_port")
    public void setDebugPort(@Nullable Integer debugPort) {
      this.debugPort = debugPort;
    }
    @JsonProperty("since")
    public void setSince(@Nullable Double since) {
      this.since = since;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("uptime")
    public void setUptime(@Nullable Long uptime) {
      this.uptime = uptime;
    }
    @Override
    public String getConsoleIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getConsolePort() { throw new UnsupportedOperationException(); }
    @Override
    public String getDebugIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDebugPort() { throw new UnsupportedOperationException(); }
    @Override
    public Double getSince() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public Long getUptime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ApplicationInstanceInfo fromJson(Json json) {
    ApplicationInstanceInfo.Builder builder = ApplicationInstanceInfo.builder();
    if (json.consoleIp != null) {
      builder.consoleIp(json.consoleIp);
    }
    if (json.consolePort != null) {
      builder.consolePort(json.consolePort);
    }
    if (json.debugIp != null) {
      builder.debugIp(json.debugIp);
    }
    if (json.debugPort != null) {
      builder.debugPort(json.debugPort);
    }
    if (json.since != null) {
      builder.since(json.since);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.uptime != null) {
      builder.uptime(json.uptime);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationInstanceInfo ApplicationInstanceInfo}.
   * @return A new ApplicationInstanceInfo builder
   */
  public static ApplicationInstanceInfo.Builder builder() {
    return new ApplicationInstanceInfo.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationInstanceInfo ApplicationInstanceInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String consoleIp;
    private Integer consolePort;
    private String debugIp;
    private Integer debugPort;
    private Double since;
    private String state;
    private Long uptime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationInstanceInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationInstanceInfo instance) {
      return from((_ApplicationInstanceInfo) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationInstanceInfo} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationInstanceInfo instance) {
      Objects.requireNonNull(instance, "instance");
      String consoleIpValue = instance.getConsoleIp();
      if (consoleIpValue != null) {
        consoleIp(consoleIpValue);
      }
      Integer consolePortValue = instance.getConsolePort();
      if (consolePortValue != null) {
        consolePort(consolePortValue);
      }
      String debugIpValue = instance.getDebugIp();
      if (debugIpValue != null) {
        debugIp(debugIpValue);
      }
      Integer debugPortValue = instance.getDebugPort();
      if (debugPortValue != null) {
        debugPort(debugPortValue);
      }
      Double sinceValue = instance.getSince();
      if (sinceValue != null) {
        since(sinceValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      Long uptimeValue = instance.getUptime();
      if (uptimeValue != null) {
        uptime(uptimeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationInstanceInfo#getConsoleIp() consoleIp} attribute.
     * @param consoleIp The value for consoleIp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder consoleIp(@Nullable String consoleIp) {
      this.consoleIp = consoleIp;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationInstanceInfo#getConsolePort() consolePort} attribute.
     * @param consolePort The value for consolePort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder consolePort(@Nullable Integer consolePort) {
      this.consolePort = consolePort;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationInstanceInfo#getDebugIp() debugIp} attribute.
     * @param debugIp The value for debugIp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder debugIp(@Nullable String debugIp) {
      this.debugIp = debugIp;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationInstanceInfo#getDebugPort() debugPort} attribute.
     * @param debugPort The value for debugPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder debugPort(@Nullable Integer debugPort) {
      this.debugPort = debugPort;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationInstanceInfo#getSince() since} attribute.
     * @param since The value for since (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder since(@Nullable Double since) {
      this.since = since;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationInstanceInfo#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationInstanceInfo#getUptime() uptime} attribute.
     * @param uptime The value for uptime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uptime(@Nullable Long uptime) {
      this.uptime = uptime;
      return this;
    }

    /**
     * Builds a new {@link ApplicationInstanceInfo ApplicationInstanceInfo}.
     * @return An immutable instance of ApplicationInstanceInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationInstanceInfo build() {
      return new ApplicationInstanceInfo(this);
    }
  }
}
