package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _ApplicationInstancesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ApplicationInstancesResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ApplicationInstancesResponse"})
public final class ApplicationInstancesResponse
    extends org.cloudfoundry.client.v2.applications._ApplicationInstancesResponse {
  private final Map<String, ApplicationInstanceInfo> instances;

  private ApplicationInstancesResponse(ApplicationInstancesResponse.Builder builder) {
    this.instances = createUnmodifiableMap(false, false, builder.instances);
  }

  /**
   * The instances
   */
  @JsonProperty("instances")
  @Override
  public Map<String, ApplicationInstanceInfo> getInstances() {
    return instances;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationInstancesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationInstancesResponse
        && equalTo((ApplicationInstancesResponse) another);
  }

  private boolean equalTo(ApplicationInstancesResponse another) {
    return instances.equals(another.instances);
  }

  /**
   * Computes a hash code from attributes: {@code instances}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + instances.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationInstancesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationInstancesResponse{"
        + "instances=" + instances
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.applications._ApplicationInstancesResponse {
    Map<String, ApplicationInstanceInfo> instances;
    @JsonProperty("instances")
    public void setInstances(Map<String, ApplicationInstanceInfo> instances) {
      this.instances = instances;
    }
    @Override
    public Map<String, ApplicationInstanceInfo> getInstances() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ApplicationInstancesResponse fromJson(Json json) {
    ApplicationInstancesResponse.Builder builder = ApplicationInstancesResponse.builder();
    if (json.instances != null) {
      builder.putAllInstances(json.instances);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationInstancesResponse ApplicationInstancesResponse}.
   * @return A new ApplicationInstancesResponse builder
   */
  public static ApplicationInstancesResponse.Builder builder() {
    return new ApplicationInstancesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationInstancesResponse ApplicationInstancesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, ApplicationInstanceInfo> instances = new LinkedHashMap<String, ApplicationInstanceInfo>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationInstancesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationInstancesResponse instance) {
      return from((_ApplicationInstancesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationInstancesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationInstancesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllInstances(instance.getInstances());
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationInstancesResponse#getInstances() instances} map.
     * @param key The key in the instances map
     * @param value The associated value in the instances map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instance(String key, ApplicationInstanceInfo value) {
      this.instances.put(
          Objects.requireNonNull(key, "instances key"),
          Objects.requireNonNull(value, "instances value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationInstancesResponse#getInstances() instances} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instance(Map.Entry<String, ? extends ApplicationInstanceInfo> entry) {
      String k = entry.getKey();
      ApplicationInstanceInfo v = entry.getValue();
      this.instances.put(
          Objects.requireNonNull(k, "instances key"),
          Objects.requireNonNull(v, "instances value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ApplicationInstancesResponse#getInstances() instances} map. Nulls are not permitted
     * @param instances The entries that will be added to the instances map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(Map<String, ? extends ApplicationInstanceInfo> instances) {
      this.instances.clear();
      return putAllInstances(instances);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ApplicationInstancesResponse#getInstances() instances} map. Nulls are not permitted
     * @param instances The entries that will be added to the instances map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllInstances(Map<String, ? extends ApplicationInstanceInfo> instances) {
      for (Map.Entry<String, ? extends ApplicationInstanceInfo> entry : instances.entrySet()) {
        String k = entry.getKey();
        ApplicationInstanceInfo v = entry.getValue();
        this.instances.put(
            Objects.requireNonNull(k, "instances key"),
            Objects.requireNonNull(v, "instances value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ApplicationInstancesResponse ApplicationInstancesResponse}.
     * @return An immutable instance of ApplicationInstancesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationInstancesResponse build() {
      return new ApplicationInstancesResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
