package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.*;

/**
 * Immutable implementation of {@link _ApplicationResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ApplicationResource.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ApplicationResource"})
public final class ApplicationResource extends org.cloudfoundry.client.v2.applications._ApplicationResource {
  private final @Nullable ApplicationEntity entity;
  private final @Nullable Metadata metadata;

  private ApplicationResource(ApplicationResource.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable ApplicationEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationResource
        && equalTo((ApplicationResource) another);
  }

  private boolean equalTo(ApplicationResource another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(entity);
    h = h * 17 + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationResource{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.applications._ApplicationResource {
    ApplicationEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable ApplicationEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public ApplicationEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ApplicationResource fromJson(Json json) {
    ApplicationResource.Builder builder = ApplicationResource.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationResource ApplicationResource}.
   * @return A new ApplicationResource builder
   */
  public static ApplicationResource.Builder builder() {
    return new ApplicationResource.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationResource ApplicationResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private ApplicationEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationResource instance) {
      return from((_ApplicationResource) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationResource instance) {
      Objects.requireNonNull(instance, "instance");
      ApplicationEntity entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationResource#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder entity(@Nullable ApplicationEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link ApplicationResource ApplicationResource}.
     * @return An immutable instance of ApplicationResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationResource build() {
      return new ApplicationResource(this);
    }
  }
}
