package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Statistics}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Statistics.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Statistics"})
public final class Statistics extends org.cloudfoundry.client.v2.applications._Statistics {
  private final @Nullable Long diskQuota;
  private final @Nullable Integer fdsQuota;
  private final @Nullable String host;
  private final @Nullable Long memoryQuota;
  private final @Nullable String name;
  private final @Nullable Integer port;
  private final @Nullable Long uptime;
  private final @Nullable List<String> uris;
  private final @Nullable Usage usage;

  private Statistics(Statistics.Builder builder) {
    this.diskQuota = builder.diskQuota;
    this.fdsQuota = builder.fdsQuota;
    this.host = builder.host;
    this.memoryQuota = builder.memoryQuota;
    this.name = builder.name;
    this.port = builder.port;
    this.uptime = builder.uptime;
    this.uris = builder.uris == null ? null : createUnmodifiableList(true, builder.uris);
    this.usage = builder.usage;
  }

  /**
   * The application disk quota
   */
  @JsonProperty("disk_quota")
  @Override
  public @Nullable Long getDiskQuota() {
    return diskQuota;
  }

  /**
   * The application file descriptor quota
   */
  @JsonProperty("fds_quota")
  @Override
  public @Nullable Integer getFdsQuota() {
    return fdsQuota;
  }

  /**
   * The application host
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The application memory quota
   */
  @JsonProperty("mem_quota")
  @Override
  public @Nullable Long getMemoryQuota() {
    return memoryQuota;
  }

  /**
   * The application name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The application port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The application uptime
   */
  @JsonProperty("uptime")
  @Override
  public @Nullable Long getUptime() {
    return uptime;
  }

  /**
   * The application uris
   */
  @JsonProperty("uris")
  @Override
  public @Nullable List<String> getUris() {
    return uris;
  }

  /**
   * The application usage
   */
  @JsonProperty("usage")
  @Override
  public @Nullable Usage getUsage() {
    return usage;
  }

  /**
   * This instance is equal to all instances of {@code Statistics} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Statistics
        && equalTo((Statistics) another);
  }

  private boolean equalTo(Statistics another) {
    return Objects.equals(diskQuota, another.diskQuota)
        && Objects.equals(fdsQuota, another.fdsQuota)
        && Objects.equals(host, another.host)
        && Objects.equals(memoryQuota, another.memoryQuota)
        && Objects.equals(name, another.name)
        && Objects.equals(port, another.port)
        && Objects.equals(uptime, another.uptime)
        && Objects.equals(uris, another.uris)
        && Objects.equals(usage, another.usage);
  }

  /**
   * Computes a hash code from attributes: {@code diskQuota}, {@code fdsQuota}, {@code host}, {@code memoryQuota}, {@code name}, {@code port}, {@code uptime}, {@code uris}, {@code usage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(diskQuota);
    h = h * 17 + Objects.hashCode(fdsQuota);
    h = h * 17 + Objects.hashCode(host);
    h = h * 17 + Objects.hashCode(memoryQuota);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(port);
    h = h * 17 + Objects.hashCode(uptime);
    h = h * 17 + Objects.hashCode(uris);
    h = h * 17 + Objects.hashCode(usage);
    return h;
  }

  /**
   * Prints the immutable value {@code Statistics} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Statistics{"
        + "diskQuota=" + diskQuota
        + ", fdsQuota=" + fdsQuota
        + ", host=" + host
        + ", memoryQuota=" + memoryQuota
        + ", name=" + name
        + ", port=" + port
        + ", uptime=" + uptime
        + ", uris=" + uris
        + ", usage=" + usage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.applications._Statistics {
    Long diskQuota;
    Integer fdsQuota;
    String host;
    Long memoryQuota;
    String name;
    Integer port;
    Long uptime;
    List<String> uris = null;
    Usage usage;
    @JsonProperty("disk_quota")
    public void setDiskQuota(@Nullable Long diskQuota) {
      this.diskQuota = diskQuota;
    }
    @JsonProperty("fds_quota")
    public void setFdsQuota(@Nullable Integer fdsQuota) {
      this.fdsQuota = fdsQuota;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("mem_quota")
    public void setMemoryQuota(@Nullable Long memoryQuota) {
      this.memoryQuota = memoryQuota;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @JsonProperty("uptime")
    public void setUptime(@Nullable Long uptime) {
      this.uptime = uptime;
    }
    @JsonProperty("uris")
    public void setUris(@Nullable List<String> uris) {
      this.uris = uris;
    }
    @JsonProperty("usage")
    public void setUsage(@Nullable Usage usage) {
      this.usage = usage;
    }
    @Override
    public Long getDiskQuota() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getFdsQuota() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public Long getMemoryQuota() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public Long getUptime() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getUris() { throw new UnsupportedOperationException(); }
    @Override
    public Usage getUsage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Statistics fromJson(Json json) {
    Statistics.Builder builder = Statistics.builder();
    if (json.diskQuota != null) {
      builder.diskQuota(json.diskQuota);
    }
    if (json.fdsQuota != null) {
      builder.fdsQuota(json.fdsQuota);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.memoryQuota != null) {
      builder.memoryQuota(json.memoryQuota);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.uptime != null) {
      builder.uptime(json.uptime);
    }
    if (json.uris != null) {
      builder.addAllUris(json.uris);
    }
    if (json.usage != null) {
      builder.usage(json.usage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Statistics Statistics}.
   * @return A new Statistics builder
   */
  public static Statistics.Builder builder() {
    return new Statistics.Builder();
  }

  /**
   * Builds instances of type {@link Statistics Statistics}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Long diskQuota;
    private Integer fdsQuota;
    private String host;
    private Long memoryQuota;
    private String name;
    private Integer port;
    private Long uptime;
    private List<String> uris = null;
    private Usage usage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Statistics} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Statistics instance) {
      return from((_Statistics) instance);
    }

    /**
     * Copy abstract value type {@code _Statistics} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Statistics instance) {
      Objects.requireNonNull(instance, "instance");
      Long diskQuotaValue = instance.getDiskQuota();
      if (diskQuotaValue != null) {
        diskQuota(diskQuotaValue);
      }
      Integer fdsQuotaValue = instance.getFdsQuota();
      if (fdsQuotaValue != null) {
        fdsQuota(fdsQuotaValue);
      }
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      Long memoryQuotaValue = instance.getMemoryQuota();
      if (memoryQuotaValue != null) {
        memoryQuota(memoryQuotaValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      Long uptimeValue = instance.getUptime();
      if (uptimeValue != null) {
        uptime(uptimeValue);
      }
      List<String> urisValue = instance.getUris();
      if (urisValue != null) {
        addAllUris(urisValue);
      }
      Usage usageValue = instance.getUsage();
      if (usageValue != null) {
        usage(usageValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(@Nullable Long diskQuota) {
      this.diskQuota = diskQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getFdsQuota() fdsQuota} attribute.
     * @param fdsQuota The value for fdsQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fdsQuota(@Nullable Integer fdsQuota) {
      this.fdsQuota = fdsQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getMemoryQuota() memoryQuota} attribute.
     * @param memoryQuota The value for memoryQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryQuota(@Nullable Long memoryQuota) {
      this.memoryQuota = memoryQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getUptime() uptime} attribute.
     * @param uptime The value for uptime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uptime(@Nullable Long uptime) {
      this.uptime = uptime;
      return this;
    }

    /**
     * Adds one element to {@link _Statistics#getUris() uris} list.
     * @param element A uris element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uri(String element) {
      if (this.uris == null) {
        this.uris = new ArrayList<String>();
      }
      this.uris.add(Objects.requireNonNull(element, "uris element"));
      return this;
    }

    /**
     * Adds elements to {@link _Statistics#getUris() uris} list.
     * @param elements An array of uris elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uri(String... elements) {
      if (this.uris == null) {
        this.uris = new ArrayList<String>();
      }
      for (String element : elements) {
        this.uris.add(Objects.requireNonNull(element, "uris element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _Statistics#getUris() uris} list.
     * @param elements An iterable of uris elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uris(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.uris = null;
        return this;
      }
      this.uris = new ArrayList<String>();
      return addAllUris(elements);
    }

    /**
     * Adds elements to {@link _Statistics#getUris() uris} list.
     * @param elements An iterable of uris elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUris(Iterable<String> elements) {
      Objects.requireNonNull(elements, "uris element");
      if (this.uris == null) {
        this.uris = new ArrayList<String>();
      }
      for (String element : elements) {
        this.uris.add(Objects.requireNonNull(element, "uris element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Statistics#getUsage() usage} attribute.
     * @param usage The value for usage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder usage(@Nullable Usage usage) {
      this.usage = usage;
      return this;
    }

    /**
     * Builds a new {@link Statistics Statistics}.
     * @return An immutable instance of Statistics
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Statistics build() {
      return new Statistics(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
