package org.cloudfoundry.client.v2.buildpacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _UpdateBuildpackRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateBuildpackRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UpdateBuildpackRequest"})
public final class UpdateBuildpackRequest
    extends org.cloudfoundry.client.v2.buildpacks._UpdateBuildpackRequest {
  private final String buildpackId;
  private final @Nullable Boolean enabled;
  private final @Nullable String filename;
  private final @Nullable Boolean locked;
  private final @Nullable String name;
  private final @Nullable Integer position;

  private UpdateBuildpackRequest(UpdateBuildpackRequest.Builder builder) {
    this.buildpackId = builder.buildpackId;
    this.enabled = builder.enabled;
    this.filename = builder.filename;
    this.locked = builder.locked;
    this.name = builder.name;
    this.position = builder.position;
  }

  /**
   * The buildpack id
   */
  @Override
  public String getBuildpackId() {
    return buildpackId;
  }

  /**
   * The enabled flag
   */
  @Override
  public @Nullable Boolean getEnabled() {
    return enabled;
  }

  /**
   * The filename
   */
  @Override
  public @Nullable String getFilename() {
    return filename;
  }

  /**
   * The locked flag
   */
  @Override
  public @Nullable Boolean getLocked() {
    return locked;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The position
   */
  @Override
  public @Nullable Integer getPosition() {
    return position;
  }

  /**
   * This instance is equal to all instances of {@code UpdateBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateBuildpackRequest
        && equalTo((UpdateBuildpackRequest) another);
  }

  private boolean equalTo(UpdateBuildpackRequest another) {
    return buildpackId.equals(another.buildpackId)
        && Objects.equals(enabled, another.enabled)
        && Objects.equals(filename, another.filename)
        && Objects.equals(locked, another.locked)
        && Objects.equals(name, another.name)
        && Objects.equals(position, another.position);
  }

  /**
   * Computes a hash code from attributes: {@code buildpackId}, {@code enabled}, {@code filename}, {@code locked}, {@code name}, {@code position}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + buildpackId.hashCode();
    h = h * 17 + Objects.hashCode(enabled);
    h = h * 17 + Objects.hashCode(filename);
    h = h * 17 + Objects.hashCode(locked);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(position);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateBuildpackRequest{"
        + "buildpackId=" + buildpackId
        + ", enabled=" + enabled
        + ", filename=" + filename
        + ", locked=" + locked
        + ", name=" + name
        + ", position=" + position
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateBuildpackRequest UpdateBuildpackRequest}.
   * @return A new UpdateBuildpackRequest builder
   */
  public static UpdateBuildpackRequest.Builder builder() {
    return new UpdateBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateBuildpackRequest UpdateBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BUILDPACK_ID = 0x1L;
    private long initBits = 0x1L;

    private String buildpackId;
    private Boolean enabled;
    private String filename;
    private Boolean locked;
    private String name;
    private Integer position;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateBuildpackRequest instance) {
      return from((_UpdateBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      buildpackId(instance.getBuildpackId());
      Boolean enabledValue = instance.getEnabled();
      if (enabledValue != null) {
        enabled(enabledValue);
      }
      String filenameValue = instance.getFilename();
      if (filenameValue != null) {
        filename(filenameValue);
      }
      Boolean lockedValue = instance.getLocked();
      if (lockedValue != null) {
        locked(lockedValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Integer positionValue = instance.getPosition();
      if (positionValue != null) {
        position(positionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateBuildpackRequest#getBuildpackId() buildpackId} attribute.
     * @param buildpackId The value for buildpackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpackId(String buildpackId) {
      this.buildpackId = Objects.requireNonNull(buildpackId, "buildpackId");
      initBits &= ~INIT_BIT_BUILDPACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateBuildpackRequest#getEnabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateBuildpackRequest#getFilename() filename} attribute.
     * @param filename The value for filename (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder filename(@Nullable String filename) {
      this.filename = filename;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateBuildpackRequest#getLocked() locked} attribute.
     * @param locked The value for locked (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder locked(@Nullable Boolean locked) {
      this.locked = locked;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateBuildpackRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateBuildpackRequest#getPosition() position} attribute.
     * @param position The value for position (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder position(@Nullable Integer position) {
      this.position = position;
      return this;
    }

    /**
     * Builds a new {@link UpdateBuildpackRequest UpdateBuildpackRequest}.
     * @return An immutable instance of UpdateBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_BUILDPACK_ID) != 0) attributes.add("buildpackId");
      return "Cannot build UpdateBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
