package org.cloudfoundry.client.v2.featureflags;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _SetFeatureFlagRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SetFeatureFlagRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_SetFeatureFlagRequest"})
public final class SetFeatureFlagRequest
    extends org.cloudfoundry.client.v2.featureflags._SetFeatureFlagRequest {
  private final Boolean enabled;
  private final @Nullable String errorMessage;
  private final String name;

  private SetFeatureFlagRequest(SetFeatureFlagRequest.Builder builder) {
    this.enabled = builder.enabled;
    this.errorMessage = builder.errorMessage;
    this.name = builder.name;
  }

  /**
   * The state of the feature flag
   */
  @Override
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * The custom error message for the feature flag
   */
  @Override
  public @Nullable String getErrorMessage() {
    return errorMessage;
  }

  /**
   * The name of the feature flag
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code SetFeatureFlagRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SetFeatureFlagRequest
        && equalTo((SetFeatureFlagRequest) another);
  }

  private boolean equalTo(SetFeatureFlagRequest another) {
    return enabled.equals(another.enabled)
        && Objects.equals(errorMessage, another.errorMessage)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code errorMessage}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + enabled.hashCode();
    h = h * 17 + Objects.hashCode(errorMessage);
    h = h * 17 + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetFeatureFlagRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SetFeatureFlagRequest{"
        + "enabled=" + enabled
        + ", errorMessage=" + errorMessage
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link SetFeatureFlagRequest SetFeatureFlagRequest}.
   * @return A new SetFeatureFlagRequest builder
   */
  public static SetFeatureFlagRequest.Builder builder() {
    return new SetFeatureFlagRequest.Builder();
  }

  /**
   * Builds instances of type {@link SetFeatureFlagRequest SetFeatureFlagRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ENABLED = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private Boolean enabled;
    private String errorMessage;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetFeatureFlagRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SetFeatureFlagRequest instance) {
      return from((_SetFeatureFlagRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SetFeatureFlagRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SetFeatureFlagRequest instance) {
      Objects.requireNonNull(instance, "instance");
      enabled(instance.getEnabled());
      String errorMessageValue = instance.getErrorMessage();
      if (errorMessageValue != null) {
        errorMessage(errorMessageValue);
      }
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _SetFeatureFlagRequest#getEnabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(Boolean enabled) {
      this.enabled = Objects.requireNonNull(enabled, "enabled");
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link _SetFeatureFlagRequest#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link _SetFeatureFlagRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link SetFeatureFlagRequest SetFeatureFlagRequest}.
     * @return An immutable instance of SetFeatureFlagRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SetFeatureFlagRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SetFeatureFlagRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build SetFeatureFlagRequest, some of required attributes are not set " + attributes;
    }
  }
}
