package org.cloudfoundry.client.v2.jobs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _ErrorDetails}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ErrorDetails.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ErrorDetails"})
public final class ErrorDetails extends org.cloudfoundry.client.v2.jobs._ErrorDetails {
  private final @Nullable Integer code;
  private final @Nullable String description;
  private final @Nullable String errorCode;

  private ErrorDetails(ErrorDetails.Builder builder) {
    this.code = builder.code;
    this.description = builder.description;
    this.errorCode = builder.errorCode;
  }

  /**
   * The code
   */
  @JsonProperty("code")
  @Override
  public @Nullable Integer getCode() {
    return code;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The error code
   */
  @JsonProperty("error_code")
  @Override
  public @Nullable String getErrorCode() {
    return errorCode;
  }

  /**
   * This instance is equal to all instances of {@code ErrorDetails} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ErrorDetails
        && equalTo((ErrorDetails) another);
  }

  private boolean equalTo(ErrorDetails another) {
    return Objects.equals(code, another.code)
        && Objects.equals(description, another.description)
        && Objects.equals(errorCode, another.errorCode);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code description}, {@code errorCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(code);
    h = h * 17 + Objects.hashCode(description);
    h = h * 17 + Objects.hashCode(errorCode);
    return h;
  }

  /**
   * Prints the immutable value {@code ErrorDetails} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ErrorDetails{"
        + "code=" + code
        + ", description=" + description
        + ", errorCode=" + errorCode
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.jobs._ErrorDetails {
    Integer code;
    String description;
    String errorCode;
    @JsonProperty("code")
    public void setCode(@Nullable Integer code) {
      this.code = code;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("error_code")
    public void setErrorCode(@Nullable String errorCode) {
      this.errorCode = errorCode;
    }
    @Override
    public Integer getCode() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getErrorCode() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ErrorDetails fromJson(Json json) {
    ErrorDetails.Builder builder = ErrorDetails.builder();
    if (json.code != null) {
      builder.code(json.code);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.errorCode != null) {
      builder.errorCode(json.errorCode);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ErrorDetails ErrorDetails}.
   * @return A new ErrorDetails builder
   */
  public static ErrorDetails.Builder builder() {
    return new ErrorDetails.Builder();
  }

  /**
   * Builds instances of type {@link ErrorDetails ErrorDetails}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer code;
    private String description;
    private String errorCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ErrorDetails} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ErrorDetails instance) {
      return from((_ErrorDetails) instance);
    }

    /**
     * Copy abstract value type {@code _ErrorDetails} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ErrorDetails instance) {
      Objects.requireNonNull(instance, "instance");
      Integer codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String errorCodeValue = instance.getErrorCode();
      if (errorCodeValue != null) {
        errorCode(errorCodeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ErrorDetails#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder code(@Nullable Integer code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link _ErrorDetails#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _ErrorDetails#getErrorCode() errorCode} attribute.
     * @param errorCode The value for errorCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errorCode(@Nullable String errorCode) {
      this.errorCode = errorCode;
      return this;
    }

    /**
     * Builds a new {@link ErrorDetails ErrorDetails}.
     * @return An immutable instance of ErrorDetails
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ErrorDetails build() {
      return new ErrorDetails(this);
    }
  }
}
