package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetOrganizationInstanceUsageRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetOrganizationInstanceUsageRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetOrganizationInstanceUsageRequest"})
public final class GetOrganizationInstanceUsageRequest
    extends org.cloudfoundry.client.v2.organizations._GetOrganizationInstanceUsageRequest {
  private final String organizationId;

  private GetOrganizationInstanceUsageRequest(GetOrganizationInstanceUsageRequest.Builder builder) {
    this.organizationId = builder.organizationId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationInstanceUsageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationInstanceUsageRequest
        && equalTo((GetOrganizationInstanceUsageRequest) another);
  }

  private boolean equalTo(GetOrganizationInstanceUsageRequest another) {
    return organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationInstanceUsageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationInstanceUsageRequest{"
        + "organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link GetOrganizationInstanceUsageRequest GetOrganizationInstanceUsageRequest}.
   * @return A new GetOrganizationInstanceUsageRequest builder
   */
  public static GetOrganizationInstanceUsageRequest.Builder builder() {
    return new GetOrganizationInstanceUsageRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationInstanceUsageRequest GetOrganizationInstanceUsageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationInstanceUsageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationInstanceUsageRequest instance) {
      return from((_GetOrganizationInstanceUsageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetOrganizationInstanceUsageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationInstanceUsageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetOrganizationInstanceUsageRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationInstanceUsageRequest GetOrganizationInstanceUsageRequest}.
     * @return An immutable instance of GetOrganizationInstanceUsageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationInstanceUsageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetOrganizationInstanceUsageRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build GetOrganizationInstanceUsageRequest, some of required attributes are not set " + attributes;
    }
  }
}
