package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _GetOrganizationMemoryUsageResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetOrganizationMemoryUsageResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetOrganizationMemoryUsageResponse"})
public final class GetOrganizationMemoryUsageResponse
    extends org.cloudfoundry.client.v2.organizations._GetOrganizationMemoryUsageResponse {
  private final @Nullable Integer memoryUsageInMb;

  private GetOrganizationMemoryUsageResponse(GetOrganizationMemoryUsageResponse.Builder builder) {
    this.memoryUsageInMb = builder.memoryUsageInMb;
  }

  /**
   * The memory usage in mb
   */
  @JsonProperty("memory_usage_in_mb")
  @Override
  public @Nullable Integer getMemoryUsageInMb() {
    return memoryUsageInMb;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationMemoryUsageResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationMemoryUsageResponse
        && equalTo((GetOrganizationMemoryUsageResponse) another);
  }

  private boolean equalTo(GetOrganizationMemoryUsageResponse another) {
    return Objects.equals(memoryUsageInMb, another.memoryUsageInMb);
  }

  /**
   * Computes a hash code from attributes: {@code memoryUsageInMb}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(memoryUsageInMb);
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationMemoryUsageResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationMemoryUsageResponse{"
        + "memoryUsageInMb=" + memoryUsageInMb
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.organizations._GetOrganizationMemoryUsageResponse {
    Integer memoryUsageInMb;
    @JsonProperty("memory_usage_in_mb")
    public void setMemoryUsageInMb(@Nullable Integer memoryUsageInMb) {
      this.memoryUsageInMb = memoryUsageInMb;
    }
    @Override
    public Integer getMemoryUsageInMb() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static GetOrganizationMemoryUsageResponse fromJson(Json json) {
    GetOrganizationMemoryUsageResponse.Builder builder = GetOrganizationMemoryUsageResponse.builder();
    if (json.memoryUsageInMb != null) {
      builder.memoryUsageInMb(json.memoryUsageInMb);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetOrganizationMemoryUsageResponse GetOrganizationMemoryUsageResponse}.
   * @return A new GetOrganizationMemoryUsageResponse builder
   */
  public static GetOrganizationMemoryUsageResponse.Builder builder() {
    return new GetOrganizationMemoryUsageResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationMemoryUsageResponse GetOrganizationMemoryUsageResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer memoryUsageInMb;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationMemoryUsageResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationMemoryUsageResponse instance) {
      return from((_GetOrganizationMemoryUsageResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetOrganizationMemoryUsageResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationMemoryUsageResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Integer memoryUsageInMbValue = instance.getMemoryUsageInMb();
      if (memoryUsageInMbValue != null) {
        memoryUsageInMb(memoryUsageInMbValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GetOrganizationMemoryUsageResponse#getMemoryUsageInMb() memoryUsageInMb} attribute.
     * @param memoryUsageInMb The value for memoryUsageInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryUsageInMb(@Nullable Integer memoryUsageInMb) {
      this.memoryUsageInMb = memoryUsageInMb;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationMemoryUsageResponse GetOrganizationMemoryUsageResponse}.
     * @return An immutable instance of GetOrganizationMemoryUsageResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationMemoryUsageResponse build() {
      return new GetOrganizationMemoryUsageResponse(this);
    }
  }
}
