package org.cloudfoundry.client.v2.routemappings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _RouteMappingEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code RouteMappingEntity.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_RouteMappingEntity"})
public final class RouteMappingEntity extends org.cloudfoundry.client.v2.routemappings._RouteMappingEntity {
  private final @Nullable String applicationId;
  private final @Nullable Integer applicationPort;
  private final @Nullable String applicationUrl;
  private final @Nullable String routeId;
  private final @Nullable String routeUrl;

  private RouteMappingEntity(RouteMappingEntity.Builder builder) {
    this.applicationId = builder.applicationId;
    this.applicationPort = builder.applicationPort;
    this.applicationUrl = builder.applicationUrl;
    this.routeId = builder.routeId;
    this.routeUrl = builder.routeUrl;
  }

  /**
   * The application id
   */
  @JsonProperty("app_guid")
  @Override
  public @Nullable String getApplicationId() {
    return applicationId;
  }

  /**
   * The application port
   */
  @JsonProperty("app_port")
  @Override
  public @Nullable Integer getApplicationPort() {
    return applicationPort;
  }

  /**
   * The application url
   */
  @JsonProperty("app_url")
  @Override
  public @Nullable String getApplicationUrl() {
    return applicationUrl;
  }

  /**
   * The route id
   */
  @JsonProperty("route_guid")
  @Override
  public @Nullable String getRouteId() {
    return routeId;
  }

  /**
   * The route url
   */
  @JsonProperty("route_url")
  @Override
  public @Nullable String getRouteUrl() {
    return routeUrl;
  }

  /**
   * This instance is equal to all instances of {@code RouteMappingEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouteMappingEntity
        && equalTo((RouteMappingEntity) another);
  }

  private boolean equalTo(RouteMappingEntity another) {
    return Objects.equals(applicationId, another.applicationId)
        && Objects.equals(applicationPort, another.applicationPort)
        && Objects.equals(applicationUrl, another.applicationUrl)
        && Objects.equals(routeId, another.routeId)
        && Objects.equals(routeUrl, another.routeUrl);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code applicationPort}, {@code applicationUrl}, {@code routeId}, {@code routeUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applicationId);
    h = h * 17 + Objects.hashCode(applicationPort);
    h = h * 17 + Objects.hashCode(applicationUrl);
    h = h * 17 + Objects.hashCode(routeId);
    h = h * 17 + Objects.hashCode(routeUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code RouteMappingEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouteMappingEntity{"
        + "applicationId=" + applicationId
        + ", applicationPort=" + applicationPort
        + ", applicationUrl=" + applicationUrl
        + ", routeId=" + routeId
        + ", routeUrl=" + routeUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.routemappings._RouteMappingEntity {
    String applicationId;
    Integer applicationPort;
    String applicationUrl;
    String routeId;
    String routeUrl;
    @JsonProperty("app_guid")
    public void setApplicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("app_port")
    public void setApplicationPort(@Nullable Integer applicationPort) {
      this.applicationPort = applicationPort;
    }
    @JsonProperty("app_url")
    public void setApplicationUrl(@Nullable String applicationUrl) {
      this.applicationUrl = applicationUrl;
    }
    @JsonProperty("route_guid")
    public void setRouteId(@Nullable String routeId) {
      this.routeId = routeId;
    }
    @JsonProperty("route_url")
    public void setRouteUrl(@Nullable String routeUrl) {
      this.routeUrl = routeUrl;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getApplicationPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static RouteMappingEntity fromJson(Json json) {
    RouteMappingEntity.Builder builder = RouteMappingEntity.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.applicationPort != null) {
      builder.applicationPort(json.applicationPort);
    }
    if (json.applicationUrl != null) {
      builder.applicationUrl(json.applicationUrl);
    }
    if (json.routeId != null) {
      builder.routeId(json.routeId);
    }
    if (json.routeUrl != null) {
      builder.routeUrl(json.routeUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RouteMappingEntity RouteMappingEntity}.
   * @return A new RouteMappingEntity builder
   */
  public static RouteMappingEntity.Builder builder() {
    return new RouteMappingEntity.Builder();
  }

  /**
   * Builds instances of type {@link RouteMappingEntity RouteMappingEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String applicationId;
    private Integer applicationPort;
    private String applicationUrl;
    private String routeId;
    private String routeUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouteMappingEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouteMappingEntity instance) {
      return from((_RouteMappingEntity) instance);
    }

    /**
     * Copy abstract value type {@code _RouteMappingEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RouteMappingEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String applicationIdValue = instance.getApplicationId();
      if (applicationIdValue != null) {
        applicationId(applicationIdValue);
      }
      Integer applicationPortValue = instance.getApplicationPort();
      if (applicationPortValue != null) {
        applicationPort(applicationPortValue);
      }
      String applicationUrlValue = instance.getApplicationUrl();
      if (applicationUrlValue != null) {
        applicationUrl(applicationUrlValue);
      }
      String routeIdValue = instance.getRouteId();
      if (routeIdValue != null) {
        routeId(routeIdValue);
      }
      String routeUrlValue = instance.getRouteUrl();
      if (routeUrlValue != null) {
        routeUrl(routeUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteMappingEntity#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteMappingEntity#getApplicationPort() applicationPort} attribute.
     * @param applicationPort The value for applicationPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationPort(@Nullable Integer applicationPort) {
      this.applicationPort = applicationPort;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteMappingEntity#getApplicationUrl() applicationUrl} attribute.
     * @param applicationUrl The value for applicationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationUrl(@Nullable String applicationUrl) {
      this.applicationUrl = applicationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteMappingEntity#getRouteId() routeId} attribute.
     * @param routeId The value for routeId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(@Nullable String routeId) {
      this.routeId = routeId;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteMappingEntity#getRouteUrl() routeUrl} attribute.
     * @param routeUrl The value for routeUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeUrl(@Nullable String routeUrl) {
      this.routeUrl = routeUrl;
      return this;
    }

    /**
     * Builds a new {@link RouteMappingEntity RouteMappingEntity}.
     * @return An immutable instance of RouteMappingEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouteMappingEntity build() {
      return new RouteMappingEntity(this);
    }
  }
}
