package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _RuleEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code RuleEntity.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_RuleEntity"})
public final class RuleEntity extends org.cloudfoundry.client.v2.securitygroups._RuleEntity {
  private final @Nullable String destination;
  private final @Nullable String ports;
  private final @Nullable String protocol;
  private final @Nullable Integer type;
  private final @Nullable Integer code;
  private final @Nullable Boolean log;

  private RuleEntity(RuleEntity.Builder builder) {
    this.destination = builder.destination;
    this.ports = builder.ports;
    this.protocol = builder.protocol;
    this.type = builder.type;
    this.code = builder.code;
    this.log = builder.log;
  }

  /**
   * The destination
   */
  @JsonProperty("destination")
  @Override
  public @Nullable String getDestination() {
    return destination;
  }

  /**
   * The ports
   */
  @JsonProperty("ports")
  @Override
  public @Nullable String getPorts() {
    return ports;
  }

  /**
   * The protocol
   */
  @JsonProperty("protocol")
  @Override
  public @Nullable String getProtocol() {
    return protocol;
  }

  /**
   * The control signal for icmp
   */
  @JsonProperty("type")
  @Override
  public @Nullable Integer getType() {
    return type;
  }

  /**
   * The control signal for icmp
   */
  @JsonProperty("code")
  @Override
  public @Nullable Integer getCode() {
    return code;
  }

  /**
   * Enables logging for the egress rule
   */
  @JsonProperty("log")
  @Override
  public @Nullable Boolean getLog() {
    return log;
  }

  /**
   * This instance is equal to all instances of {@code RuleEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RuleEntity
        && equalTo((RuleEntity) another);
  }

  private boolean equalTo(RuleEntity another) {
    return Objects.equals(destination, another.destination)
        && Objects.equals(ports, another.ports)
        && Objects.equals(protocol, another.protocol)
        && Objects.equals(type, another.type)
        && Objects.equals(code, another.code)
        && Objects.equals(log, another.log);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code ports}, {@code protocol}, {@code type}, {@code code}, {@code log}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(destination);
    h = h * 17 + Objects.hashCode(ports);
    h = h * 17 + Objects.hashCode(protocol);
    h = h * 17 + Objects.hashCode(type);
    h = h * 17 + Objects.hashCode(code);
    h = h * 17 + Objects.hashCode(log);
    return h;
  }

  /**
   * Prints the immutable value {@code RuleEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RuleEntity{"
        + "destination=" + destination
        + ", ports=" + ports
        + ", protocol=" + protocol
        + ", type=" + type
        + ", code=" + code
        + ", log=" + log
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.securitygroups._RuleEntity {
    String destination;
    String ports;
    String protocol;
    Integer type;
    Integer code;
    Boolean log;
    @JsonProperty("destination")
    public void setDestination(@Nullable String destination) {
      this.destination = destination;
    }
    @JsonProperty("ports")
    public void setPorts(@Nullable String ports) {
      this.ports = ports;
    }
    @JsonProperty("protocol")
    public void setProtocol(@Nullable String protocol) {
      this.protocol = protocol;
    }
    @JsonProperty("type")
    public void setType(@Nullable Integer type) {
      this.type = type;
    }
    @JsonProperty("code")
    public void setCode(@Nullable Integer code) {
      this.code = code;
    }
    @JsonProperty("log")
    public void setLog(@Nullable Boolean log) {
      this.log = log;
    }
    @Override
    public String getDestination() { throw new UnsupportedOperationException(); }
    @Override
    public String getPorts() { throw new UnsupportedOperationException(); }
    @Override
    public String getProtocol() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getCode() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static RuleEntity fromJson(Json json) {
    RuleEntity.Builder builder = RuleEntity.builder();
    if (json.destination != null) {
      builder.destination(json.destination);
    }
    if (json.ports != null) {
      builder.ports(json.ports);
    }
    if (json.protocol != null) {
      builder.protocol(json.protocol);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.code != null) {
      builder.code(json.code);
    }
    if (json.log != null) {
      builder.log(json.log);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RuleEntity RuleEntity}.
   * @return A new RuleEntity builder
   */
  public static RuleEntity.Builder builder() {
    return new RuleEntity.Builder();
  }

  /**
   * Builds instances of type {@link RuleEntity RuleEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String destination;
    private String ports;
    private String protocol;
    private Integer type;
    private Integer code;
    private Boolean log;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RuleEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RuleEntity instance) {
      return from((_RuleEntity) instance);
    }

    /**
     * Copy abstract value type {@code _RuleEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RuleEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String destinationValue = instance.getDestination();
      if (destinationValue != null) {
        destination(destinationValue);
      }
      String portsValue = instance.getPorts();
      if (portsValue != null) {
        ports(portsValue);
      }
      String protocolValue = instance.getProtocol();
      if (protocolValue != null) {
        protocol(protocolValue);
      }
      Integer typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      Integer codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      Boolean logValue = instance.getLog();
      if (logValue != null) {
        log(logValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _RuleEntity#getDestination() destination} attribute.
     * @param destination The value for destination (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(@Nullable String destination) {
      this.destination = destination;
      return this;
    }

    /**
     * Initializes the value for the {@link _RuleEntity#getPorts() ports} attribute.
     * @param ports The value for ports (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(@Nullable String ports) {
      this.ports = ports;
      return this;
    }

    /**
     * Initializes the value for the {@link _RuleEntity#getProtocol() protocol} attribute.
     * @param protocol The value for protocol (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocol(@Nullable String protocol) {
      this.protocol = protocol;
      return this;
    }

    /**
     * Initializes the value for the {@link _RuleEntity#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable Integer type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link _RuleEntity#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder code(@Nullable Integer code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link _RuleEntity#getLog() log} attribute.
     * @param log The value for log (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder log(@Nullable Boolean log) {
      this.log = log;
      return this;
    }

    /**
     * Builds a new {@link RuleEntity RuleEntity}.
     * @return An immutable instance of RuleEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RuleEntity build() {
      return new RuleEntity(this);
    }
  }
}
