package org.cloudfoundry.client.v2.servicebindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _DeleteServiceBindingRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteServiceBindingRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DeleteServiceBindingRequest"})
public final class DeleteServiceBindingRequest
    extends org.cloudfoundry.client.v2.servicebindings._DeleteServiceBindingRequest {
  private final @Nullable Boolean async;
  private final String serviceBindingId;

  private DeleteServiceBindingRequest(DeleteServiceBindingRequest.Builder builder) {
    this.async = builder.async;
    this.serviceBindingId = builder.serviceBindingId;
  }

  /**
   * The async flag
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The service binding id
   */
  @Override
  public String getServiceBindingId() {
    return serviceBindingId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceBindingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceBindingRequest
        && equalTo((DeleteServiceBindingRequest) another);
  }

  private boolean equalTo(DeleteServiceBindingRequest another) {
    return Objects.equals(async, another.async)
        && serviceBindingId.equals(another.serviceBindingId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code serviceBindingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(async);
    h = h * 17 + serviceBindingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceBindingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceBindingRequest{"
        + "async=" + async
        + ", serviceBindingId=" + serviceBindingId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceBindingRequest DeleteServiceBindingRequest}.
   * @return A new DeleteServiceBindingRequest builder
   */
  public static DeleteServiceBindingRequest.Builder builder() {
    return new DeleteServiceBindingRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceBindingRequest DeleteServiceBindingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BINDING_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String serviceBindingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceBindingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceBindingRequest instance) {
      return from((_DeleteServiceBindingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceBindingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceBindingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      serviceBindingId(instance.getServiceBindingId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServiceBindingRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServiceBindingRequest#getServiceBindingId() serviceBindingId} attribute.
     * @param serviceBindingId The value for serviceBindingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String serviceBindingId) {
      this.serviceBindingId = Objects.requireNonNull(serviceBindingId, "serviceBindingId");
      initBits &= ~INIT_BIT_SERVICE_BINDING_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceBindingRequest DeleteServiceBindingRequest}.
     * @return An immutable instance of DeleteServiceBindingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceBindingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceBindingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_BINDING_ID) != 0) attributes.add("serviceBindingId");
      return "Cannot build DeleteServiceBindingRequest, some of required attributes are not set " + attributes;
    }
  }
}
