package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _ServiceBindingEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ServiceBindingEntity.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ServiceBindingEntity"})
public final class ServiceBindingEntity
    extends org.cloudfoundry.client.v2.servicebindings._ServiceBindingEntity {
  private final @Nullable String applicationId;
  private final @Nullable String applicationUrl;
  private final @Nullable Map<String, Object> bindingOptions;
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable Map<String, Object> gatewayDatas;
  private final @Nullable String gatewayName;
  private final @Nullable String serviceInstanceId;
  private final @Nullable String serviceInstanceUrl;
  private final @Nullable String syslogDrainUrl;

  private ServiceBindingEntity(ServiceBindingEntity.Builder builder) {
    this.applicationId = builder.applicationId;
    this.applicationUrl = builder.applicationUrl;
    this.bindingOptions = builder.bindingOptions == null ? null : createUnmodifiableMap(false, false, builder.bindingOptions);
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.gatewayDatas = builder.gatewayDatas == null ? null : createUnmodifiableMap(false, false, builder.gatewayDatas);
    this.gatewayName = builder.gatewayName;
    this.serviceInstanceId = builder.serviceInstanceId;
    this.serviceInstanceUrl = builder.serviceInstanceUrl;
    this.syslogDrainUrl = builder.syslogDrainUrl;
  }

  /**
   * The application id
   */
  @JsonProperty("app_guid")
  @Override
  public @Nullable String getApplicationId() {
    return applicationId;
  }

  /**
   * The application url
   */
  @JsonProperty("app_url")
  @Override
  public @Nullable String getApplicationUrl() {
    return applicationUrl;
  }

  /**
   * The binding options
   */
  @JsonProperty("binding_options")
  @Override
  public @Nullable Map<String, Object> getBindingOptions() {
    return bindingOptions;
  }

  /**
   * The credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The gateway data
   */
  @JsonProperty("gateway_data")
  @Override
  public @Nullable Map<String, Object> getGatewayDatas() {
    return gatewayDatas;
  }

  /**
   * The gateway name
   */
  @JsonProperty("gateway_name")
  @Override
  public @Nullable String getGatewayName() {
    return gatewayName;
  }

  /**
   * The service instance id
   */
  @JsonProperty("service_instance_guid")
  @Override
  public @Nullable String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The service instance url
   */
  @JsonProperty("service_instance_url")
  @Override
  public @Nullable String getServiceInstanceUrl() {
    return serviceInstanceUrl;
  }

  /**
   * The syslog drain url
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBindingEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBindingEntity
        && equalTo((ServiceBindingEntity) another);
  }

  private boolean equalTo(ServiceBindingEntity another) {
    return Objects.equals(applicationId, another.applicationId)
        && Objects.equals(applicationUrl, another.applicationUrl)
        && Objects.equals(bindingOptions, another.bindingOptions)
        && Objects.equals(credentials, another.credentials)
        && Objects.equals(gatewayDatas, another.gatewayDatas)
        && Objects.equals(gatewayName, another.gatewayName)
        && Objects.equals(serviceInstanceId, another.serviceInstanceId)
        && Objects.equals(serviceInstanceUrl, another.serviceInstanceUrl)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code applicationUrl}, {@code bindingOptions}, {@code credentials}, {@code gatewayDatas}, {@code gatewayName}, {@code serviceInstanceId}, {@code serviceInstanceUrl}, {@code syslogDrainUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applicationId);
    h = h * 17 + Objects.hashCode(applicationUrl);
    h = h * 17 + Objects.hashCode(bindingOptions);
    h = h * 17 + Objects.hashCode(credentials);
    h = h * 17 + Objects.hashCode(gatewayDatas);
    h = h * 17 + Objects.hashCode(gatewayName);
    h = h * 17 + Objects.hashCode(serviceInstanceId);
    h = h * 17 + Objects.hashCode(serviceInstanceUrl);
    h = h * 17 + Objects.hashCode(syslogDrainUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBindingEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBindingEntity{"
        + "applicationId=" + applicationId
        + ", applicationUrl=" + applicationUrl
        + ", bindingOptions=" + bindingOptions
        + ", credentials=" + credentials
        + ", gatewayDatas=" + gatewayDatas
        + ", gatewayName=" + gatewayName
        + ", serviceInstanceId=" + serviceInstanceId
        + ", serviceInstanceUrl=" + serviceInstanceUrl
        + ", syslogDrainUrl=" + syslogDrainUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.servicebindings._ServiceBindingEntity {
    String applicationId;
    String applicationUrl;
    Map<String, Object> bindingOptions;
    Map<String, Object> credentials;
    Map<String, Object> gatewayDatas;
    String gatewayName;
    String serviceInstanceId;
    String serviceInstanceUrl;
    String syslogDrainUrl;
    @JsonProperty("app_guid")
    public void setApplicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("app_url")
    public void setApplicationUrl(@Nullable String applicationUrl) {
      this.applicationUrl = applicationUrl;
    }
    @JsonProperty("binding_options")
    public void setBindingOptions(@Nullable Map<String, Object> bindingOptions) {
      this.bindingOptions = bindingOptions;
    }
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("gateway_data")
    public void setGatewayDatas(@Nullable Map<String, Object> gatewayDatas) {
      this.gatewayDatas = gatewayDatas;
    }
    @JsonProperty("gateway_name")
    public void setGatewayName(@Nullable String gatewayName) {
      this.gatewayName = gatewayName;
    }
    @JsonProperty("service_instance_guid")
    public void setServiceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
    }
    @JsonProperty("service_instance_url")
    public void setServiceInstanceUrl(@Nullable String serviceInstanceUrl) {
      this.serviceInstanceUrl = serviceInstanceUrl;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getBindingOptions() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getGatewayDatas() { throw new UnsupportedOperationException(); }
    @Override
    public String getGatewayName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ServiceBindingEntity fromJson(Json json) {
    ServiceBindingEntity.Builder builder = ServiceBindingEntity.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.applicationUrl != null) {
      builder.applicationUrl(json.applicationUrl);
    }
    if (json.bindingOptions != null) {
      builder.putAllBindingOptions(json.bindingOptions);
    }
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.gatewayDatas != null) {
      builder.putAllGatewayDatas(json.gatewayDatas);
    }
    if (json.gatewayName != null) {
      builder.gatewayName(json.gatewayName);
    }
    if (json.serviceInstanceId != null) {
      builder.serviceInstanceId(json.serviceInstanceId);
    }
    if (json.serviceInstanceUrl != null) {
      builder.serviceInstanceUrl(json.serviceInstanceUrl);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceBindingEntity ServiceBindingEntity}.
   * @return A new ServiceBindingEntity builder
   */
  public static ServiceBindingEntity.Builder builder() {
    return new ServiceBindingEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBindingEntity ServiceBindingEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String applicationId;
    private String applicationUrl;
    private Map<String, Object> bindingOptions = null;
    private Map<String, Object> credentials = null;
    private Map<String, Object> gatewayDatas = null;
    private String gatewayName;
    private String serviceInstanceId;
    private String serviceInstanceUrl;
    private String syslogDrainUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBindingEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBindingEntity instance) {
      return from((_ServiceBindingEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBindingEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBindingEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String applicationIdValue = instance.getApplicationId();
      if (applicationIdValue != null) {
        applicationId(applicationIdValue);
      }
      String applicationUrlValue = instance.getApplicationUrl();
      if (applicationUrlValue != null) {
        applicationUrl(applicationUrlValue);
      }
      Map<String, Object> bindingOptionsValue = instance.getBindingOptions();
      if (bindingOptionsValue != null) {
        putAllBindingOptions(bindingOptionsValue);
      }
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      Map<String, Object> gatewayDatasValue = instance.getGatewayDatas();
      if (gatewayDatasValue != null) {
        putAllGatewayDatas(gatewayDatasValue);
      }
      String gatewayNameValue = instance.getGatewayName();
      if (gatewayNameValue != null) {
        gatewayName(gatewayNameValue);
      }
      String serviceInstanceIdValue = instance.getServiceInstanceId();
      if (serviceInstanceIdValue != null) {
        serviceInstanceId(serviceInstanceIdValue);
      }
      String serviceInstanceUrlValue = instance.getServiceInstanceUrl();
      if (serviceInstanceUrlValue != null) {
        serviceInstanceUrl(serviceInstanceUrlValue);
      }
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceBindingEntity#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceBindingEntity#getApplicationUrl() applicationUrl} attribute.
     * @param applicationUrl The value for applicationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationUrl(@Nullable String applicationUrl) {
      this.applicationUrl = applicationUrl;
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingEntity#getBindingOptions() bindingOptions} map.
     * @param key The key in the bindingOptions map
     * @param value The associated value in the bindingOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindingOption(String key, Object value) {
      if (this.bindingOptions == null) {
        this.bindingOptions = new LinkedHashMap<String, Object>();
      }
      this.bindingOptions.put(
          Objects.requireNonNull(key, "bindingOptions key"),
          Objects.requireNonNull(value, "bindingOptions value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingEntity#getBindingOptions() bindingOptions} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindingOption(Map.Entry<String, ? extends Object> entry) {
      if (this.bindingOptions == null) {
        this.bindingOptions = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.bindingOptions.put(
          Objects.requireNonNull(k, "bindingOptions key"),
          Objects.requireNonNull(v, "bindingOptions value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ServiceBindingEntity#getBindingOptions() bindingOptions} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param bindingOptions The entries that will be added to the bindingOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindingOptions(@Nullable Map<String, ? extends Object> bindingOptions) {
      if (bindingOptions == null) {
        this.bindingOptions = null;
        return this;
      }
      this.bindingOptions = new LinkedHashMap<String, Object>();
      return putAllBindingOptions(bindingOptions);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ServiceBindingEntity#getBindingOptions() bindingOptions} map. Nulls are not permitted
     * @param bindingOptions The entries that will be added to the bindingOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllBindingOptions(Map<String, ? extends Object> bindingOptions) {
      if (this.bindingOptions == null) {
        this.bindingOptions = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : bindingOptions.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.bindingOptions.put(
            Objects.requireNonNull(k, "bindingOptions key"),
            Objects.requireNonNull(v, "bindingOptions value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingEntity#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(
          Objects.requireNonNull(key, "credentials key"),
          Objects.requireNonNull(value, "credentials value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(
          Objects.requireNonNull(k, "credentials key"),
          Objects.requireNonNull(v, "credentials value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ServiceBindingEntity#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
      if (credentials == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(credentials);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ServiceBindingEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.credentials.put(
            Objects.requireNonNull(k, "credentials key"),
            Objects.requireNonNull(v, "credentials value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingEntity#getGatewayDatas() gatewayDatas} map.
     * @param key The key in the gatewayDatas map
     * @param value The associated value in the gatewayDatas map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayData(String key, Object value) {
      if (this.gatewayDatas == null) {
        this.gatewayDatas = new LinkedHashMap<String, Object>();
      }
      this.gatewayDatas.put(
          Objects.requireNonNull(key, "gatewayDatas key"),
          Objects.requireNonNull(value, "gatewayDatas value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingEntity#getGatewayDatas() gatewayDatas} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayData(Map.Entry<String, ? extends Object> entry) {
      if (this.gatewayDatas == null) {
        this.gatewayDatas = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.gatewayDatas.put(
          Objects.requireNonNull(k, "gatewayDatas key"),
          Objects.requireNonNull(v, "gatewayDatas value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ServiceBindingEntity#getGatewayDatas() gatewayDatas} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param gatewayDatas The entries that will be added to the gatewayDatas map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayDatas(@Nullable Map<String, ? extends Object> gatewayDatas) {
      if (gatewayDatas == null) {
        this.gatewayDatas = null;
        return this;
      }
      this.gatewayDatas = new LinkedHashMap<String, Object>();
      return putAllGatewayDatas(gatewayDatas);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ServiceBindingEntity#getGatewayDatas() gatewayDatas} map. Nulls are not permitted
     * @param gatewayDatas The entries that will be added to the gatewayDatas map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGatewayDatas(Map<String, ? extends Object> gatewayDatas) {
      if (this.gatewayDatas == null) {
        this.gatewayDatas = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : gatewayDatas.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.gatewayDatas.put(
            Objects.requireNonNull(k, "gatewayDatas key"),
            Objects.requireNonNull(v, "gatewayDatas value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceBindingEntity#getGatewayName() gatewayName} attribute.
     * @param gatewayName The value for gatewayName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayName(@Nullable String gatewayName) {
      this.gatewayName = gatewayName;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceBindingEntity#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceBindingEntity#getServiceInstanceUrl() serviceInstanceUrl} attribute.
     * @param serviceInstanceUrl The value for serviceInstanceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceUrl(@Nullable String serviceInstanceUrl) {
      this.serviceInstanceUrl = serviceInstanceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceBindingEntity#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Builds a new {@link ServiceBindingEntity ServiceBindingEntity}.
     * @return An immutable instance of ServiceBindingEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBindingEntity build() {
      return new ServiceBindingEntity(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
