package org.cloudfoundry.client.v2.servicebrokers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _UpdateServiceBrokerRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateServiceBrokerRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UpdateServiceBrokerRequest"})
public final class UpdateServiceBrokerRequest
    extends org.cloudfoundry.client.v2.servicebrokers._UpdateServiceBrokerRequest {
  private final @Nullable String authenticationPassword;
  private final @Nullable String authenticationUsername;
  private final @Nullable String brokerUrl;
  private final @Nullable String name;
  private final String serviceBrokerId;

  private UpdateServiceBrokerRequest(UpdateServiceBrokerRequest.Builder builder) {
    this.authenticationPassword = builder.authenticationPassword;
    this.authenticationUsername = builder.authenticationUsername;
    this.brokerUrl = builder.brokerUrl;
    this.name = builder.name;
    this.serviceBrokerId = builder.serviceBrokerId;
  }

  /**
   * The password with which to authenticate against the service broker.
   */
  @Override
  public @Nullable String getAuthenticationPassword() {
    return authenticationPassword;
  }

  /**
   * The username with which to authenticate against the service broker.
   */
  @Override
  public @Nullable String getAuthenticationUsername() {
    return authenticationUsername;
  }

  /**
   * The url of the service broker.
   */
  @Override
  public @Nullable String getBrokerUrl() {
    return brokerUrl;
  }

  /**
   * The name of the service broker.
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The service broker id
   */
  @Override
  public String getServiceBrokerId() {
    return serviceBrokerId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceBrokerRequest
        && equalTo((UpdateServiceBrokerRequest) another);
  }

  private boolean equalTo(UpdateServiceBrokerRequest another) {
    return Objects.equals(authenticationPassword, another.authenticationPassword)
        && Objects.equals(authenticationUsername, another.authenticationUsername)
        && Objects.equals(brokerUrl, another.brokerUrl)
        && Objects.equals(name, another.name)
        && serviceBrokerId.equals(another.serviceBrokerId);
  }

  /**
   * Computes a hash code from attributes: {@code authenticationPassword}, {@code authenticationUsername}, {@code brokerUrl}, {@code name}, {@code serviceBrokerId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(authenticationPassword);
    h = h * 17 + Objects.hashCode(authenticationUsername);
    h = h * 17 + Objects.hashCode(brokerUrl);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + serviceBrokerId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceBrokerRequest{"
        + "authenticationPassword=" + authenticationPassword
        + ", authenticationUsername=" + authenticationUsername
        + ", brokerUrl=" + brokerUrl
        + ", name=" + name
        + ", serviceBrokerId=" + serviceBrokerId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * @return A new UpdateServiceBrokerRequest builder
   */
  public static UpdateServiceBrokerRequest.Builder builder() {
    return new UpdateServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BROKER_ID = 0x1L;
    private long initBits = 0x1L;

    private String authenticationPassword;
    private String authenticationUsername;
    private String brokerUrl;
    private String name;
    private String serviceBrokerId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceBrokerRequest instance) {
      return from((_UpdateServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String authenticationPasswordValue = instance.getAuthenticationPassword();
      if (authenticationPasswordValue != null) {
        authenticationPassword(authenticationPasswordValue);
      }
      String authenticationUsernameValue = instance.getAuthenticationUsername();
      if (authenticationUsernameValue != null) {
        authenticationUsername(authenticationUsernameValue);
      }
      String brokerUrlValue = instance.getBrokerUrl();
      if (brokerUrlValue != null) {
        brokerUrl(brokerUrlValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      serviceBrokerId(instance.getServiceBrokerId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceBrokerRequest#getAuthenticationPassword() authenticationPassword} attribute.
     * @param authenticationPassword The value for authenticationPassword (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authenticationPassword(@Nullable String authenticationPassword) {
      this.authenticationPassword = authenticationPassword;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceBrokerRequest#getAuthenticationUsername() authenticationUsername} attribute.
     * @param authenticationUsername The value for authenticationUsername (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authenticationUsername(@Nullable String authenticationUsername) {
      this.authenticationUsername = authenticationUsername;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceBrokerRequest#getBrokerUrl() brokerUrl} attribute.
     * @param brokerUrl The value for brokerUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder brokerUrl(@Nullable String brokerUrl) {
      this.brokerUrl = brokerUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceBrokerRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceBrokerRequest#getServiceBrokerId() serviceBrokerId} attribute.
     * @param serviceBrokerId The value for serviceBrokerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String serviceBrokerId) {
      this.serviceBrokerId = Objects.requireNonNull(serviceBrokerId, "serviceBrokerId");
      initBits &= ~INIT_BIT_SERVICE_BROKER_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
     * @return An immutable instance of UpdateServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_BROKER_ID) != 0) attributes.add("serviceBrokerId");
      return "Cannot build UpdateServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
