package org.cloudfoundry.client.v2.serviceplanvisibilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _DeleteServicePlanVisibilityRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteServicePlanVisibilityRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DeleteServicePlanVisibilityRequest"})
public final class DeleteServicePlanVisibilityRequest
    extends org.cloudfoundry.client.v2.serviceplanvisibilities._DeleteServicePlanVisibilityRequest {
  private final @Nullable Boolean async;
  private final String servicePlanVisibilityId;

  private DeleteServicePlanVisibilityRequest(DeleteServicePlanVisibilityRequest.Builder builder) {
    this.async = builder.async;
    this.servicePlanVisibilityId = builder.servicePlanVisibilityId;
  }

  /**
   * The async flag
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The service plan visibility id
   */
  @Override
  public String getServicePlanVisibilityId() {
    return servicePlanVisibilityId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServicePlanVisibilityRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServicePlanVisibilityRequest
        && equalTo((DeleteServicePlanVisibilityRequest) another);
  }

  private boolean equalTo(DeleteServicePlanVisibilityRequest another) {
    return Objects.equals(async, another.async)
        && servicePlanVisibilityId.equals(another.servicePlanVisibilityId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code servicePlanVisibilityId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(async);
    h = h * 17 + servicePlanVisibilityId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServicePlanVisibilityRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServicePlanVisibilityRequest{"
        + "async=" + async
        + ", servicePlanVisibilityId=" + servicePlanVisibilityId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServicePlanVisibilityRequest DeleteServicePlanVisibilityRequest}.
   * @return A new DeleteServicePlanVisibilityRequest builder
   */
  public static DeleteServicePlanVisibilityRequest.Builder builder() {
    return new DeleteServicePlanVisibilityRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServicePlanVisibilityRequest DeleteServicePlanVisibilityRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_PLAN_VISIBILITY_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String servicePlanVisibilityId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServicePlanVisibilityRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServicePlanVisibilityRequest instance) {
      return from((_DeleteServicePlanVisibilityRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServicePlanVisibilityRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServicePlanVisibilityRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      servicePlanVisibilityId(instance.getServicePlanVisibilityId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServicePlanVisibilityRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServicePlanVisibilityRequest#getServicePlanVisibilityId() servicePlanVisibilityId} attribute.
     * @param servicePlanVisibilityId The value for servicePlanVisibilityId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanVisibilityId(String servicePlanVisibilityId) {
      this.servicePlanVisibilityId = Objects.requireNonNull(servicePlanVisibilityId, "servicePlanVisibilityId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_VISIBILITY_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServicePlanVisibilityRequest DeleteServicePlanVisibilityRequest}.
     * @return An immutable instance of DeleteServicePlanVisibilityRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServicePlanVisibilityRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServicePlanVisibilityRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_PLAN_VISIBILITY_ID) != 0) attributes.add("servicePlanVisibilityId");
      return "Cannot build DeleteServicePlanVisibilityRequest, some of required attributes are not set " + attributes;
    }
  }
}
