package org.cloudfoundry.client.v2.spacequotadefinitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _RemoveSpaceQuotaDefinitionRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code RemoveSpaceQuotaDefinitionRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_RemoveSpaceQuotaDefinitionRequest"})
public final class RemoveSpaceQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.spacequotadefinitions._RemoveSpaceQuotaDefinitionRequest {
  private final String spaceId;
  private final String spaceQuotaDefinitionId;

  private RemoveSpaceQuotaDefinitionRequest(RemoveSpaceQuotaDefinitionRequest.Builder builder) {
    this.spaceId = builder.spaceId;
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The space quota definition id
   */
  @Override
  public String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSpaceQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSpaceQuotaDefinitionRequest
        && equalTo((RemoveSpaceQuotaDefinitionRequest) another);
  }

  private boolean equalTo(RemoveSpaceQuotaDefinitionRequest another) {
    return spaceId.equals(another.spaceId)
        && spaceQuotaDefinitionId.equals(another.spaceQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code spaceId}, {@code spaceQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + spaceId.hashCode();
    h = h * 17 + spaceQuotaDefinitionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSpaceQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSpaceQuotaDefinitionRequest{"
        + "spaceId=" + spaceId
        + ", spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveSpaceQuotaDefinitionRequest RemoveSpaceQuotaDefinitionRequest}.
   * @return A new RemoveSpaceQuotaDefinitionRequest builder
   */
  public static RemoveSpaceQuotaDefinitionRequest.Builder builder() {
    return new RemoveSpaceQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSpaceQuotaDefinitionRequest RemoveSpaceQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private static final long INIT_BIT_SPACE_QUOTA_DEFINITION_ID = 0x2L;
    private long initBits = 0x3L;

    private String spaceId;
    private String spaceQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSpaceQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSpaceQuotaDefinitionRequest instance) {
      return from((_RemoveSpaceQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSpaceQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSpaceQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceId(instance.getSpaceId());
      spaceQuotaDefinitionId(instance.getSpaceQuotaDefinitionId());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveSpaceQuotaDefinitionRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveSpaceQuotaDefinitionRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = Objects.requireNonNull(spaceQuotaDefinitionId, "spaceQuotaDefinitionId");
      initBits &= ~INIT_BIT_SPACE_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveSpaceQuotaDefinitionRequest RemoveSpaceQuotaDefinitionRequest}.
     * @return An immutable instance of RemoveSpaceQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSpaceQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSpaceQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      if ((initBits & INIT_BIT_SPACE_QUOTA_DEFINITION_ID) != 0) attributes.add("spaceQuotaDefinitionId");
      return "Cannot build RemoveSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
