package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _SpaceEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SpaceEntity.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_SpaceEntity"})
public final class SpaceEntity extends org.cloudfoundry.client.v2.spaces._SpaceEntity {
  private final @Nullable Boolean allowSsh;
  private final @Nullable String applicationEventsUrl;
  private final @Nullable String applicationsUrl;
  private final @Nullable String auditorsUrl;
  private final @Nullable String developersUrl;
  private final @Nullable String domainsUrl;
  private final @Nullable String eventsUrl;
  private final @Nullable String managersUrl;
  private final @Nullable String name;
  private final @Nullable String organizationId;
  private final @Nullable String organizationUrl;
  private final @Nullable String routesUrl;
  private final @Nullable String securityGroupsUrl;
  private final @Nullable String serviceInstancesUrl;
  private final @Nullable String spaceQuotaDefinitionId;

  private SpaceEntity(SpaceEntity.Builder builder) {
    this.allowSsh = builder.allowSsh;
    this.applicationEventsUrl = builder.applicationEventsUrl;
    this.applicationsUrl = builder.applicationsUrl;
    this.auditorsUrl = builder.auditorsUrl;
    this.developersUrl = builder.developersUrl;
    this.domainsUrl = builder.domainsUrl;
    this.eventsUrl = builder.eventsUrl;
    this.managersUrl = builder.managersUrl;
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.organizationUrl = builder.organizationUrl;
    this.routesUrl = builder.routesUrl;
    this.securityGroupsUrl = builder.securityGroupsUrl;
    this.serviceInstancesUrl = builder.serviceInstancesUrl;
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
  }

  /**
   * Allow SSH
   */
  @JsonProperty("allow_ssh")
  @Override
  public @Nullable Boolean getAllowSsh() {
    return allowSsh;
  }

  /**
   * The application events url
   */
  @JsonProperty("app_events_url")
  @Override
  public @Nullable String getApplicationEventsUrl() {
    return applicationEventsUrl;
  }

  /**
   * The applications url
   */
  @JsonProperty("apps_url")
  @Override
  public @Nullable String getApplicationsUrl() {
    return applicationsUrl;
  }

  /**
   * The auditors url
   */
  @JsonProperty("auditors_url")
  @Override
  public @Nullable String getAuditorsUrl() {
    return auditorsUrl;
  }

  /**
   * The developers url
   */
  @JsonProperty("developers_url")
  @Override
  public @Nullable String getDevelopersUrl() {
    return developersUrl;
  }

  /**
   * The domains url
   */
  @JsonProperty("domains_url")
  @Override
  public @Nullable String getDomainsUrl() {
    return domainsUrl;
  }

  /**
   * The events url
   */
  @JsonProperty("events_url")
  @Override
  public @Nullable String getEventsUrl() {
    return eventsUrl;
  }

  /**
   * The managers url
   */
  @JsonProperty("managers_url")
  @Override
  public @Nullable String getManagersUrl() {
    return managersUrl;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The organization url
   */
  @JsonProperty("organization_url")
  @Override
  public @Nullable String getOrganizationUrl() {
    return organizationUrl;
  }

  /**
   * The routes url
   */
  @JsonProperty("routes_url")
  @Override
  public @Nullable String getRoutesUrl() {
    return routesUrl;
  }

  /**
   * The security groups url
   */
  @JsonProperty("security_groups_url")
  @Override
  public @Nullable String getSecurityGroupsUrl() {
    return securityGroupsUrl;
  }

  /**
   * The service instances url
   */
  @JsonProperty("service_instances_url")
  @Override
  public @Nullable String getServiceInstancesUrl() {
    return serviceInstancesUrl;
  }

  /**
   * The space quota definition id
   */
  @JsonProperty("space_quota_definition_guid")
  @Override
  public @Nullable String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code SpaceEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceEntity
        && equalTo((SpaceEntity) another);
  }

  private boolean equalTo(SpaceEntity another) {
    return Objects.equals(allowSsh, another.allowSsh)
        && Objects.equals(applicationEventsUrl, another.applicationEventsUrl)
        && Objects.equals(applicationsUrl, another.applicationsUrl)
        && Objects.equals(auditorsUrl, another.auditorsUrl)
        && Objects.equals(developersUrl, another.developersUrl)
        && Objects.equals(domainsUrl, another.domainsUrl)
        && Objects.equals(eventsUrl, another.eventsUrl)
        && Objects.equals(managersUrl, another.managersUrl)
        && Objects.equals(name, another.name)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(organizationUrl, another.organizationUrl)
        && Objects.equals(routesUrl, another.routesUrl)
        && Objects.equals(securityGroupsUrl, another.securityGroupsUrl)
        && Objects.equals(serviceInstancesUrl, another.serviceInstancesUrl)
        && Objects.equals(spaceQuotaDefinitionId, another.spaceQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code allowSsh}, {@code applicationEventsUrl}, {@code applicationsUrl}, {@code auditorsUrl}, {@code developersUrl}, {@code domainsUrl}, {@code eventsUrl}, {@code managersUrl}, {@code name}, {@code organizationId}, {@code organizationUrl}, {@code routesUrl}, {@code securityGroupsUrl}, {@code serviceInstancesUrl}, {@code spaceQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(allowSsh);
    h = h * 17 + Objects.hashCode(applicationEventsUrl);
    h = h * 17 + Objects.hashCode(applicationsUrl);
    h = h * 17 + Objects.hashCode(auditorsUrl);
    h = h * 17 + Objects.hashCode(developersUrl);
    h = h * 17 + Objects.hashCode(domainsUrl);
    h = h * 17 + Objects.hashCode(eventsUrl);
    h = h * 17 + Objects.hashCode(managersUrl);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(organizationId);
    h = h * 17 + Objects.hashCode(organizationUrl);
    h = h * 17 + Objects.hashCode(routesUrl);
    h = h * 17 + Objects.hashCode(securityGroupsUrl);
    h = h * 17 + Objects.hashCode(serviceInstancesUrl);
    h = h * 17 + Objects.hashCode(spaceQuotaDefinitionId);
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpaceEntity{"
        + "allowSsh=" + allowSsh
        + ", applicationEventsUrl=" + applicationEventsUrl
        + ", applicationsUrl=" + applicationsUrl
        + ", auditorsUrl=" + auditorsUrl
        + ", developersUrl=" + developersUrl
        + ", domainsUrl=" + domainsUrl
        + ", eventsUrl=" + eventsUrl
        + ", managersUrl=" + managersUrl
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", organizationUrl=" + organizationUrl
        + ", routesUrl=" + routesUrl
        + ", securityGroupsUrl=" + securityGroupsUrl
        + ", serviceInstancesUrl=" + serviceInstancesUrl
        + ", spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.spaces._SpaceEntity {
    Boolean allowSsh;
    String applicationEventsUrl;
    String applicationsUrl;
    String auditorsUrl;
    String developersUrl;
    String domainsUrl;
    String eventsUrl;
    String managersUrl;
    String name;
    String organizationId;
    String organizationUrl;
    String routesUrl;
    String securityGroupsUrl;
    String serviceInstancesUrl;
    String spaceQuotaDefinitionId;
    @JsonProperty("allow_ssh")
    public void setAllowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
    }
    @JsonProperty("app_events_url")
    public void setApplicationEventsUrl(@Nullable String applicationEventsUrl) {
      this.applicationEventsUrl = applicationEventsUrl;
    }
    @JsonProperty("apps_url")
    public void setApplicationsUrl(@Nullable String applicationsUrl) {
      this.applicationsUrl = applicationsUrl;
    }
    @JsonProperty("auditors_url")
    public void setAuditorsUrl(@Nullable String auditorsUrl) {
      this.auditorsUrl = auditorsUrl;
    }
    @JsonProperty("developers_url")
    public void setDevelopersUrl(@Nullable String developersUrl) {
      this.developersUrl = developersUrl;
    }
    @JsonProperty("domains_url")
    public void setDomainsUrl(@Nullable String domainsUrl) {
      this.domainsUrl = domainsUrl;
    }
    @JsonProperty("events_url")
    public void setEventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
    }
    @JsonProperty("managers_url")
    public void setManagersUrl(@Nullable String managersUrl) {
      this.managersUrl = managersUrl;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("organization_url")
    public void setOrganizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
    }
    @JsonProperty("routes_url")
    public void setRoutesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
    }
    @JsonProperty("security_groups_url")
    public void setSecurityGroupsUrl(@Nullable String securityGroupsUrl) {
      this.securityGroupsUrl = securityGroupsUrl;
    }
    @JsonProperty("service_instances_url")
    public void setServiceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
    }
    @JsonProperty("space_quota_definition_guid")
    public void setSpaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }
    @Override
    public Boolean getAllowSsh() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuditorsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getDevelopersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomainsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getManagersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSecurityGroupsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstancesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceQuotaDefinitionId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SpaceEntity fromJson(Json json) {
    SpaceEntity.Builder builder = SpaceEntity.builder();
    if (json.allowSsh != null) {
      builder.allowSsh(json.allowSsh);
    }
    if (json.applicationEventsUrl != null) {
      builder.applicationEventsUrl(json.applicationEventsUrl);
    }
    if (json.applicationsUrl != null) {
      builder.applicationsUrl(json.applicationsUrl);
    }
    if (json.auditorsUrl != null) {
      builder.auditorsUrl(json.auditorsUrl);
    }
    if (json.developersUrl != null) {
      builder.developersUrl(json.developersUrl);
    }
    if (json.domainsUrl != null) {
      builder.domainsUrl(json.domainsUrl);
    }
    if (json.eventsUrl != null) {
      builder.eventsUrl(json.eventsUrl);
    }
    if (json.managersUrl != null) {
      builder.managersUrl(json.managersUrl);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.organizationUrl != null) {
      builder.organizationUrl(json.organizationUrl);
    }
    if (json.routesUrl != null) {
      builder.routesUrl(json.routesUrl);
    }
    if (json.securityGroupsUrl != null) {
      builder.securityGroupsUrl(json.securityGroupsUrl);
    }
    if (json.serviceInstancesUrl != null) {
      builder.serviceInstancesUrl(json.serviceInstancesUrl);
    }
    if (json.spaceQuotaDefinitionId != null) {
      builder.spaceQuotaDefinitionId(json.spaceQuotaDefinitionId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SpaceEntity SpaceEntity}.
   * @return A new SpaceEntity builder
   */
  public static SpaceEntity.Builder builder() {
    return new SpaceEntity.Builder();
  }

  /**
   * Builds instances of type {@link SpaceEntity SpaceEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean allowSsh;
    private String applicationEventsUrl;
    private String applicationsUrl;
    private String auditorsUrl;
    private String developersUrl;
    private String domainsUrl;
    private String eventsUrl;
    private String managersUrl;
    private String name;
    private String organizationId;
    private String organizationUrl;
    private String routesUrl;
    private String securityGroupsUrl;
    private String serviceInstancesUrl;
    private String spaceQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceEntity instance) {
      return from((_SpaceEntity) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean allowSshValue = instance.getAllowSsh();
      if (allowSshValue != null) {
        allowSsh(allowSshValue);
      }
      String applicationEventsUrlValue = instance.getApplicationEventsUrl();
      if (applicationEventsUrlValue != null) {
        applicationEventsUrl(applicationEventsUrlValue);
      }
      String applicationsUrlValue = instance.getApplicationsUrl();
      if (applicationsUrlValue != null) {
        applicationsUrl(applicationsUrlValue);
      }
      String auditorsUrlValue = instance.getAuditorsUrl();
      if (auditorsUrlValue != null) {
        auditorsUrl(auditorsUrlValue);
      }
      String developersUrlValue = instance.getDevelopersUrl();
      if (developersUrlValue != null) {
        developersUrl(developersUrlValue);
      }
      String domainsUrlValue = instance.getDomainsUrl();
      if (domainsUrlValue != null) {
        domainsUrl(domainsUrlValue);
      }
      String eventsUrlValue = instance.getEventsUrl();
      if (eventsUrlValue != null) {
        eventsUrl(eventsUrlValue);
      }
      String managersUrlValue = instance.getManagersUrl();
      if (managersUrlValue != null) {
        managersUrl(managersUrlValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      String organizationUrlValue = instance.getOrganizationUrl();
      if (organizationUrlValue != null) {
        organizationUrl(organizationUrlValue);
      }
      String routesUrlValue = instance.getRoutesUrl();
      if (routesUrlValue != null) {
        routesUrl(routesUrlValue);
      }
      String securityGroupsUrlValue = instance.getSecurityGroupsUrl();
      if (securityGroupsUrlValue != null) {
        securityGroupsUrl(securityGroupsUrlValue);
      }
      String serviceInstancesUrlValue = instance.getServiceInstancesUrl();
      if (serviceInstancesUrlValue != null) {
        serviceInstancesUrl(serviceInstancesUrlValue);
      }
      String spaceQuotaDefinitionIdValue = instance.getSpaceQuotaDefinitionId();
      if (spaceQuotaDefinitionIdValue != null) {
        spaceQuotaDefinitionId(spaceQuotaDefinitionIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getAllowSsh() allowSsh} attribute.
     * @param allowSsh The value for allowSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getApplicationEventsUrl() applicationEventsUrl} attribute.
     * @param applicationEventsUrl The value for applicationEventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationEventsUrl(@Nullable String applicationEventsUrl) {
      this.applicationEventsUrl = applicationEventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getApplicationsUrl() applicationsUrl} attribute.
     * @param applicationsUrl The value for applicationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationsUrl(@Nullable String applicationsUrl) {
      this.applicationsUrl = applicationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getAuditorsUrl() auditorsUrl} attribute.
     * @param auditorsUrl The value for auditorsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorsUrl(@Nullable String auditorsUrl) {
      this.auditorsUrl = auditorsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getDevelopersUrl() developersUrl} attribute.
     * @param developersUrl The value for developersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developersUrl(@Nullable String developersUrl) {
      this.developersUrl = developersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getDomainsUrl() domainsUrl} attribute.
     * @param domainsUrl The value for domainsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainsUrl(@Nullable String domainsUrl) {
      this.domainsUrl = domainsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getEventsUrl() eventsUrl} attribute.
     * @param eventsUrl The value for eventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder eventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getManagersUrl() managersUrl} attribute.
     * @param managersUrl The value for managersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managersUrl(@Nullable String managersUrl) {
      this.managersUrl = managersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getOrganizationUrl() organizationUrl} attribute.
     * @param organizationUrl The value for organizationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getRoutesUrl() routesUrl} attribute.
     * @param routesUrl The value for routesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getSecurityGroupsUrl() securityGroupsUrl} attribute.
     * @param securityGroupsUrl The value for securityGroupsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupsUrl(@Nullable String securityGroupsUrl) {
      this.securityGroupsUrl = securityGroupsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getServiceInstancesUrl() serviceInstancesUrl} attribute.
     * @param serviceInstancesUrl The value for serviceInstancesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceEntity#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
      return this;
    }

    /**
     * Builds a new {@link SpaceEntity SpaceEntity}.
     * @return An immutable instance of SpaceEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceEntity build() {
      return new SpaceEntity(this);
    }
  }
}
