package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.*;

/**
 * Immutable implementation of {@link _GetUserProvidedServiceInstanceResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetUserProvidedServiceInstanceResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetUserProvidedServiceInstanceResponse"})
public final class GetUserProvidedServiceInstanceResponse
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._GetUserProvidedServiceInstanceResponse {
  private final @Nullable UserProvidedServiceInstanceEntity entity;
  private final @Nullable Metadata metadata;

  private GetUserProvidedServiceInstanceResponse(GetUserProvidedServiceInstanceResponse.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable UserProvidedServiceInstanceEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code GetUserProvidedServiceInstanceResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetUserProvidedServiceInstanceResponse
        && equalTo((GetUserProvidedServiceInstanceResponse) another);
  }

  private boolean equalTo(GetUserProvidedServiceInstanceResponse another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(entity);
    h = h * 17 + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code GetUserProvidedServiceInstanceResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetUserProvidedServiceInstanceResponse{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json
      extends org.cloudfoundry.client.v2.userprovidedserviceinstances._GetUserProvidedServiceInstanceResponse {
    UserProvidedServiceInstanceEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable UserProvidedServiceInstanceEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public UserProvidedServiceInstanceEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static GetUserProvidedServiceInstanceResponse fromJson(Json json) {
    GetUserProvidedServiceInstanceResponse.Builder builder = GetUserProvidedServiceInstanceResponse.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetUserProvidedServiceInstanceResponse GetUserProvidedServiceInstanceResponse}.
   * @return A new GetUserProvidedServiceInstanceResponse builder
   */
  public static GetUserProvidedServiceInstanceResponse.Builder builder() {
    return new GetUserProvidedServiceInstanceResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetUserProvidedServiceInstanceResponse GetUserProvidedServiceInstanceResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private UserProvidedServiceInstanceEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetUserProvidedServiceInstanceResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetUserProvidedServiceInstanceResponse instance) {
      return from((_GetUserProvidedServiceInstanceResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetUserProvidedServiceInstanceResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetUserProvidedServiceInstanceResponse instance) {
      Objects.requireNonNull(instance, "instance");
      UserProvidedServiceInstanceEntity entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GetUserProvidedServiceInstanceResponse#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder entity(@Nullable UserProvidedServiceInstanceEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetUserProvidedServiceInstanceResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link GetUserProvidedServiceInstanceResponse GetUserProvidedServiceInstanceResponse}.
     * @return An immutable instance of GetUserProvidedServiceInstanceResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetUserProvidedServiceInstanceResponse build() {
      return new GetUserProvidedServiceInstanceResponse(this);
    }
  }
}
