package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * Immutable implementation of {@link _ListUserProvidedServiceInstancesRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ListUserProvidedServiceInstancesRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ListUserProvidedServiceInstancesRequest"})
public final class ListUserProvidedServiceInstancesRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstancesRequest {
  private final @Nullable List<String> names;
  private final @Nullable List<String> organizationIds;
  private final @Nullable List<String> spaceIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListUserProvidedServiceInstancesRequest(ListUserProvidedServiceInstancesRequest.Builder builder) {
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListUserProvidedServiceInstancesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListUserProvidedServiceInstancesRequest
        && equalTo((ListUserProvidedServiceInstancesRequest) another);
  }

  private boolean equalTo(ListUserProvidedServiceInstancesRequest another) {
    return Objects.equals(names, another.names)
        && Objects.equals(organizationIds, another.organizationIds)
        && Objects.equals(spaceIds, another.spaceIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code names}, {@code organizationIds}, {@code spaceIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(names);
    h = h * 17 + Objects.hashCode(organizationIds);
    h = h * 17 + Objects.hashCode(spaceIds);
    h = h * 17 + Objects.hashCode(orderDirection);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListUserProvidedServiceInstancesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListUserProvidedServiceInstancesRequest{"
        + "names=" + names
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListUserProvidedServiceInstancesRequest ListUserProvidedServiceInstancesRequest}.
   * @return A new ListUserProvidedServiceInstancesRequest builder
   */
  public static ListUserProvidedServiceInstancesRequest.Builder builder() {
    return new ListUserProvidedServiceInstancesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListUserProvidedServiceInstancesRequest ListUserProvidedServiceInstancesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> names = null;
    private List<String> organizationIds = null;
    private List<String> spaceIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListUserProvidedServiceInstancesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListUserProvidedServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListUserProvidedServiceInstancesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListUserProvidedServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstancesRequest) {
        org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstancesRequest instance = (org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstancesRequest) object;
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListUserProvidedServiceInstancesRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstancesRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListUserProvidedServiceInstancesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstancesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListUserProvidedServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListUserProvidedServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListUserProvidedServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListUserProvidedServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _ListUserProvidedServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserProvidedServiceInstancesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserProvidedServiceInstancesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserProvidedServiceInstancesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListUserProvidedServiceInstancesRequest ListUserProvidedServiceInstancesRequest}.
     * @return An immutable instance of ListUserProvidedServiceInstancesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListUserProvidedServiceInstancesRequest build() {
      return new ListUserProvidedServiceInstancesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
