package org.cloudfoundry.client.v2.users;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _UserEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UserEntity.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UserEntity"})
public final class UserEntity extends org.cloudfoundry.client.v2.users._UserEntity {
  private final @Nullable Boolean active;
  private final @Nullable Boolean admin;
  private final @Nullable String auditedOrganizationsUrl;
  private final @Nullable String auditedSpacesUrl;
  private final @Nullable String billingManagedOrganizationsUrl;
  private final @Nullable String defaultSpaceId;
  private final @Nullable String defaultSpaceUrl;
  private final @Nullable String managedOrganizationsUrl;
  private final @Nullable String managedSpacesUrl;
  private final @Nullable String organizationsUrl;
  private final @Nullable String spacesUrl;
  private final @Nullable String username;

  private UserEntity(UserEntity.Builder builder) {
    this.active = builder.active;
    this.admin = builder.admin;
    this.auditedOrganizationsUrl = builder.auditedOrganizationsUrl;
    this.auditedSpacesUrl = builder.auditedSpacesUrl;
    this.billingManagedOrganizationsUrl = builder.billingManagedOrganizationsUrl;
    this.defaultSpaceId = builder.defaultSpaceId;
    this.defaultSpaceUrl = builder.defaultSpaceUrl;
    this.managedOrganizationsUrl = builder.managedOrganizationsUrl;
    this.managedSpacesUrl = builder.managedSpacesUrl;
    this.organizationsUrl = builder.organizationsUrl;
    this.spacesUrl = builder.spacesUrl;
    this.username = builder.username;
  }

  /**
   * The active property
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The admin property
   */
  @JsonProperty("admin")
  @Override
  public @Nullable Boolean getAdmin() {
    return admin;
  }

  /**
   * The audited organizations url
   */
  @JsonProperty("audited_organizations_url")
  @Override
  public @Nullable String getAuditedOrganizationsUrl() {
    return auditedOrganizationsUrl;
  }

  /**
   * The audited spaces url
   */
  @JsonProperty("audited_spaces_url")
  @Override
  public @Nullable String getAuditedSpacesUrl() {
    return auditedSpacesUrl;
  }

  /**
   * The billing managed organizations url
   */
  @JsonProperty("billing_managed_organizations_url")
  @Override
  public @Nullable String getBillingManagedOrganizationsUrl() {
    return billingManagedOrganizationsUrl;
  }

  /**
   * The default space id
   */
  @JsonProperty("default_space_guid")
  @Override
  public @Nullable String getDefaultSpaceId() {
    return defaultSpaceId;
  }

  /**
   * The default space url
   */
  @JsonProperty("default_space_url")
  @Override
  public @Nullable String getDefaultSpaceUrl() {
    return defaultSpaceUrl;
  }

  /**
   * The managed organizations url
   */
  @JsonProperty("managed_organizations_url")
  @Override
  public @Nullable String getManagedOrganizationsUrl() {
    return managedOrganizationsUrl;
  }

  /**
   * The managed spaces url
   */
  @JsonProperty("managed_spaces_url")
  @Override
  public @Nullable String getManagedSpacesUrl() {
    return managedSpacesUrl;
  }

  /**
   * The organizations url
   */
  @JsonProperty("organizations_url")
  @Override
  public @Nullable String getOrganizationsUrl() {
    return organizationsUrl;
  }

  /**
   * The spaces url
   */
  @JsonProperty("spaces_url")
  @Override
  public @Nullable String getSpacesUrl() {
    return spacesUrl;
  }

  /**
   * The username
   */
  @JsonProperty("username")
  @Override
  public @Nullable String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code UserEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserEntity
        && equalTo((UserEntity) another);
  }

  private boolean equalTo(UserEntity another) {
    return Objects.equals(active, another.active)
        && Objects.equals(admin, another.admin)
        && Objects.equals(auditedOrganizationsUrl, another.auditedOrganizationsUrl)
        && Objects.equals(auditedSpacesUrl, another.auditedSpacesUrl)
        && Objects.equals(billingManagedOrganizationsUrl, another.billingManagedOrganizationsUrl)
        && Objects.equals(defaultSpaceId, another.defaultSpaceId)
        && Objects.equals(defaultSpaceUrl, another.defaultSpaceUrl)
        && Objects.equals(managedOrganizationsUrl, another.managedOrganizationsUrl)
        && Objects.equals(managedSpacesUrl, another.managedSpacesUrl)
        && Objects.equals(organizationsUrl, another.organizationsUrl)
        && Objects.equals(spacesUrl, another.spacesUrl)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code admin}, {@code auditedOrganizationsUrl}, {@code auditedSpacesUrl}, {@code billingManagedOrganizationsUrl}, {@code defaultSpaceId}, {@code defaultSpaceUrl}, {@code managedOrganizationsUrl}, {@code managedSpacesUrl}, {@code organizationsUrl}, {@code spacesUrl}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(active);
    h = h * 17 + Objects.hashCode(admin);
    h = h * 17 + Objects.hashCode(auditedOrganizationsUrl);
    h = h * 17 + Objects.hashCode(auditedSpacesUrl);
    h = h * 17 + Objects.hashCode(billingManagedOrganizationsUrl);
    h = h * 17 + Objects.hashCode(defaultSpaceId);
    h = h * 17 + Objects.hashCode(defaultSpaceUrl);
    h = h * 17 + Objects.hashCode(managedOrganizationsUrl);
    h = h * 17 + Objects.hashCode(managedSpacesUrl);
    h = h * 17 + Objects.hashCode(organizationsUrl);
    h = h * 17 + Objects.hashCode(spacesUrl);
    h = h * 17 + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code UserEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserEntity{"
        + "active=" + active
        + ", admin=" + admin
        + ", auditedOrganizationsUrl=" + auditedOrganizationsUrl
        + ", auditedSpacesUrl=" + auditedSpacesUrl
        + ", billingManagedOrganizationsUrl=" + billingManagedOrganizationsUrl
        + ", defaultSpaceId=" + defaultSpaceId
        + ", defaultSpaceUrl=" + defaultSpaceUrl
        + ", managedOrganizationsUrl=" + managedOrganizationsUrl
        + ", managedSpacesUrl=" + managedSpacesUrl
        + ", organizationsUrl=" + organizationsUrl
        + ", spacesUrl=" + spacesUrl
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v2.users._UserEntity {
    Boolean active;
    Boolean admin;
    String auditedOrganizationsUrl;
    String auditedSpacesUrl;
    String billingManagedOrganizationsUrl;
    String defaultSpaceId;
    String defaultSpaceUrl;
    String managedOrganizationsUrl;
    String managedSpacesUrl;
    String organizationsUrl;
    String spacesUrl;
    String username;
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("admin")
    public void setAdmin(@Nullable Boolean admin) {
      this.admin = admin;
    }
    @JsonProperty("audited_organizations_url")
    public void setAuditedOrganizationsUrl(@Nullable String auditedOrganizationsUrl) {
      this.auditedOrganizationsUrl = auditedOrganizationsUrl;
    }
    @JsonProperty("audited_spaces_url")
    public void setAuditedSpacesUrl(@Nullable String auditedSpacesUrl) {
      this.auditedSpacesUrl = auditedSpacesUrl;
    }
    @JsonProperty("billing_managed_organizations_url")
    public void setBillingManagedOrganizationsUrl(@Nullable String billingManagedOrganizationsUrl) {
      this.billingManagedOrganizationsUrl = billingManagedOrganizationsUrl;
    }
    @JsonProperty("default_space_guid")
    public void setDefaultSpaceId(@Nullable String defaultSpaceId) {
      this.defaultSpaceId = defaultSpaceId;
    }
    @JsonProperty("default_space_url")
    public void setDefaultSpaceUrl(@Nullable String defaultSpaceUrl) {
      this.defaultSpaceUrl = defaultSpaceUrl;
    }
    @JsonProperty("managed_organizations_url")
    public void setManagedOrganizationsUrl(@Nullable String managedOrganizationsUrl) {
      this.managedOrganizationsUrl = managedOrganizationsUrl;
    }
    @JsonProperty("managed_spaces_url")
    public void setManagedSpacesUrl(@Nullable String managedSpacesUrl) {
      this.managedSpacesUrl = managedSpacesUrl;
    }
    @JsonProperty("organizations_url")
    public void setOrganizationsUrl(@Nullable String organizationsUrl) {
      this.organizationsUrl = organizationsUrl;
    }
    @JsonProperty("spaces_url")
    public void setSpacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
    }
    @JsonProperty("username")
    public void setUsername(@Nullable String username) {
      this.username = username;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAdmin() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuditedOrganizationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuditedSpacesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getBillingManagedOrganizationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getDefaultSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDefaultSpaceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getManagedOrganizationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getManagedSpacesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpacesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UserEntity fromJson(Json json) {
    UserEntity.Builder builder = UserEntity.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.admin != null) {
      builder.admin(json.admin);
    }
    if (json.auditedOrganizationsUrl != null) {
      builder.auditedOrganizationsUrl(json.auditedOrganizationsUrl);
    }
    if (json.auditedSpacesUrl != null) {
      builder.auditedSpacesUrl(json.auditedSpacesUrl);
    }
    if (json.billingManagedOrganizationsUrl != null) {
      builder.billingManagedOrganizationsUrl(json.billingManagedOrganizationsUrl);
    }
    if (json.defaultSpaceId != null) {
      builder.defaultSpaceId(json.defaultSpaceId);
    }
    if (json.defaultSpaceUrl != null) {
      builder.defaultSpaceUrl(json.defaultSpaceUrl);
    }
    if (json.managedOrganizationsUrl != null) {
      builder.managedOrganizationsUrl(json.managedOrganizationsUrl);
    }
    if (json.managedSpacesUrl != null) {
      builder.managedSpacesUrl(json.managedSpacesUrl);
    }
    if (json.organizationsUrl != null) {
      builder.organizationsUrl(json.organizationsUrl);
    }
    if (json.spacesUrl != null) {
      builder.spacesUrl(json.spacesUrl);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserEntity UserEntity}.
   * @return A new UserEntity builder
   */
  public static UserEntity.Builder builder() {
    return new UserEntity.Builder();
  }

  /**
   * Builds instances of type {@link UserEntity UserEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean active;
    private Boolean admin;
    private String auditedOrganizationsUrl;
    private String auditedSpacesUrl;
    private String billingManagedOrganizationsUrl;
    private String defaultSpaceId;
    private String defaultSpaceUrl;
    private String managedOrganizationsUrl;
    private String managedSpacesUrl;
    private String organizationsUrl;
    private String spacesUrl;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.users.AbstractUserEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UserEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractUserEntity) {
        AbstractUserEntity instance = (AbstractUserEntity) object;
        String spacesUrlValue = instance.getSpacesUrl();
        if (spacesUrlValue != null) {
          spacesUrl(spacesUrlValue);
        }
        String auditedSpacesUrlValue = instance.getAuditedSpacesUrl();
        if (auditedSpacesUrlValue != null) {
          auditedSpacesUrl(auditedSpacesUrlValue);
        }
        String managedOrganizationsUrlValue = instance.getManagedOrganizationsUrl();
        if (managedOrganizationsUrlValue != null) {
          managedOrganizationsUrl(managedOrganizationsUrlValue);
        }
        String defaultSpaceIdValue = instance.getDefaultSpaceId();
        if (defaultSpaceIdValue != null) {
          defaultSpaceId(defaultSpaceIdValue);
        }
        String organizationsUrlValue = instance.getOrganizationsUrl();
        if (organizationsUrlValue != null) {
          organizationsUrl(organizationsUrlValue);
        }
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        Boolean adminValue = instance.getAdmin();
        if (adminValue != null) {
          admin(adminValue);
        }
        String managedSpacesUrlValue = instance.getManagedSpacesUrl();
        if (managedSpacesUrlValue != null) {
          managedSpacesUrl(managedSpacesUrlValue);
        }
        String defaultSpaceUrlValue = instance.getDefaultSpaceUrl();
        if (defaultSpaceUrlValue != null) {
          defaultSpaceUrl(defaultSpaceUrlValue);
        }
        String billingManagedOrganizationsUrlValue = instance.getBillingManagedOrganizationsUrl();
        if (billingManagedOrganizationsUrlValue != null) {
          billingManagedOrganizationsUrl(billingManagedOrganizationsUrlValue);
        }
        String auditedOrganizationsUrlValue = instance.getAuditedOrganizationsUrl();
        if (auditedOrganizationsUrlValue != null) {
          auditedOrganizationsUrl(auditedOrganizationsUrlValue);
        }
        String usernameValue = instance.getUsername();
        if (usernameValue != null) {
          username(usernameValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _UserEntity#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getAdmin() admin} attribute.
     * @param admin The value for admin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder admin(@Nullable Boolean admin) {
      this.admin = admin;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getAuditedOrganizationsUrl() auditedOrganizationsUrl} attribute.
     * @param auditedOrganizationsUrl The value for auditedOrganizationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationsUrl(@Nullable String auditedOrganizationsUrl) {
      this.auditedOrganizationsUrl = auditedOrganizationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getAuditedSpacesUrl() auditedSpacesUrl} attribute.
     * @param auditedSpacesUrl The value for auditedSpacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpacesUrl(@Nullable String auditedSpacesUrl) {
      this.auditedSpacesUrl = auditedSpacesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getBillingManagedOrganizationsUrl() billingManagedOrganizationsUrl} attribute.
     * @param billingManagedOrganizationsUrl The value for billingManagedOrganizationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationsUrl(@Nullable String billingManagedOrganizationsUrl) {
      this.billingManagedOrganizationsUrl = billingManagedOrganizationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getDefaultSpaceId() defaultSpaceId} attribute.
     * @param defaultSpaceId The value for defaultSpaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultSpaceId(@Nullable String defaultSpaceId) {
      this.defaultSpaceId = defaultSpaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getDefaultSpaceUrl() defaultSpaceUrl} attribute.
     * @param defaultSpaceUrl The value for defaultSpaceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultSpaceUrl(@Nullable String defaultSpaceUrl) {
      this.defaultSpaceUrl = defaultSpaceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getManagedOrganizationsUrl() managedOrganizationsUrl} attribute.
     * @param managedOrganizationsUrl The value for managedOrganizationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationsUrl(@Nullable String managedOrganizationsUrl) {
      this.managedOrganizationsUrl = managedOrganizationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getManagedSpacesUrl() managedSpacesUrl} attribute.
     * @param managedSpacesUrl The value for managedSpacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpacesUrl(@Nullable String managedSpacesUrl) {
      this.managedSpacesUrl = managedSpacesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getOrganizationsUrl() organizationsUrl} attribute.
     * @param organizationsUrl The value for organizationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationsUrl(@Nullable String organizationsUrl) {
      this.organizationsUrl = organizationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getSpacesUrl() spacesUrl} attribute.
     * @param spacesUrl The value for spacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserEntity#getUsername() username} attribute.
     * @param username The value for username (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Builds a new {@link UserEntity UserEntity}.
     * @return An immutable instance of UserEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserEntity build() {
      return new UserEntity(this);
    }
  }
}
