package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * Immutable implementation of {@link _ListApplicationPackagesRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ListApplicationPackagesRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ListApplicationPackagesRequest"})
public final class ListApplicationPackagesRequest
    extends org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest {
  private final String applicationId;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListApplicationPackagesRequest(ListApplicationPackagesRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationPackagesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationPackagesRequest
        && equalTo((ListApplicationPackagesRequest) another);
  }

  private boolean equalTo(ListApplicationPackagesRequest another) {
    return applicationId.equals(another.applicationId)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationPackagesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationPackagesRequest{"
        + "applicationId=" + applicationId
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationPackagesRequest ListApplicationPackagesRequest}.
   * @return A new ListApplicationPackagesRequest builder
   */
  public static ListApplicationPackagesRequest.Builder builder() {
    return new ListApplicationPackagesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationPackagesRequest ListApplicationPackagesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationPackagesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationPackagesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationPackagesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListApplicationPackagesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest) {
        org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest instance = (org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest) object;
        applicationId(instance.getApplicationId());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ListApplicationPackagesRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationPackagesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationPackagesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListApplicationPackagesRequest ListApplicationPackagesRequest}.
     * @return An immutable instance of ListApplicationPackagesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationPackagesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListApplicationPackagesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationPackagesRequest, some of required attributes are not set " + attributes;
    }
  }
}
