package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;

/**
 * Immutable implementation of {@link _DropletResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DropletResource.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DropletResource"})
public final class DropletResource extends org.cloudfoundry.client.v3.droplets._DropletResource {
  private final @Nullable String createdAt;
  private final @Nullable Map<String, Object> environmentVariables;
  private final @Nullable String error;
  private final @Nullable String id;
  private final @Nullable Lifecycle lifecycle;
  private final @Nullable Map<String, Link> links;
  private final @Nullable Result result;
  private final @Nullable Integer stagingDiskInMb;
  private final @Nullable Integer stagingMemoryInMb;
  private final @Nullable State state;
  private final @Nullable String updatedAt;

  private DropletResource(DropletResource.Builder builder) {
    this.createdAt = builder.createdAt;
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.error = builder.error;
    this.id = builder.id;
    this.lifecycle = builder.lifecycle;
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
    this.result = builder.result;
    this.stagingDiskInMb = builder.stagingDiskInMb;
    this.stagingMemoryInMb = builder.stagingMemoryInMb;
    this.state = builder.state;
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The created at
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The environment variables
   */
  @JsonProperty("environment_variables")
  @Override
  public @Nullable Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The error
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The results
   */
  @JsonDeserialize(using = Droplet.ResultDeserializer.class)
  @JsonProperty("result")
  @Override
  public @Nullable Result getResult() {
    return result;
  }

  /**
   * The staging disk in MB
   */
  @JsonProperty("staging_disk_in_mb")
  @Override
  public @Nullable Integer getStagingDiskInMb() {
    return stagingDiskInMb;
  }

  /**
   * The staging memory in MB
   */
  @JsonProperty("staging_memory_in_mb")
  @Override
  public @Nullable Integer getStagingMemoryInMb() {
    return stagingMemoryInMb;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable State getState() {
    return state;
  }

  /**
   * The updated at
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code DropletResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DropletResource
        && equalTo((DropletResource) another);
  }

  private boolean equalTo(DropletResource another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(error, another.error)
        && Objects.equals(id, another.id)
        && Objects.equals(lifecycle, another.lifecycle)
        && Objects.equals(links, another.links)
        && Objects.equals(result, another.result)
        && Objects.equals(stagingDiskInMb, another.stagingDiskInMb)
        && Objects.equals(stagingMemoryInMb, another.stagingMemoryInMb)
        && Objects.equals(state, another.state)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code environmentVariables}, {@code error}, {@code id}, {@code lifecycle}, {@code links}, {@code result}, {@code stagingDiskInMb}, {@code stagingMemoryInMb}, {@code state}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(createdAt);
    h = h * 17 + Objects.hashCode(environmentVariables);
    h = h * 17 + Objects.hashCode(error);
    h = h * 17 + Objects.hashCode(id);
    h = h * 17 + Objects.hashCode(lifecycle);
    h = h * 17 + Objects.hashCode(links);
    h = h * 17 + Objects.hashCode(result);
    h = h * 17 + Objects.hashCode(stagingDiskInMb);
    h = h * 17 + Objects.hashCode(stagingMemoryInMb);
    h = h * 17 + Objects.hashCode(state);
    h = h * 17 + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code DropletResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DropletResource{"
        + "createdAt=" + createdAt
        + ", environmentVariables=" + environmentVariables
        + ", error=" + error
        + ", id=" + id
        + ", lifecycle=" + lifecycle
        + ", links=" + links
        + ", result=" + result
        + ", stagingDiskInMb=" + stagingDiskInMb
        + ", stagingMemoryInMb=" + stagingMemoryInMb
        + ", state=" + state
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v3.droplets._DropletResource {
    String createdAt;
    Map<String, Object> environmentVariables;
    String error;
    String id;
    Lifecycle lifecycle;
    Map<String, Link> links;
    Result result;
    Integer stagingDiskInMb;
    Integer stagingMemoryInMb;
    State state;
    String updatedAt;
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("environment_variables")
    public void setEnvironmentVariables(@Nullable Map<String, Object> environmentVariables) {
      this.environmentVariables = environmentVariables;
    }
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @JsonDeserialize(using = Droplet.ResultDeserializer.class)
    @JsonProperty("result")
    public void setResult(@Nullable Result result) {
      this.result = result;
    }
    @JsonProperty("staging_disk_in_mb")
    public void setStagingDiskInMb(@Nullable Integer stagingDiskInMb) {
      this.stagingDiskInMb = stagingDiskInMb;
    }
    @JsonProperty("staging_memory_in_mb")
    public void setStagingMemoryInMb(@Nullable Integer stagingMemoryInMb) {
      this.stagingMemoryInMb = stagingMemoryInMb;
    }
    @JsonProperty("state")
    public void setState(@Nullable State state) {
      this.state = state;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public Result getResult() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStagingDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStagingMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public State getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static DropletResource fromJson(Json json) {
    DropletResource.Builder builder = DropletResource.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.environmentVariables != null) {
      builder.putAllEnvironmentVariables(json.environmentVariables);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.result != null) {
      builder.result(json.result);
    }
    if (json.stagingDiskInMb != null) {
      builder.stagingDiskInMb(json.stagingDiskInMb);
    }
    if (json.stagingMemoryInMb != null) {
      builder.stagingMemoryInMb(json.stagingMemoryInMb);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DropletResource DropletResource}.
   * @return A new DropletResource builder
   */
  public static DropletResource.Builder builder() {
    return new DropletResource.Builder();
  }

  /**
   * Builds instances of type {@link DropletResource DropletResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String createdAt;
    private Map<String, Object> environmentVariables = null;
    private String error;
    private String id;
    private Lifecycle lifecycle;
    private Map<String, Link> links = null;
    private Result result;
    private Integer stagingDiskInMb;
    private Integer stagingMemoryInMb;
    private State state;
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.droplets.Droplet} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Droplet instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DropletResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DropletResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DropletResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DropletResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Droplet) {
        Droplet instance = (Droplet) object;
        Lifecycle lifecycleValue = instance.getLifecycle();
        if (lifecycleValue != null) {
          lifecycle(lifecycleValue);
        }
        Result resultValue = instance.getResult();
        if (resultValue != null) {
          result(resultValue);
        }
        String createdAtValue = instance.getCreatedAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
        if (environmentVariablesValue != null) {
          putAllEnvironmentVariables(environmentVariablesValue);
        }
        Integer stagingDiskInMbValue = instance.getStagingDiskInMb();
        if (stagingDiskInMbValue != null) {
          stagingDiskInMb(stagingDiskInMbValue);
        }
        Map<String, Link> linksValue = instance.getLinks();
        if (linksValue != null) {
          putAllLinks(linksValue);
        }
        Integer stagingMemoryInMbValue = instance.getStagingMemoryInMb();
        if (stagingMemoryInMbValue != null) {
          stagingMemoryInMb(stagingMemoryInMbValue);
        }
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        State stateValue = instance.getState();
        if (stateValue != null) {
          state(stateValue);
        }
        String errorValue = instance.getError();
        if (errorValue != null) {
          error(errorValue);
        }
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _DropletResource#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Put one entry to the {@link _DropletResource#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      this.environmentVariables.put(
          Objects.requireNonNull(key, "environmentVariables key"),
          Objects.requireNonNull(value, "environmentVariables value"));
      return this;
    }

    /**
     * Put one entry to the {@link _DropletResource#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(
          Objects.requireNonNull(k, "environmentVariables key"),
          Objects.requireNonNull(v, "environmentVariables value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _DropletResource#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, Object>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _DropletResource#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentVariables.put(
            Objects.requireNonNull(k, "environmentVariables key"),
            Objects.requireNonNull(v, "environmentVariables value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Put one entry to the {@link _DropletResource#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(
          Objects.requireNonNull(key, "links key"),
          Objects.requireNonNull(value, "links value"));
      return this;
    }

    /**
     * Put one entry to the {@link _DropletResource#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(
          Objects.requireNonNull(k, "links key"),
          Objects.requireNonNull(v, "links value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _DropletResource#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder links(@Nullable Map<String, ? extends Link> links) {
      if (links == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _DropletResource#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(
            Objects.requireNonNull(k, "links key"),
            Objects.requireNonNull(v, "links value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getResult() result} attribute.
     * @param result The value for result (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder result(@Nullable Result result) {
      this.result = result;
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getStagingDiskInMb() stagingDiskInMb} attribute.
     * @param stagingDiskInMb The value for stagingDiskInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingDiskInMb(@Nullable Integer stagingDiskInMb) {
      this.stagingDiskInMb = stagingDiskInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getStagingMemoryInMb() stagingMemoryInMb} attribute.
     * @param stagingMemoryInMb The value for stagingMemoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingMemoryInMb(@Nullable Integer stagingMemoryInMb) {
      this.stagingMemoryInMb = stagingMemoryInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable State state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link _DropletResource#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link DropletResource DropletResource}.
     * @return An immutable instance of DropletResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DropletResource build() {
      return new DropletResource(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
