package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Hash;

/**
 * Immutable implementation of {@link _StagedResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StagedResult.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_StagedResult"})
public final class StagedResult extends org.cloudfoundry.client.v3.droplets._StagedResult {
  private final @Nullable String buildpack;
  private final @Nullable String executionMetadata;
  private final @Nullable Hash hash;
  private final @Nullable Map<String, String> processTypes;
  private final @Nullable String stack;

  private StagedResult(StagedResult.Builder builder) {
    this.buildpack = builder.buildpack;
    this.executionMetadata = builder.executionMetadata;
    this.hash = builder.hash;
    this.processTypes = builder.processTypes == null ? null : createUnmodifiableMap(false, false, builder.processTypes);
    this.stack = builder.stack;
  }

  /**
   * @return The value of the {@code buildpack} attribute
   */
  @JsonProperty("buildpack")
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * @return The value of the {@code executionMetadata} attribute
   */
  @JsonProperty("execution_metadata")
  @Override
  public @Nullable String getExecutionMetadata() {
    return executionMetadata;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public @Nullable Hash getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code processTypes} attribute
   */
  @JsonProperty("process_types")
  @Override
  public @Nullable Map<String, String> getProcessTypes() {
    return processTypes;
  }

  /**
   * @return The value of the {@code stack} attribute
   */
  @JsonProperty("stack")
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * This instance is equal to all instances of {@code StagedResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StagedResult
        && equalTo((StagedResult) another);
  }

  private boolean equalTo(StagedResult another) {
    return Objects.equals(buildpack, another.buildpack)
        && Objects.equals(executionMetadata, another.executionMetadata)
        && Objects.equals(hash, another.hash)
        && Objects.equals(processTypes, another.processTypes)
        && Objects.equals(stack, another.stack);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code executionMetadata}, {@code hash}, {@code processTypes}, {@code stack}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(buildpack);
    h = h * 17 + Objects.hashCode(executionMetadata);
    h = h * 17 + Objects.hashCode(hash);
    h = h * 17 + Objects.hashCode(processTypes);
    h = h * 17 + Objects.hashCode(stack);
    return h;
  }

  /**
   * Prints the immutable value {@code StagedResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StagedResult{"
        + "buildpack=" + buildpack
        + ", executionMetadata=" + executionMetadata
        + ", hash=" + hash
        + ", processTypes=" + processTypes
        + ", stack=" + stack
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v3.droplets._StagedResult {
    String buildpack;
    String executionMetadata;
    Hash hash;
    Map<String, String> processTypes;
    String stack;
    @JsonProperty("buildpack")
    public void setBuildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
    }
    @JsonProperty("execution_metadata")
    public void setExecutionMetadata(@Nullable String executionMetadata) {
      this.executionMetadata = executionMetadata;
    }
    @JsonProperty("hash")
    public void setHash(@Nullable Hash hash) {
      this.hash = hash;
    }
    @JsonProperty("process_types")
    public void setProcessTypes(@Nullable Map<String, String> processTypes) {
      this.processTypes = processTypes;
    }
    @JsonProperty("stack")
    public void setStack(@Nullable String stack) {
      this.stack = stack;
    }
    @Override
    public String getBuildpack() { throw new UnsupportedOperationException(); }
    @Override
    public String getExecutionMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Hash getHash() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getProcessTypes() { throw new UnsupportedOperationException(); }
    @Override
    public String getStack() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static StagedResult fromJson(Json json) {
    StagedResult.Builder builder = StagedResult.builder();
    if (json.buildpack != null) {
      builder.buildpack(json.buildpack);
    }
    if (json.executionMetadata != null) {
      builder.executionMetadata(json.executionMetadata);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.processTypes != null) {
      builder.putAllProcessTypes(json.processTypes);
    }
    if (json.stack != null) {
      builder.stack(json.stack);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link StagedResult StagedResult}.
   * @return A new StagedResult builder
   */
  public static StagedResult.Builder builder() {
    return new StagedResult.Builder();
  }

  /**
   * Builds instances of type {@link StagedResult StagedResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String buildpack;
    private String executionMetadata;
    private Hash hash;
    private Map<String, String> processTypes = null;
    private String stack;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StagedResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StagedResult instance) {
      return from((_StagedResult) instance);
    }

    /**
     * Copy abstract value type {@code _StagedResult} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_StagedResult instance) {
      Objects.requireNonNull(instance, "instance");
      String buildpackValue = instance.getBuildpack();
      if (buildpackValue != null) {
        buildpack(buildpackValue);
      }
      String executionMetadataValue = instance.getExecutionMetadata();
      if (executionMetadataValue != null) {
        executionMetadata(executionMetadataValue);
      }
      Hash hashValue = instance.getHash();
      if (hashValue != null) {
        hash(hashValue);
      }
      Map<String, String> processTypesValue = instance.getProcessTypes();
      if (processTypesValue != null) {
        putAllProcessTypes(processTypesValue);
      }
      String stackValue = instance.getStack();
      if (stackValue != null) {
        stack(stackValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _StagedResult#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link _StagedResult#getExecutionMetadata() executionMetadata} attribute.
     * @param executionMetadata The value for executionMetadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder executionMetadata(@Nullable String executionMetadata) {
      this.executionMetadata = executionMetadata;
      return this;
    }

    /**
     * Initializes the value for the {@link _StagedResult#getHash() hash} attribute.
     * @param hash The value for hash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hash(@Nullable Hash hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Put one entry to the {@link _StagedResult#getProcessTypes() processTypes} map.
     * @param key The key in the processTypes map
     * @param value The associated value in the processTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processType(String key, String value) {
      if (this.processTypes == null) {
        this.processTypes = new LinkedHashMap<String, String>();
      }
      this.processTypes.put(
          Objects.requireNonNull(key, "processTypes key"),
          Objects.requireNonNull(value, "processTypes value"));
      return this;
    }

    /**
     * Put one entry to the {@link _StagedResult#getProcessTypes() processTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processType(Map.Entry<String, ? extends String> entry) {
      if (this.processTypes == null) {
        this.processTypes = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.processTypes.put(
          Objects.requireNonNull(k, "processTypes key"),
          Objects.requireNonNull(v, "processTypes value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _StagedResult#getProcessTypes() processTypes} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param processTypes The entries that will be added to the processTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processTypes(@Nullable Map<String, ? extends String> processTypes) {
      if (processTypes == null) {
        this.processTypes = null;
        return this;
      }
      this.processTypes = new LinkedHashMap<String, String>();
      return putAllProcessTypes(processTypes);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _StagedResult#getProcessTypes() processTypes} map. Nulls are not permitted
     * @param processTypes The entries that will be added to the processTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProcessTypes(Map<String, ? extends String> processTypes) {
      if (this.processTypes == null) {
        this.processTypes = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> entry : processTypes.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.processTypes.put(
            Objects.requireNonNull(k, "processTypes key"),
            Objects.requireNonNull(v, "processTypes value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _StagedResult#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Builds a new {@link StagedResult StagedResult}.
     * @return An immutable instance of StagedResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public StagedResult build() {
      return new StagedResult(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
