package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Result}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Result.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Result"})
public final class Result extends org.cloudfoundry.client.v3.tasks._Result {
  private final @Nullable String failureReason;

  private Result(Result.Builder builder) {
    this.failureReason = builder.failureReason;
  }

  /**
   * The failure reason
   */
  @JsonProperty("failure_reason")
  @Override
  public @Nullable String getFailureReason() {
    return failureReason;
  }

  /**
   * This instance is equal to all instances of {@code Result} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Result
        && equalTo((Result) another);
  }

  private boolean equalTo(Result another) {
    return Objects.equals(failureReason, another.failureReason);
  }

  /**
   * Computes a hash code from attributes: {@code failureReason}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(failureReason);
    return h;
  }

  /**
   * Prints the immutable value {@code Result} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Result{"
        + "failureReason=" + failureReason
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.client.v3.tasks._Result {
    String failureReason;
    @JsonProperty("failure_reason")
    public void setFailureReason(@Nullable String failureReason) {
      this.failureReason = failureReason;
    }
    @Override
    public String getFailureReason() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Result fromJson(Json json) {
    Result.Builder builder = Result.builder();
    if (json.failureReason != null) {
      builder.failureReason(json.failureReason);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Result Result}.
   * @return A new Result builder
   */
  public static Result.Builder builder() {
    return new Result.Builder();
  }

  /**
   * Builds instances of type {@link Result Result}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String failureReason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Result} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Result instance) {
      return from((_Result) instance);
    }

    /**
     * Copy abstract value type {@code _Result} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Result instance) {
      Objects.requireNonNull(instance, "instance");
      String failureReasonValue = instance.getFailureReason();
      if (failureReasonValue != null) {
        failureReason(failureReasonValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Result#getFailureReason() failureReason} attribute.
     * @param failureReason The value for failureReason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failureReason(@Nullable String failureReason) {
      this.failureReason = failureReason;
      return this;
    }

    /**
     * Builds a new {@link Result Result}.
     * @return An immutable instance of Result
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Result build() {
      return new Result(this);
    }
  }
}
