package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _ContainerMetric}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ContainerMetric.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ContainerMetric"})
public final class ContainerMetric extends org.cloudfoundry.doppler._ContainerMetric {
  private final String applicationId;
  private final Double cpuPercentage;
  private final Long diskBytes;
  private final Integer instanceIndex;
  private final Long memoryBytes;

  private ContainerMetric(ContainerMetric.Builder builder) {
    this.applicationId = builder.applicationId;
    this.cpuPercentage = builder.cpuPercentage;
    this.diskBytes = builder.diskBytes;
    this.instanceIndex = builder.instanceIndex;
    this.memoryBytes = builder.memoryBytes;
  }

  /**
   * The ID of the contained application
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The CPU used, on a scale of 0 to 100
   */
  @Override
  public Double getCpuPercentage() {
    return cpuPercentage;
  }

  /**
   * The bytes of disk used
   */
  @Override
  public Long getDiskBytes() {
    return diskBytes;
  }

  /**
   * The instance index of the contained application. (This, with applicationId, should uniquely identify a container.)
   */
  @Override
  public Integer getInstanceIndex() {
    return instanceIndex;
  }

  /**
   * The bytes of memory used
   */
  @Override
  public Long getMemoryBytes() {
    return memoryBytes;
  }

  /**
   * This instance is equal to all instances of {@code ContainerMetric} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ContainerMetric
        && equalTo((ContainerMetric) another);
  }

  private boolean equalTo(ContainerMetric another) {
    return applicationId.equals(another.applicationId)
        && cpuPercentage.equals(another.cpuPercentage)
        && diskBytes.equals(another.diskBytes)
        && instanceIndex.equals(another.instanceIndex)
        && memoryBytes.equals(another.memoryBytes);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code cpuPercentage}, {@code diskBytes}, {@code instanceIndex}, {@code memoryBytes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + cpuPercentage.hashCode();
    h = h * 17 + diskBytes.hashCode();
    h = h * 17 + instanceIndex.hashCode();
    h = h * 17 + memoryBytes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ContainerMetric} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContainerMetric{"
        + "applicationId=" + applicationId
        + ", cpuPercentage=" + cpuPercentage
        + ", diskBytes=" + diskBytes
        + ", instanceIndex=" + instanceIndex
        + ", memoryBytes=" + memoryBytes
        + "}";
  }

  /**
   * Creates a builder for {@link ContainerMetric ContainerMetric}.
   * @return A new ContainerMetric builder
   */
  public static ContainerMetric.Builder builder() {
    return new ContainerMetric.Builder();
  }

  /**
   * Builds instances of type {@link ContainerMetric ContainerMetric}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_CPU_PERCENTAGE = 0x2L;
    private static final long INIT_BIT_DISK_BYTES = 0x4L;
    private static final long INIT_BIT_INSTANCE_INDEX = 0x8L;
    private static final long INIT_BIT_MEMORY_BYTES = 0x10L;
    private long initBits = 0x1fL;

    private String applicationId;
    private Double cpuPercentage;
    private Long diskBytes;
    private Integer instanceIndex;
    private Long memoryBytes;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContainerMetric} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContainerMetric instance) {
      return from((_ContainerMetric) instance);
    }

    /**
     * Copy abstract value type {@code _ContainerMetric} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ContainerMetric instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      cpuPercentage(instance.getCpuPercentage());
      diskBytes(instance.getDiskBytes());
      instanceIndex(instance.getInstanceIndex());
      memoryBytes(instance.getMemoryBytes());
      return this;
    }

    /**
     * Initializes the value for the {@link _ContainerMetric#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ContainerMetric#getCpuPercentage() cpuPercentage} attribute.
     * @param cpuPercentage The value for cpuPercentage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cpuPercentage(Double cpuPercentage) {
      this.cpuPercentage = Objects.requireNonNull(cpuPercentage, "cpuPercentage");
      initBits &= ~INIT_BIT_CPU_PERCENTAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link _ContainerMetric#getDiskBytes() diskBytes} attribute.
     * @param diskBytes The value for diskBytes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskBytes(Long diskBytes) {
      this.diskBytes = Objects.requireNonNull(diskBytes, "diskBytes");
      initBits &= ~INIT_BIT_DISK_BYTES;
      return this;
    }

    /**
     * Initializes the value for the {@link _ContainerMetric#getInstanceIndex() instanceIndex} attribute.
     * @param instanceIndex The value for instanceIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceIndex(Integer instanceIndex) {
      this.instanceIndex = Objects.requireNonNull(instanceIndex, "instanceIndex");
      initBits &= ~INIT_BIT_INSTANCE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link _ContainerMetric#getMemoryBytes() memoryBytes} attribute.
     * @param memoryBytes The value for memoryBytes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryBytes(Long memoryBytes) {
      this.memoryBytes = Objects.requireNonNull(memoryBytes, "memoryBytes");
      initBits &= ~INIT_BIT_MEMORY_BYTES;
      return this;
    }

    /**
     * Builds a new {@link ContainerMetric ContainerMetric}.
     * @return An immutable instance of ContainerMetric
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ContainerMetric build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ContainerMetric(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_CPU_PERCENTAGE) != 0) attributes.add("cpuPercentage");
      if ((initBits & INIT_BIT_DISK_BYTES) != 0) attributes.add("diskBytes");
      if ((initBits & INIT_BIT_INSTANCE_INDEX) != 0) attributes.add("instanceIndex");
      if ((initBits & INIT_BIT_MEMORY_BYTES) != 0) attributes.add("memoryBytes");
      return "Cannot build ContainerMetric, some of required attributes are not set " + attributes;
    }
  }
}
