// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: metric.proto at 23:2
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

/**
 * / A ContainerMetric records resource usage of an app in a container.
 */
public final class ContainerMetric extends Message<ContainerMetric, ContainerMetric.Builder> {
  public static final ProtoAdapter<ContainerMetric> ADAPTER = new ProtoAdapter_ContainerMetric();

  private static final long serialVersionUID = 0L;

  public static final String DEFAULT_APPLICATIONID = "";

  public static final Integer DEFAULT_INSTANCEINDEX = 0;

  public static final Double DEFAULT_CPUPERCENTAGE = 0.0d;

  public static final Long DEFAULT_MEMORYBYTES = 0L;

  public static final Long DEFAULT_DISKBYTES = 0L;

  /**
   * / ID of the contained application.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String applicationId;

  /**
   * / Instance index of the contained application. (This, with applicationId, should uniquely identify a container.)
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#INT32",
      label = WireField.Label.REQUIRED
  )
  public final Integer instanceIndex;

  /**
   * / CPU used, on a scale of 0 to 100.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
      label = WireField.Label.REQUIRED
  )
  public final Double cpuPercentage;

  /**
   * / Bytes of memory used.
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#UINT64",
      label = WireField.Label.REQUIRED
  )
  public final Long memoryBytes;

  /**
   * / Bytes of disk used.
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#UINT64",
      label = WireField.Label.REQUIRED
  )
  public final Long diskBytes;

  public ContainerMetric(String applicationId, Integer instanceIndex, Double cpuPercentage, Long memoryBytes, Long diskBytes) {
    this(applicationId, instanceIndex, cpuPercentage, memoryBytes, diskBytes, ByteString.EMPTY);
  }

  public ContainerMetric(String applicationId, Integer instanceIndex, Double cpuPercentage, Long memoryBytes, Long diskBytes, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.applicationId = applicationId;
    this.instanceIndex = instanceIndex;
    this.cpuPercentage = cpuPercentage;
    this.memoryBytes = memoryBytes;
    this.diskBytes = diskBytes;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.applicationId = applicationId;
    builder.instanceIndex = instanceIndex;
    builder.cpuPercentage = cpuPercentage;
    builder.memoryBytes = memoryBytes;
    builder.diskBytes = diskBytes;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ContainerMetric)) return false;
    ContainerMetric o = (ContainerMetric) other;
    return unknownFields().equals(o.unknownFields())
        && applicationId.equals(o.applicationId)
        && instanceIndex.equals(o.instanceIndex)
        && cpuPercentage.equals(o.cpuPercentage)
        && memoryBytes.equals(o.memoryBytes)
        && diskBytes.equals(o.diskBytes);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + applicationId.hashCode();
      result = result * 37 + instanceIndex.hashCode();
      result = result * 37 + cpuPercentage.hashCode();
      result = result * 37 + memoryBytes.hashCode();
      result = result * 37 + diskBytes.hashCode();
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", applicationId=").append(applicationId);
    builder.append(", instanceIndex=").append(instanceIndex);
    builder.append(", cpuPercentage=").append(cpuPercentage);
    builder.append(", memoryBytes=").append(memoryBytes);
    builder.append(", diskBytes=").append(diskBytes);
    return builder.replace(0, 2, "ContainerMetric{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ContainerMetric, Builder> {
    public String applicationId;

    public Integer instanceIndex;

    public Double cpuPercentage;

    public Long memoryBytes;

    public Long diskBytes;

    public Builder() {
    }

    /**
     * / ID of the contained application.
     */
    public Builder applicationId(String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * / Instance index of the contained application. (This, with applicationId, should uniquely identify a container.)
     */
    public Builder instanceIndex(Integer instanceIndex) {
      this.instanceIndex = instanceIndex;
      return this;
    }

    /**
     * / CPU used, on a scale of 0 to 100.
     */
    public Builder cpuPercentage(Double cpuPercentage) {
      this.cpuPercentage = cpuPercentage;
      return this;
    }

    /**
     * / Bytes of memory used.
     */
    public Builder memoryBytes(Long memoryBytes) {
      this.memoryBytes = memoryBytes;
      return this;
    }

    /**
     * / Bytes of disk used.
     */
    public Builder diskBytes(Long diskBytes) {
      this.diskBytes = diskBytes;
      return this;
    }

    @Override
    public ContainerMetric build() {
      if (applicationId == null
          || instanceIndex == null
          || cpuPercentage == null
          || memoryBytes == null
          || diskBytes == null) {
        throw Internal.missingRequiredFields(applicationId, "applicationId",
            instanceIndex, "instanceIndex",
            cpuPercentage, "cpuPercentage",
            memoryBytes, "memoryBytes",
            diskBytes, "diskBytes");
      }
      return new ContainerMetric(applicationId, instanceIndex, cpuPercentage, memoryBytes, diskBytes, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_ContainerMetric extends ProtoAdapter<ContainerMetric> {
    ProtoAdapter_ContainerMetric() {
      super(FieldEncoding.LENGTH_DELIMITED, ContainerMetric.class);
    }

    @Override
    public int encodedSize(ContainerMetric value) {
      return ProtoAdapter.STRING.encodedSizeWithTag(1, value.applicationId)
          + ProtoAdapter.INT32.encodedSizeWithTag(2, value.instanceIndex)
          + ProtoAdapter.DOUBLE.encodedSizeWithTag(3, value.cpuPercentage)
          + ProtoAdapter.UINT64.encodedSizeWithTag(4, value.memoryBytes)
          + ProtoAdapter.UINT64.encodedSizeWithTag(5, value.diskBytes)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, ContainerMetric value) throws IOException {
      ProtoAdapter.STRING.encodeWithTag(writer, 1, value.applicationId);
      ProtoAdapter.INT32.encodeWithTag(writer, 2, value.instanceIndex);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 3, value.cpuPercentage);
      ProtoAdapter.UINT64.encodeWithTag(writer, 4, value.memoryBytes);
      ProtoAdapter.UINT64.encodeWithTag(writer, 5, value.diskBytes);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public ContainerMetric decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.applicationId(ProtoAdapter.STRING.decode(reader)); break;
          case 2: builder.instanceIndex(ProtoAdapter.INT32.decode(reader)); break;
          case 3: builder.cpuPercentage(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 4: builder.memoryBytes(ProtoAdapter.UINT64.decode(reader)); break;
          case 5: builder.diskBytes(ProtoAdapter.UINT64.decode(reader)); break;
          default: {
            FieldEncoding fieldEncoding = reader.peekFieldEncoding();
            Object value = fieldEncoding.rawProtoAdapter().decode(reader);
            builder.addUnknownField(tag, fieldEncoding, value);
          }
        }
      }
      reader.endMessage(token);
      return builder.build();
    }

    @Override
    public ContainerMetric redact(ContainerMetric value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
