package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Member}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Member.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Member"})
public final class Member extends org.cloudfoundry.uaa.groups._Member {
  private final @Nullable String identityProviderOriginKey;
  private final @Nullable MemberType type;
  private final String value;

  private Member(Member.Builder builder) {
    this.identityProviderOriginKey = builder.identityProviderOriginKey;
    this.type = builder.type;
    this.value = builder.value;
  }

  /**
   * The alias of the identity provider that authenticated this user. "uaa" is an internal UAA user.
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getIdentityProviderOriginKey() {
    return identityProviderOriginKey;
  }

  /**
   * The member type
   */
  @JsonProperty("type")
  @Override
  public @Nullable MemberType getType() {
    return type;
  }

  /**
   * Globally unique identifier of the member, either a user ID or another group ID
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Member} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Member
        && equalTo((Member) another);
  }

  private boolean equalTo(Member another) {
    return Objects.equals(identityProviderOriginKey, another.identityProviderOriginKey)
        && Objects.equals(type, another.type)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code identityProviderOriginKey}, {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(identityProviderOriginKey);
    h = h * 17 + Objects.hashCode(type);
    h = h * 17 + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Member} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Member{"
        + "identityProviderOriginKey=" + identityProviderOriginKey
        + ", type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.groups._Member {
    String identityProviderOriginKey;
    MemberType type;
    String value;
    @JsonProperty("origin")
    public void setIdentityProviderOriginKey(@Nullable String identityProviderOriginKey) {
      this.identityProviderOriginKey = identityProviderOriginKey;
    }
    @JsonProperty("type")
    public void setType(@Nullable MemberType type) {
      this.type = type;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getIdentityProviderOriginKey() { throw new UnsupportedOperationException(); }
    @Override
    public MemberType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Member fromJson(Json json) {
    Member.Builder builder = Member.builder();
    if (json.identityProviderOriginKey != null) {
      builder.identityProviderOriginKey(json.identityProviderOriginKey);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Member Member}.
   * @return A new Member builder
   */
  public static Member.Builder builder() {
    return new Member.Builder();
  }

  /**
   * Builds instances of type {@link Member Member}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private String identityProviderOriginKey;
    private MemberType type;
    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Member} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Member instance) {
      return from((_Member) instance);
    }

    /**
     * Copy abstract value type {@code _Member} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Member instance) {
      Objects.requireNonNull(instance, "instance");
      String identityProviderOriginKeyValue = instance.getIdentityProviderOriginKey();
      if (identityProviderOriginKeyValue != null) {
        identityProviderOriginKey(identityProviderOriginKeyValue);
      }
      MemberType typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link _Member#getIdentityProviderOriginKey() identityProviderOriginKey} attribute.
     * @param identityProviderOriginKey The value for identityProviderOriginKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProviderOriginKey(@Nullable String identityProviderOriginKey) {
      this.identityProviderOriginKey = identityProviderOriginKey;
      return this;
    }

    /**
     * Initializes the value for the {@link _Member#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable MemberType type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link _Member#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link Member Member}.
     * @return An immutable instance of Member
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Member build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Member(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Member, some of required attributes are not set " + attributes;
    }
  }
}
