package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.Metadata;

/**
 * Immutable implementation of {@link _UpdateGroupResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateGroupResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UpdateGroupResponse"})
public final class UpdateGroupResponse extends org.cloudfoundry.uaa.groups._UpdateGroupResponse {
  private final @Nullable String description;
  private final String displayName;
  private final String id;
  private final List<Member> members;
  private final Metadata metadata;
  private final List<String> schemas;
  private final String zoneId;

  private UpdateGroupResponse(UpdateGroupResponse.Builder builder) {
    this.description = builder.description;
    this.displayName = builder.displayName;
    this.id = builder.id;
    this.members = createUnmodifiableList(true, builder.members);
    this.metadata = builder.metadata;
    this.schemas = createUnmodifiableList(true, builder.schemas);
    this.zoneId = builder.zoneId;
  }

  /**
   * Human readable description of the group, displayed e.g. when approving scopes
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The identifier specified upon creation of the group, unique within the identity zone
   */
  @JsonProperty("displayName")
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * The globally unique group ID
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Array of group members
   */
  @JsonProperty("members")
  @Override
  public List<Member> getMembers() {
    return members;
  }

  /**
   * The group's metadata
   */
  @JsonProperty("meta")
  @Override
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The group's schemas:  "urn:scim:schemas:core:1.0" ]
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * Identifier for the identity zone to which the group belongs
   */
  @JsonProperty("zoneId")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateGroupResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateGroupResponse
        && equalTo((UpdateGroupResponse) another);
  }

  private boolean equalTo(UpdateGroupResponse another) {
    return Objects.equals(description, another.description)
        && displayName.equals(another.displayName)
        && id.equals(another.id)
        && members.equals(another.members)
        && metadata.equals(another.metadata)
        && schemas.equals(another.schemas)
        && zoneId.equals(another.zoneId);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code displayName}, {@code id}, {@code members}, {@code metadata}, {@code schemas}, {@code zoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(description);
    h = h * 17 + displayName.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + members.hashCode();
    h = h * 17 + metadata.hashCode();
    h = h * 17 + schemas.hashCode();
    h = h * 17 + zoneId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateGroupResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateGroupResponse{"
        + "description=" + description
        + ", displayName=" + displayName
        + ", id=" + id
        + ", members=" + members
        + ", metadata=" + metadata
        + ", schemas=" + schemas
        + ", zoneId=" + zoneId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.groups._UpdateGroupResponse {
    String description;
    String displayName;
    String id;
    List<Member> members = Collections.emptyList();
    Metadata metadata;
    List<String> schemas = Collections.emptyList();
    String zoneId;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
      this.displayName = displayName;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("members")
    public void setMembers(List<Member> members) {
      this.members = members;
    }
    @JsonProperty("meta")
    public void setMetadata(Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("zoneId")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDisplayName() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Member> getMembers() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UpdateGroupResponse fromJson(Json json) {
    UpdateGroupResponse.Builder builder = UpdateGroupResponse.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.displayName != null) {
      builder.displayName(json.displayName);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.members != null) {
      builder.addAllMembers(json.members);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateGroupResponse UpdateGroupResponse}.
   * @return A new UpdateGroupResponse builder
   */
  public static UpdateGroupResponse.Builder builder() {
    return new UpdateGroupResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateGroupResponse UpdateGroupResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DISPLAY_NAME = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_METADATA = 0x4L;
    private static final long INIT_BIT_ZONE_ID = 0x8L;
    private long initBits = 0xfL;

    private String description;
    private String displayName;
    private String id;
    private List<Member> members = new ArrayList<Member>();
    private Metadata metadata;
    private List<String> schemas = new ArrayList<String>();
    private String zoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.groups.AbstractGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateGroupResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateGroupResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractGroup) {
        AbstractGroup instance = (AbstractGroup) object;
        metadata(instance.getMetadata());
        displayName(instance.getDisplayName());
        addAllMembers(instance.getMembers());
        addAllSchemas(instance.getSchemas());
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        zoneId(instance.getZoneId());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link _UpdateGroupResponse#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupResponse#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateGroupResponse#getMembers() members} list.
     * @param element A members element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(Member element) {
      this.members.add(Objects.requireNonNull(element, "members element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateGroupResponse#getMembers() members} list.
     * @param elements An array of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(Member... elements) {
      for (Member element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateGroupResponse#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder members(Iterable<? extends Member> elements) {
      this.members.clear();
      return addAllMembers(elements);
    }

    /**
     * Adds elements to {@link _UpdateGroupResponse#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMembers(Iterable<? extends Member> elements) {
      for (Member element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateGroupResponse#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateGroupResponse#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateGroupResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link _UpdateGroupResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupResponse#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateGroupResponse UpdateGroupResponse}.
     * @return An immutable instance of UpdateGroupResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateGroupResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateGroupResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      return "Cannot build UpdateGroupResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
