/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.uaa.Versioned;
import org.immutables.value.Value;

/**
 * The request payload for the delete group
 */
@Value.Immutable
abstract class _DeleteGroupRequest implements Versioned {

    /**
     * The group id
     */
    @JsonIgnore
    abstract String getGroupId();

}
