package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * Immutable implementation of {@link _ListIdentityProvidersRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ListIdentityProvidersRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ListIdentityProvidersRequest"})
public final class ListIdentityProvidersRequest
    extends org.cloudfoundry.uaa.identityproviders._ListIdentityProvidersRequest {
  private final String identityZoneId;

  private ListIdentityProvidersRequest(ListIdentityProvidersRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code ListIdentityProvidersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIdentityProvidersRequest
        && equalTo((ListIdentityProvidersRequest) another);
  }

  private boolean equalTo(ListIdentityProvidersRequest another) {
    return identityZoneId.equals(another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + identityZoneId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListIdentityProvidersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIdentityProvidersRequest{"
        + "identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link ListIdentityProvidersRequest ListIdentityProvidersRequest}.
   * @return A new ListIdentityProvidersRequest builder
   */
  public static ListIdentityProvidersRequest.Builder builder() {
    return new ListIdentityProvidersRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListIdentityProvidersRequest ListIdentityProvidersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_IDENTITY_ZONE_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIdentityProvidersRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIdentityProvidersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListIdentityProvidersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListIdentityProvidersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        identityZoneId(instance.getIdentityZoneId());
      }
    }

    /**
     * Initializes the value for the {@link _ListIdentityProvidersRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(String identityZoneId) {
      this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
      initBits &= ~INIT_BIT_IDENTITY_ZONE_ID;
      return this;
    }

    /**
     * Builds a new {@link ListIdentityProvidersRequest ListIdentityProvidersRequest}.
     * @return An immutable instance of ListIdentityProvidersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIdentityProvidersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListIdentityProvidersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_IDENTITY_ZONE_ID) != 0) attributes.add("identityZoneId");
      return "Cannot build ListIdentityProvidersRequest, some of required attributes are not set " + attributes;
    }
  }
}
