package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _ListIdentityProvidersResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ListIdentityProvidersResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ListIdentityProvidersResponse"})
public final class ListIdentityProvidersResponse
    extends org.cloudfoundry.uaa.identityproviders._ListIdentityProvidersResponse {
  private final List<IdentityProvider> identityProviders;

  private ListIdentityProvidersResponse(ListIdentityProvidersResponse.Builder builder) {
    this.identityProviders = createUnmodifiableList(true, builder.identityProviders);
  }

  /**
   * The identity providers
   */
  @JsonProperty("identityProviders")
  @Override
  public List<IdentityProvider> getIdentityProviders() {
    return identityProviders;
  }

  /**
   * This instance is equal to all instances of {@code ListIdentityProvidersResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIdentityProvidersResponse
        && equalTo((ListIdentityProvidersResponse) another);
  }

  private boolean equalTo(ListIdentityProvidersResponse another) {
    return identityProviders.equals(another.identityProviders);
  }

  /**
   * Computes a hash code from attributes: {@code identityProviders}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + identityProviders.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListIdentityProvidersResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIdentityProvidersResponse{"
        + "identityProviders=" + identityProviders
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.identityproviders._ListIdentityProvidersResponse {
    List<IdentityProvider> identityProviders = Collections.emptyList();
    @JsonProperty("identityProviders")
    public void setIdentityProviders(List<IdentityProvider> identityProviders) {
      this.identityProviders = identityProviders;
    }
    @Override
    public List<IdentityProvider> getIdentityProviders() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ListIdentityProvidersResponse fromJson(Json json) {
    ListIdentityProvidersResponse.Builder builder = ListIdentityProvidersResponse.builder();
    if (json.identityProviders != null) {
      builder.addAllIdentityProviders(json.identityProviders);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListIdentityProvidersResponse ListIdentityProvidersResponse}.
   * @return A new ListIdentityProvidersResponse builder
   */
  public static ListIdentityProvidersResponse.Builder builder() {
    return new ListIdentityProvidersResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListIdentityProvidersResponse ListIdentityProvidersResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIdentityProvidersResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIdentityProvidersResponse instance) {
      return from((_ListIdentityProvidersResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListIdentityProvidersResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListIdentityProvidersResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllIdentityProviders(instance.getIdentityProviders());
      return this;
    }

    /**
     * Adds one element to {@link _ListIdentityProvidersResponse#getIdentityProviders() identityProviders} list.
     * @param element A identityProviders element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProvider(IdentityProvider element) {
      this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListIdentityProvidersResponse#getIdentityProviders() identityProviders} list.
     * @param elements An array of identityProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProvider(IdentityProvider... elements) {
      for (IdentityProvider element : elements) {
        this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListIdentityProvidersResponse#getIdentityProviders() identityProviders} list.
     * @param elements An iterable of identityProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProviders(Iterable<? extends IdentityProvider> elements) {
      this.identityProviders.clear();
      return addAllIdentityProviders(elements);
    }

    /**
     * Adds elements to {@link _ListIdentityProvidersResponse#getIdentityProviders() identityProviders} list.
     * @param elements An iterable of identityProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIdentityProviders(Iterable<? extends IdentityProvider> elements) {
      for (IdentityProvider element : elements) {
        this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListIdentityProvidersResponse ListIdentityProvidersResponse}.
     * @return An immutable instance of ListIdentityProvidersResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIdentityProvidersResponse build() {
      return new ListIdentityProvidersResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
