package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _SamlConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SamlConfiguration.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_SamlConfiguration"})
public final class SamlConfiguration extends org.cloudfoundry.uaa.identityproviders._SamlConfiguration {
  private final @Nullable Boolean addShadowUserOnLogin;
  private final @Nullable Integer assertionConsumerIndex;
  private final @Nullable ExternalGroupMappingMode groupMappingMode;
  private final @Nullable String iconUrl;
  private final @Nullable String idpEntityAlias;
  private final @Nullable String linkText;
  private final String metaDataLocation;
  private final @Nullable Boolean metadataTrustCheck;
  private final @Nullable String nameId;
  private final @Nullable Boolean showSamlLink;
  private final @Nullable String socketFactoryClassName;
  private final @Nullable String zoneId;
  private final @Nullable AttributeMappings attributeMappings;
  private final @Nullable List<String> externalGroupsWhitelist;
  private final @Nullable List<String> emailDomains;
  private final @Nullable String providerDescription;

  private SamlConfiguration(SamlConfiguration.Builder builder) {
    this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
    this.assertionConsumerIndex = builder.assertionConsumerIndex;
    this.groupMappingMode = builder.groupMappingMode;
    this.iconUrl = builder.iconUrl;
    this.idpEntityAlias = builder.idpEntityAlias;
    this.linkText = builder.linkText;
    this.metaDataLocation = builder.metaDataLocation;
    this.metadataTrustCheck = builder.metadataTrustCheck;
    this.nameId = builder.nameId;
    this.showSamlLink = builder.showSamlLink;
    this.socketFactoryClassName = builder.socketFactoryClassName;
    this.zoneId = builder.zoneId;
    this.attributeMappings = builder.attributeMappings;
    this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : createUnmodifiableList(true, builder.externalGroupsWhitelist);
    this.emailDomains = builder.emailDomains == null ? null : createUnmodifiableList(true, builder.emailDomains);
    this.providerDescription = builder.providerDescription;
  }

  /**
   * Determines whether or not shadow users must be created before login by an administrator.
   */
  @JsonProperty("addShadowUserOnLogin")
  @Override
  public @Nullable Boolean getAddShadowUserOnLogin() {
    return addShadowUserOnLogin;
  }

  /**
   * SAML assertion consumer index, default is 0
   */
  @JsonProperty("assertionConsumerIndex")
  @Override
  public @Nullable Integer getAssertionConsumerIndex() {
    return assertionConsumerIndex;
  }

  /**
   * Either EXPLICITLY_MAPPED in order to map external groups to OAuth scopes using the group mappings, or AS_SCOPES to use SAML group names as scopes.
   */
  @JsonProperty("groupMappingMode")
  @Override
  public @Nullable ExternalGroupMappingMode getGroupMappingMode() {
    return groupMappingMode;
  }

  /**
   * Reserved for future use
   */
  @JsonProperty("iconUrl")
  @Override
  public @Nullable String getIconUrl() {
    return iconUrl;
  }

  /**
   * This will be set to originKey by system
   */
  @JsonProperty("idpEntityAlias")
  @Override
  public @Nullable String getIdpEntityAlias() {
    return idpEntityAlias;
  }

  /**
   * The link text for the SAML IDP on the login page
   */
  @JsonProperty("linkText")
  @Override
  public @Nullable String getLinkText() {
    return linkText;
  }

  /**
   * SAML Metadata - either an XML string or a URL that will deliver XML content
   */
  @JsonProperty("metaDataLocation")
  @Override
  public String getMetaDataLocation() {
    return metaDataLocation;
  }

  /**
   * Should metadata be validated, defaults to false
   */
  @JsonProperty("metadataTrustCheck")
  @Override
  public @Nullable Boolean getMetadataTrustCheck() {
    return metadataTrustCheck;
  }

  /**
   * The name ID to use for the username, default is “urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified”.
   */
  @JsonProperty("nameID")
  @Override
  public @Nullable String getNameId() {
    return nameId;
  }

  /**
   * Should the SAML login link be displayed on the login page, defaults to false
   */
  @JsonProperty("showSamlLink")
  @Override
  public @Nullable Boolean getShowSamlLink() {
    return showSamlLink;
  }

  /**
   * Either "org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory" or"org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory" depending on if the metaDataLocation of
   * type URL is HTTP or HTTPS, respectively
   */
  @JsonProperty("socketFactoryClassName")
  @Override
  public @Nullable String getSocketFactoryClassName() {
    return socketFactoryClassName;
  }

  /**
   * This will be set to the ID of the zone where the provider is being created by system
   */
  @JsonProperty("zoneId")
  @Override
  public @Nullable String getZoneId() {
    return zoneId;
  }

  /**
   * @return The value of the {@code attributeMappings} attribute
   */
  @JsonProperty("attributeMappings")
  @Override
  public @Nullable AttributeMappings getAttributeMappings() {
    return attributeMappings;
  }

  /**
   * The external group white list
   */
  @JsonProperty("externalGroupsWhitelist")
  @Override
  public @Nullable List<String> getExternalGroupsWhitelist() {
    return externalGroupsWhitelist;
  }

  /**
   * List of email domains associated with the provider for the purpose of associating users to the correct origin upon invitation. If empty list, no invitations are accepted. Wildcards supported.
   */
  @JsonProperty("emailDomain")
  @Override
  public @Nullable List<String> getEmailDomains() {
    return emailDomains;
  }

  /**
   * Human readable name/description of this provider
   */
  @JsonProperty("providerDescription")
  @Override
  public @Nullable String getProviderDescription() {
    return providerDescription;
  }

  /**
   * This instance is equal to all instances of {@code SamlConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SamlConfiguration
        && equalTo((SamlConfiguration) another);
  }

  private boolean equalTo(SamlConfiguration another) {
    return Objects.equals(addShadowUserOnLogin, another.addShadowUserOnLogin)
        && Objects.equals(assertionConsumerIndex, another.assertionConsumerIndex)
        && Objects.equals(groupMappingMode, another.groupMappingMode)
        && Objects.equals(iconUrl, another.iconUrl)
        && Objects.equals(idpEntityAlias, another.idpEntityAlias)
        && Objects.equals(linkText, another.linkText)
        && metaDataLocation.equals(another.metaDataLocation)
        && Objects.equals(metadataTrustCheck, another.metadataTrustCheck)
        && Objects.equals(nameId, another.nameId)
        && Objects.equals(showSamlLink, another.showSamlLink)
        && Objects.equals(socketFactoryClassName, another.socketFactoryClassName)
        && Objects.equals(zoneId, another.zoneId)
        && Objects.equals(attributeMappings, another.attributeMappings)
        && Objects.equals(externalGroupsWhitelist, another.externalGroupsWhitelist)
        && Objects.equals(emailDomains, another.emailDomains)
        && Objects.equals(providerDescription, another.providerDescription);
  }

  /**
   * Computes a hash code from attributes: {@code addShadowUserOnLogin}, {@code assertionConsumerIndex}, {@code groupMappingMode}, {@code iconUrl}, {@code idpEntityAlias}, {@code linkText}, {@code metaDataLocation}, {@code metadataTrustCheck}, {@code nameId}, {@code showSamlLink}, {@code socketFactoryClassName}, {@code zoneId}, {@code attributeMappings}, {@code externalGroupsWhitelist}, {@code emailDomains}, {@code providerDescription}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(addShadowUserOnLogin);
    h = h * 17 + Objects.hashCode(assertionConsumerIndex);
    h = h * 17 + Objects.hashCode(groupMappingMode);
    h = h * 17 + Objects.hashCode(iconUrl);
    h = h * 17 + Objects.hashCode(idpEntityAlias);
    h = h * 17 + Objects.hashCode(linkText);
    h = h * 17 + metaDataLocation.hashCode();
    h = h * 17 + Objects.hashCode(metadataTrustCheck);
    h = h * 17 + Objects.hashCode(nameId);
    h = h * 17 + Objects.hashCode(showSamlLink);
    h = h * 17 + Objects.hashCode(socketFactoryClassName);
    h = h * 17 + Objects.hashCode(zoneId);
    h = h * 17 + Objects.hashCode(attributeMappings);
    h = h * 17 + Objects.hashCode(externalGroupsWhitelist);
    h = h * 17 + Objects.hashCode(emailDomains);
    h = h * 17 + Objects.hashCode(providerDescription);
    return h;
  }

  /**
   * Prints the immutable value {@code SamlConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SamlConfiguration{"
        + "addShadowUserOnLogin=" + addShadowUserOnLogin
        + ", assertionConsumerIndex=" + assertionConsumerIndex
        + ", groupMappingMode=" + groupMappingMode
        + ", iconUrl=" + iconUrl
        + ", idpEntityAlias=" + idpEntityAlias
        + ", linkText=" + linkText
        + ", metaDataLocation=" + metaDataLocation
        + ", metadataTrustCheck=" + metadataTrustCheck
        + ", nameId=" + nameId
        + ", showSamlLink=" + showSamlLink
        + ", socketFactoryClassName=" + socketFactoryClassName
        + ", zoneId=" + zoneId
        + ", attributeMappings=" + attributeMappings
        + ", externalGroupsWhitelist=" + externalGroupsWhitelist
        + ", emailDomains=" + emailDomains
        + ", providerDescription=" + providerDescription
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.identityproviders._SamlConfiguration {
    Boolean addShadowUserOnLogin;
    Integer assertionConsumerIndex;
    ExternalGroupMappingMode groupMappingMode;
    String iconUrl;
    String idpEntityAlias;
    String linkText;
    String metaDataLocation;
    Boolean metadataTrustCheck;
    String nameId;
    Boolean showSamlLink;
    String socketFactoryClassName;
    String zoneId;
    AttributeMappings attributeMappings;
    List<String> externalGroupsWhitelist = null;
    List<String> emailDomains = null;
    String providerDescription;
    @JsonProperty("addShadowUserOnLogin")
    public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
    }
    @JsonProperty("assertionConsumerIndex")
    public void setAssertionConsumerIndex(@Nullable Integer assertionConsumerIndex) {
      this.assertionConsumerIndex = assertionConsumerIndex;
    }
    @JsonProperty("groupMappingMode")
    public void setGroupMappingMode(@Nullable ExternalGroupMappingMode groupMappingMode) {
      this.groupMappingMode = groupMappingMode;
    }
    @JsonProperty("iconUrl")
    public void setIconUrl(@Nullable String iconUrl) {
      this.iconUrl = iconUrl;
    }
    @JsonProperty("idpEntityAlias")
    public void setIdpEntityAlias(@Nullable String idpEntityAlias) {
      this.idpEntityAlias = idpEntityAlias;
    }
    @JsonProperty("linkText")
    public void setLinkText(@Nullable String linkText) {
      this.linkText = linkText;
    }
    @JsonProperty("metaDataLocation")
    public void setMetaDataLocation(String metaDataLocation) {
      this.metaDataLocation = metaDataLocation;
    }
    @JsonProperty("metadataTrustCheck")
    public void setMetadataTrustCheck(@Nullable Boolean metadataTrustCheck) {
      this.metadataTrustCheck = metadataTrustCheck;
    }
    @JsonProperty("nameID")
    public void setNameId(@Nullable String nameId) {
      this.nameId = nameId;
    }
    @JsonProperty("showSamlLink")
    public void setShowSamlLink(@Nullable Boolean showSamlLink) {
      this.showSamlLink = showSamlLink;
    }
    @JsonProperty("socketFactoryClassName")
    public void setSocketFactoryClassName(@Nullable String socketFactoryClassName) {
      this.socketFactoryClassName = socketFactoryClassName;
    }
    @JsonProperty("zoneId")
    public void setZoneId(@Nullable String zoneId) {
      this.zoneId = zoneId;
    }
    @JsonProperty("attributeMappings")
    public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
    }
    @JsonProperty("externalGroupsWhitelist")
    public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
      this.externalGroupsWhitelist = externalGroupsWhitelist;
    }
    @JsonProperty("emailDomain")
    public void setEmailDomains(@Nullable List<String> emailDomains) {
      this.emailDomains = emailDomains;
    }
    @JsonProperty("providerDescription")
    public void setProviderDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
    }
    @Override
    public Boolean getAddShadowUserOnLogin() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getAssertionConsumerIndex() { throw new UnsupportedOperationException(); }
    @Override
    public ExternalGroupMappingMode getGroupMappingMode() { throw new UnsupportedOperationException(); }
    @Override
    public String getIconUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdpEntityAlias() { throw new UnsupportedOperationException(); }
    @Override
    public String getLinkText() { throw new UnsupportedOperationException(); }
    @Override
    public String getMetaDataLocation() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getMetadataTrustCheck() { throw new UnsupportedOperationException(); }
    @Override
    public String getNameId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getShowSamlLink() { throw new UnsupportedOperationException(); }
    @Override
    public String getSocketFactoryClassName() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public AttributeMappings getAttributeMappings() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getExternalGroupsWhitelist() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getEmailDomains() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SamlConfiguration fromJson(Json json) {
    SamlConfiguration.Builder builder = SamlConfiguration.builder();
    if (json.addShadowUserOnLogin != null) {
      builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
    }
    if (json.assertionConsumerIndex != null) {
      builder.assertionConsumerIndex(json.assertionConsumerIndex);
    }
    if (json.groupMappingMode != null) {
      builder.groupMappingMode(json.groupMappingMode);
    }
    if (json.iconUrl != null) {
      builder.iconUrl(json.iconUrl);
    }
    if (json.idpEntityAlias != null) {
      builder.idpEntityAlias(json.idpEntityAlias);
    }
    if (json.linkText != null) {
      builder.linkText(json.linkText);
    }
    if (json.metaDataLocation != null) {
      builder.metaDataLocation(json.metaDataLocation);
    }
    if (json.metadataTrustCheck != null) {
      builder.metadataTrustCheck(json.metadataTrustCheck);
    }
    if (json.nameId != null) {
      builder.nameId(json.nameId);
    }
    if (json.showSamlLink != null) {
      builder.showSamlLink(json.showSamlLink);
    }
    if (json.socketFactoryClassName != null) {
      builder.socketFactoryClassName(json.socketFactoryClassName);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    if (json.attributeMappings != null) {
      builder.attributeMappings(json.attributeMappings);
    }
    if (json.externalGroupsWhitelist != null) {
      builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
    }
    if (json.emailDomains != null) {
      builder.addAllEmailDomains(json.emailDomains);
    }
    if (json.providerDescription != null) {
      builder.providerDescription(json.providerDescription);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SamlConfiguration SamlConfiguration}.
   * @return A new SamlConfiguration builder
   */
  public static SamlConfiguration.Builder builder() {
    return new SamlConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link SamlConfiguration SamlConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_META_DATA_LOCATION = 0x1L;
    private long initBits = 0x1L;

    private Boolean addShadowUserOnLogin;
    private Integer assertionConsumerIndex;
    private ExternalGroupMappingMode groupMappingMode;
    private String iconUrl;
    private String idpEntityAlias;
    private String linkText;
    private String metaDataLocation;
    private Boolean metadataTrustCheck;
    private String nameId;
    private Boolean showSamlLink;
    private String socketFactoryClassName;
    private String zoneId;
    private AttributeMappings attributeMappings;
    private List<String> externalGroupsWhitelist = null;
    private List<String> emailDomains = null;
    private String providerDescription;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code SamlConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SamlConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _SamlConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SamlConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractIdentityProviderConfiguration) {
        AbstractIdentityProviderConfiguration instance = (AbstractIdentityProviderConfiguration) object;
        List<String> emailDomainsValue = instance.getEmailDomains();
        if (emailDomainsValue != null) {
          addAllEmailDomains(emailDomainsValue);
        }
        String providerDescriptionValue = instance.getProviderDescription();
        if (providerDescriptionValue != null) {
          providerDescription(providerDescriptionValue);
        }
      }
      if (object instanceof AbstractExternalIdentityProviderConfiguration) {
        AbstractExternalIdentityProviderConfiguration instance = (AbstractExternalIdentityProviderConfiguration) object;
        List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
        if (externalGroupsWhitelistValue != null) {
          addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
        }
        AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
        if (attributeMappingsValue != null) {
          attributeMappings(attributeMappingsValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._SamlConfiguration) {
        org.cloudfoundry.uaa.identityproviders._SamlConfiguration instance = (org.cloudfoundry.uaa.identityproviders._SamlConfiguration) object;
        Boolean showSamlLinkValue = instance.getShowSamlLink();
        if (showSamlLinkValue != null) {
          showSamlLink(showSamlLinkValue);
        }
        Boolean metadataTrustCheckValue = instance.getMetadataTrustCheck();
        if (metadataTrustCheckValue != null) {
          metadataTrustCheck(metadataTrustCheckValue);
        }
        String nameIdValue = instance.getNameId();
        if (nameIdValue != null) {
          nameId(nameIdValue);
        }
        String zoneIdValue = instance.getZoneId();
        if (zoneIdValue != null) {
          zoneId(zoneIdValue);
        }
        String linkTextValue = instance.getLinkText();
        if (linkTextValue != null) {
          linkText(linkTextValue);
        }
        String idpEntityAliasValue = instance.getIdpEntityAlias();
        if (idpEntityAliasValue != null) {
          idpEntityAlias(idpEntityAliasValue);
        }
        Integer assertionConsumerIndexValue = instance.getAssertionConsumerIndex();
        if (assertionConsumerIndexValue != null) {
          assertionConsumerIndex(assertionConsumerIndexValue);
        }
        String iconUrlValue = instance.getIconUrl();
        if (iconUrlValue != null) {
          iconUrl(iconUrlValue);
        }
        Boolean addShadowUserOnLoginValue = instance.getAddShadowUserOnLogin();
        if (addShadowUserOnLoginValue != null) {
          addShadowUserOnLogin(addShadowUserOnLoginValue);
        }
        metaDataLocation(instance.getMetaDataLocation());
        ExternalGroupMappingMode groupMappingModeValue = instance.getGroupMappingMode();
        if (groupMappingModeValue != null) {
          groupMappingMode(groupMappingModeValue);
        }
        String socketFactoryClassNameValue = instance.getSocketFactoryClassName();
        if (socketFactoryClassNameValue != null) {
          socketFactoryClassName(socketFactoryClassNameValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getAddShadowUserOnLogin() addShadowUserOnLogin} attribute.
     * @param addShadowUserOnLogin The value for addShadowUserOnLogin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getAssertionConsumerIndex() assertionConsumerIndex} attribute.
     * @param assertionConsumerIndex The value for assertionConsumerIndex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder assertionConsumerIndex(@Nullable Integer assertionConsumerIndex) {
      this.assertionConsumerIndex = assertionConsumerIndex;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getGroupMappingMode() groupMappingMode} attribute.
     * @param groupMappingMode The value for groupMappingMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupMappingMode(@Nullable ExternalGroupMappingMode groupMappingMode) {
      this.groupMappingMode = groupMappingMode;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getIconUrl() iconUrl} attribute.
     * @param iconUrl The value for iconUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder iconUrl(@Nullable String iconUrl) {
      this.iconUrl = iconUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getIdpEntityAlias() idpEntityAlias} attribute.
     * @param idpEntityAlias The value for idpEntityAlias (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder idpEntityAlias(@Nullable String idpEntityAlias) {
      this.idpEntityAlias = idpEntityAlias;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getLinkText() linkText} attribute.
     * @param linkText The value for linkText (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder linkText(@Nullable String linkText) {
      this.linkText = linkText;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getMetaDataLocation() metaDataLocation} attribute.
     * @param metaDataLocation The value for metaDataLocation 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metaDataLocation(String metaDataLocation) {
      this.metaDataLocation = Objects.requireNonNull(metaDataLocation, "metaDataLocation");
      initBits &= ~INIT_BIT_META_DATA_LOCATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getMetadataTrustCheck() metadataTrustCheck} attribute.
     * @param metadataTrustCheck The value for metadataTrustCheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadataTrustCheck(@Nullable Boolean metadataTrustCheck) {
      this.metadataTrustCheck = metadataTrustCheck;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getNameId() nameId} attribute.
     * @param nameId The value for nameId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nameId(@Nullable String nameId) {
      this.nameId = nameId;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getShowSamlLink() showSamlLink} attribute.
     * @param showSamlLink The value for showSamlLink (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder showSamlLink(@Nullable Boolean showSamlLink) {
      this.showSamlLink = showSamlLink;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getSocketFactoryClassName() socketFactoryClassName} attribute.
     * @param socketFactoryClassName The value for socketFactoryClassName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder socketFactoryClassName(@Nullable String socketFactoryClassName) {
      this.socketFactoryClassName = socketFactoryClassName;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(@Nullable String zoneId) {
      this.zoneId = zoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getAttributeMappings() attributeMappings} attribute.
     * @param attributeMappings The value for attributeMappings (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
      return this;
    }

    /**
     * Adds one element to {@link _SamlConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param element A externalGroupsWhitelist element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String element) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      return this;
    }

    /**
     * Adds elements to {@link _SamlConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An array of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String... elements) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _SamlConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.externalGroupsWhitelist = null;
        return this;
      }
      this.externalGroupsWhitelist = new ArrayList<String>();
      return addAllExternalGroupsWhitelist(elements);
    }

    /**
     * Adds elements to {@link _SamlConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
      Objects.requireNonNull(elements, "externalGroupsWhitelist element");
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _SamlConfiguration#getEmailDomains() emailDomains} list.
     * @param element A emailDomains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String element) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      return this;
    }

    /**
     * Adds elements to {@link _SamlConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An array of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String... elements) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _SamlConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.emailDomains = null;
        return this;
      }
      this.emailDomains = new ArrayList<String>();
      return addAllEmailDomains(elements);
    }

    /**
     * Adds elements to {@link _SamlConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmailDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "emailDomains element");
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getProviderDescription() providerDescription} attribute.
     * @param providerDescription The value for providerDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder providerDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
      return this;
    }

    /**
     * Builds a new {@link SamlConfiguration SamlConfiguration}.
     * @return An immutable instance of SamlConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SamlConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SamlConfiguration(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_META_DATA_LOCATION) != 0) attributes.add("metaDataLocation");
      return "Cannot build SamlConfiguration, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
