package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _UpdateIdentityProviderResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateIdentityProviderResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UpdateIdentityProviderResponse"})
public final class UpdateIdentityProviderResponse
    extends org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderResponse {
  private final Boolean active;
  private final @Nullable IdentityProviderConfiguration configuration;
  private final Long createdAt;
  private final String id;
  private final String identityZoneId;
  private final Long lastModified;
  private final String name;
  private final String originKey;
  private final Type type;
  private final Integer version;

  private UpdateIdentityProviderResponse(UpdateIdentityProviderResponse.Builder builder) {
    this.active = builder.active;
    this.configuration = builder.configuration;
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.identityZoneId = builder.identityZoneId;
    this.lastModified = builder.lastModified;
    this.name = builder.name;
    this.originKey = builder.originKey;
    this.type = builder.type;
    this.version = builder.version;
  }

  /**
   * Whether the identity provider is active
   */
  @JsonProperty("active")
  @Override
  public Boolean getActive() {
    return active;
  }

  /**
   * The configuration of this identity provider
   */
  @JsonProperty("config")
  @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
  @JsonSubTypes({@JsonSubTypes.Type(name = "saml", value = SamlConfiguration.class), @JsonSubTypes.Type(name = "ldap", value = LdapConfiguration.class), @JsonSubTypes.Type(name = "oauth2.0", value = Oauth2Configuration.class), @JsonSubTypes.Type(name = "oidc1.0", value = OpenIdConnectConfiguration.class), @JsonSubTypes.Type(name = "keystone", value = KeystoneConfiguration.class), @JsonSubTypes.Type(name = "uaa", value = InternalConfiguration.class)})
  @Override
  public @Nullable IdentityProviderConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The creation date of the identity provider
   */
  @JsonProperty("created")
  @Override
  public Long getCreatedAt() {
    return createdAt;
  }

  /**
   * The id
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Set to the zone that this provider will be active in. Determined either by the Host header or the zone switch header.
   */
  @JsonProperty("identityZoneId")
  @Override
  public String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * The last modification date of the identity provider
   */
  @JsonProperty("last_modified")
  @Override
  public Long getLastModified() {
    return lastModified;
  }

  /**
   * Human-readable name for this provider
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * A unique alias for the provider
   */
  @JsonProperty("originKey")
  @Override
  public String getOriginKey() {
    return originKey;
  }

  /**
   * The type of identity provider
   */
  @JsonProperty("type")
  @Override
  public Type getType() {
    return type;
  }

  /**
   * Version of the identity provider data. Clients can use this to protect against conflicting updates
   */
  @JsonProperty("version")
  @Override
  public Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code UpdateIdentityProviderResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateIdentityProviderResponse
        && equalTo((UpdateIdentityProviderResponse) another);
  }

  private boolean equalTo(UpdateIdentityProviderResponse another) {
    return active.equals(another.active)
        && Objects.equals(configuration, another.configuration)
        && createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && identityZoneId.equals(another.identityZoneId)
        && lastModified.equals(another.lastModified)
        && name.equals(another.name)
        && originKey.equals(another.originKey)
        && type.equals(another.type)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code configuration}, {@code createdAt}, {@code id}, {@code identityZoneId}, {@code lastModified}, {@code name}, {@code originKey}, {@code type}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + active.hashCode();
    h = h * 17 + Objects.hashCode(configuration);
    h = h * 17 + createdAt.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + identityZoneId.hashCode();
    h = h * 17 + lastModified.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + originKey.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateIdentityProviderResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateIdentityProviderResponse{"
        + "active=" + active
        + ", configuration=" + configuration
        + ", createdAt=" + createdAt
        + ", id=" + id
        + ", identityZoneId=" + identityZoneId
        + ", lastModified=" + lastModified
        + ", name=" + name
        + ", originKey=" + originKey
        + ", type=" + type
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderResponse {
    Boolean active;
    IdentityProviderConfiguration configuration;
    Long createdAt;
    String id;
    String identityZoneId;
    Long lastModified;
    String name;
    String originKey;
    Type type;
    Integer version;
    @JsonProperty("active")
    public void setActive(Boolean active) {
      this.active = active;
    }
    @JsonProperty("config")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "saml", value = SamlConfiguration.class), @JsonSubTypes.Type(name = "ldap", value = LdapConfiguration.class), @JsonSubTypes.Type(name = "oauth2.0", value = Oauth2Configuration.class), @JsonSubTypes.Type(name = "oidc1.0", value = OpenIdConnectConfiguration.class), @JsonSubTypes.Type(name = "keystone", value = KeystoneConfiguration.class), @JsonSubTypes.Type(name = "uaa", value = InternalConfiguration.class)})
    public void setConfiguration(@Nullable IdentityProviderConfiguration configuration) {
      this.configuration = configuration;
    }
    @JsonProperty("created")
    public void setCreatedAt(Long createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("identityZoneId")
    public void setIdentityZoneId(String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("last_modified")
    public void setLastModified(Long lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("originKey")
    public void setOriginKey(String originKey) {
      this.originKey = originKey;
    }
    @JsonProperty("type")
    public void setType(Type type) {
      this.type = type;
    }
    @JsonProperty("version")
    public void setVersion(Integer version) {
      this.version = version;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public IdentityProviderConfiguration getConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public Long getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOriginKey() { throw new UnsupportedOperationException(); }
    @Override
    public Type getType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UpdateIdentityProviderResponse fromJson(Json json) {
    UpdateIdentityProviderResponse.Builder builder = UpdateIdentityProviderResponse.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.originKey != null) {
      builder.originKey(json.originKey);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateIdentityProviderResponse UpdateIdentityProviderResponse}.
   * @return A new UpdateIdentityProviderResponse builder
   */
  public static UpdateIdentityProviderResponse.Builder builder() {
    return new UpdateIdentityProviderResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateIdentityProviderResponse UpdateIdentityProviderResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ACTIVE = 0x1L;
    private static final long INIT_BIT_CREATED_AT = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private static final long INIT_BIT_IDENTITY_ZONE_ID = 0x8L;
    private static final long INIT_BIT_LAST_MODIFIED = 0x10L;
    private static final long INIT_BIT_NAME = 0x20L;
    private static final long INIT_BIT_ORIGIN_KEY = 0x40L;
    private static final long INIT_BIT_TYPE = 0x80L;
    private static final long INIT_BIT_VERSION = 0x100L;
    private long initBits = 0x1ffL;

    private Boolean active;
    private IdentityProviderConfiguration configuration;
    private Long createdAt;
    private String id;
    private String identityZoneId;
    private Long lastModified;
    private String name;
    private String originKey;
    private Type type;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateIdentityProviderResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateIdentityProviderResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateIdentityProviderResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateIdentityProviderResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractIdentityProvider) {
        AbstractIdentityProvider instance = (AbstractIdentityProvider) object;
        createdAt(instance.getCreatedAt());
        IdentityProviderConfiguration configurationValue = instance.getConfiguration();
        if (configurationValue != null) {
          configuration(configurationValue);
        }
        originKey(instance.getOriginKey());
        name(instance.getName());
        active(instance.getActive());
        id(instance.getId());
        lastModified(instance.getLastModified());
        type(instance.getType());
        identityZoneId(instance.getIdentityZoneId());
        version(instance.getVersion());
      }
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getActive() active} attribute.
     * @param active The value for active 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(Boolean active) {
      this.active = Objects.requireNonNull(active, "active");
      initBits &= ~INIT_BIT_ACTIVE;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(@Nullable IdentityProviderConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createdAt(Long createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(String identityZoneId) {
      this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
      initBits &= ~INIT_BIT_IDENTITY_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastModified(Long lastModified) {
      this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
      initBits &= ~INIT_BIT_LAST_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getOriginKey() originKey} attribute.
     * @param originKey The value for originKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder originKey(String originKey) {
      this.originKey = Objects.requireNonNull(originKey, "originKey");
      initBits &= ~INIT_BIT_ORIGIN_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderResponse#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link UpdateIdentityProviderResponse UpdateIdentityProviderResponse}.
     * @return An immutable instance of UpdateIdentityProviderResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateIdentityProviderResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateIdentityProviderResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ACTIVE) != 0) attributes.add("active");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_IDENTITY_ZONE_ID) != 0) attributes.add("identityZoneId");
      if ((initBits & INIT_BIT_LAST_MODIFIED) != 0) attributes.add("lastModified");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORIGIN_KEY) != 0) attributes.add("originKey");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build UpdateIdentityProviderResponse, some of required attributes are not set " + attributes;
    }
  }
}
