package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _IdentityZoneConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code IdentityZoneConfiguration.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_IdentityZoneConfiguration"})
public final class IdentityZoneConfiguration
    extends org.cloudfoundry.uaa.identityzones._IdentityZoneConfiguration {
  private final @Nullable Boolean ldapDiscoveryEnabled;
  private final @Nullable Links links;
  private final @Nullable List<Prompt> prompts;
  private final @Nullable SamlConfiguration samlConfiguration;
  private final @Nullable TokenPolicy tokenPolicy;

  private IdentityZoneConfiguration(IdentityZoneConfiguration.Builder builder) {
    this.ldapDiscoveryEnabled = builder.ldapDiscoveryEnabled;
    this.links = builder.links;
    this.prompts = builder.prompts == null ? null : createUnmodifiableList(true, builder.prompts);
    this.samlConfiguration = builder.samlConfiguration;
    this.tokenPolicy = builder.tokenPolicy;
  }

  /**
   * IDP Discovery should be set to true if you have configured more than one identity provider for UAA. The discovery relies on email domain being set for each additional provider.
   */
  @JsonProperty("idpDiscoveryEnabled")
  @Override
  public @Nullable Boolean getLdapDiscoveryEnabled() {
    return ldapDiscoveryEnabled;
  }

  /**
   * Array The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Links getLinks() {
    return links;
  }

  /**
   * The prompts
   */
  @JsonProperty("prompts")
  @Override
  public @Nullable List<Prompt> getPrompts() {
    return prompts;
  }

  /**
   * The saml configuration
   */
  @JsonProperty("samlConfig")
  @Override
  public @Nullable SamlConfiguration getSamlConfiguration() {
    return samlConfiguration;
  }

  /**
   * The token policy
   */
  @JsonProperty("tokenPolicy")
  @Override
  public @Nullable TokenPolicy getTokenPolicy() {
    return tokenPolicy;
  }

  /**
   * This instance is equal to all instances of {@code IdentityZoneConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof IdentityZoneConfiguration
        && equalTo((IdentityZoneConfiguration) another);
  }

  private boolean equalTo(IdentityZoneConfiguration another) {
    return Objects.equals(ldapDiscoveryEnabled, another.ldapDiscoveryEnabled)
        && Objects.equals(links, another.links)
        && Objects.equals(prompts, another.prompts)
        && Objects.equals(samlConfiguration, another.samlConfiguration)
        && Objects.equals(tokenPolicy, another.tokenPolicy);
  }

  /**
   * Computes a hash code from attributes: {@code ldapDiscoveryEnabled}, {@code links}, {@code prompts}, {@code samlConfiguration}, {@code tokenPolicy}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(ldapDiscoveryEnabled);
    h = h * 17 + Objects.hashCode(links);
    h = h * 17 + Objects.hashCode(prompts);
    h = h * 17 + Objects.hashCode(samlConfiguration);
    h = h * 17 + Objects.hashCode(tokenPolicy);
    return h;
  }

  /**
   * Prints the immutable value {@code IdentityZoneConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IdentityZoneConfiguration{"
        + "ldapDiscoveryEnabled=" + ldapDiscoveryEnabled
        + ", links=" + links
        + ", prompts=" + prompts
        + ", samlConfiguration=" + samlConfiguration
        + ", tokenPolicy=" + tokenPolicy
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.identityzones._IdentityZoneConfiguration {
    Boolean ldapDiscoveryEnabled;
    Links links;
    List<Prompt> prompts = null;
    SamlConfiguration samlConfiguration;
    TokenPolicy tokenPolicy;
    @JsonProperty("idpDiscoveryEnabled")
    public void setLdapDiscoveryEnabled(@Nullable Boolean ldapDiscoveryEnabled) {
      this.ldapDiscoveryEnabled = ldapDiscoveryEnabled;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Links links) {
      this.links = links;
    }
    @JsonProperty("prompts")
    public void setPrompts(@Nullable List<Prompt> prompts) {
      this.prompts = prompts;
    }
    @JsonProperty("samlConfig")
    public void setSamlConfiguration(@Nullable SamlConfiguration samlConfiguration) {
      this.samlConfiguration = samlConfiguration;
    }
    @JsonProperty("tokenPolicy")
    public void setTokenPolicy(@Nullable TokenPolicy tokenPolicy) {
      this.tokenPolicy = tokenPolicy;
    }
    @Override
    public Boolean getLdapDiscoveryEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public Links getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public List<Prompt> getPrompts() { throw new UnsupportedOperationException(); }
    @Override
    public SamlConfiguration getSamlConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public TokenPolicy getTokenPolicy() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static IdentityZoneConfiguration fromJson(Json json) {
    IdentityZoneConfiguration.Builder builder = IdentityZoneConfiguration.builder();
    if (json.ldapDiscoveryEnabled != null) {
      builder.ldapDiscoveryEnabled(json.ldapDiscoveryEnabled);
    }
    if (json.links != null) {
      builder.links(json.links);
    }
    if (json.prompts != null) {
      builder.addAllPrompts(json.prompts);
    }
    if (json.samlConfiguration != null) {
      builder.samlConfiguration(json.samlConfiguration);
    }
    if (json.tokenPolicy != null) {
      builder.tokenPolicy(json.tokenPolicy);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link IdentityZoneConfiguration IdentityZoneConfiguration}.
   * @return A new IdentityZoneConfiguration builder
   */
  public static IdentityZoneConfiguration.Builder builder() {
    return new IdentityZoneConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link IdentityZoneConfiguration IdentityZoneConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean ldapDiscoveryEnabled;
    private Links links;
    private List<Prompt> prompts = null;
    private SamlConfiguration samlConfiguration;
    private TokenPolicy tokenPolicy;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IdentityZoneConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoneConfiguration instance) {
      return from((_IdentityZoneConfiguration) instance);
    }

    /**
     * Copy abstract value type {@code _IdentityZoneConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_IdentityZoneConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean ldapDiscoveryEnabledValue = instance.getLdapDiscoveryEnabled();
      if (ldapDiscoveryEnabledValue != null) {
        ldapDiscoveryEnabled(ldapDiscoveryEnabledValue);
      }
      Links linksValue = instance.getLinks();
      if (linksValue != null) {
        links(linksValue);
      }
      List<Prompt> promptsValue = instance.getPrompts();
      if (promptsValue != null) {
        addAllPrompts(promptsValue);
      }
      SamlConfiguration samlConfigurationValue = instance.getSamlConfiguration();
      if (samlConfigurationValue != null) {
        samlConfiguration(samlConfigurationValue);
      }
      TokenPolicy tokenPolicyValue = instance.getTokenPolicy();
      if (tokenPolicyValue != null) {
        tokenPolicy(tokenPolicyValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _IdentityZoneConfiguration#getLdapDiscoveryEnabled() ldapDiscoveryEnabled} attribute.
     * @param ldapDiscoveryEnabled The value for ldapDiscoveryEnabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ldapDiscoveryEnabled(@Nullable Boolean ldapDiscoveryEnabled) {
      this.ldapDiscoveryEnabled = ldapDiscoveryEnabled;
      return this;
    }

    /**
     * Initializes the value for the {@link _IdentityZoneConfiguration#getLinks() links} attribute.
     * @param links The value for links (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder links(@Nullable Links links) {
      this.links = links;
      return this;
    }

    /**
     * Adds one element to {@link _IdentityZoneConfiguration#getPrompts() prompts} list.
     * @param element A prompts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder prompt(Prompt element) {
      if (this.prompts == null) {
        this.prompts = new ArrayList<Prompt>();
      }
      this.prompts.add(Objects.requireNonNull(element, "prompts element"));
      return this;
    }

    /**
     * Adds elements to {@link _IdentityZoneConfiguration#getPrompts() prompts} list.
     * @param elements An array of prompts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder prompt(Prompt... elements) {
      if (this.prompts == null) {
        this.prompts = new ArrayList<Prompt>();
      }
      for (Prompt element : elements) {
        this.prompts.add(Objects.requireNonNull(element, "prompts element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _IdentityZoneConfiguration#getPrompts() prompts} list.
     * @param elements An iterable of prompts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder prompts(@Nullable Iterable<? extends Prompt> elements) {
      if (elements == null) {
        this.prompts = null;
        return this;
      }
      this.prompts = new ArrayList<Prompt>();
      return addAllPrompts(elements);
    }

    /**
     * Adds elements to {@link _IdentityZoneConfiguration#getPrompts() prompts} list.
     * @param elements An iterable of prompts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPrompts(Iterable<? extends Prompt> elements) {
      Objects.requireNonNull(elements, "prompts element");
      if (this.prompts == null) {
        this.prompts = new ArrayList<Prompt>();
      }
      for (Prompt element : elements) {
        this.prompts.add(Objects.requireNonNull(element, "prompts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _IdentityZoneConfiguration#getSamlConfiguration() samlConfiguration} attribute.
     * @param samlConfiguration The value for samlConfiguration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder samlConfiguration(@Nullable SamlConfiguration samlConfiguration) {
      this.samlConfiguration = samlConfiguration;
      return this;
    }

    /**
     * Initializes the value for the {@link _IdentityZoneConfiguration#getTokenPolicy() tokenPolicy} attribute.
     * @param tokenPolicy The value for tokenPolicy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenPolicy(@Nullable TokenPolicy tokenPolicy) {
      this.tokenPolicy = tokenPolicy;
      return this;
    }

    /**
     * Builds a new {@link IdentityZoneConfiguration IdentityZoneConfiguration}.
     * @return An immutable instance of IdentityZoneConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IdentityZoneConfiguration build() {
      return new IdentityZoneConfiguration(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
