package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _KeyInformation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code KeyInformation.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_KeyInformation"})
public final class KeyInformation extends org.cloudfoundry.uaa.identityzones._KeyInformation {
  private final @Nullable String signingKey;

  private KeyInformation(KeyInformation.Builder builder) {
    this.signingKey = builder.signingKey;
  }

  /**
   * The Signing key
   */
  @JsonProperty("signingKey")
  @Override
  public @Nullable String getSigningKey() {
    return signingKey;
  }

  /**
   * This instance is equal to all instances of {@code KeyInformation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof KeyInformation
        && equalTo((KeyInformation) another);
  }

  private boolean equalTo(KeyInformation another) {
    return Objects.equals(signingKey, another.signingKey);
  }

  /**
   * Computes a hash code from attributes: {@code signingKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(signingKey);
    return h;
  }

  /**
   * Prints the immutable value {@code KeyInformation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "KeyInformation{"
        + "signingKey=" + signingKey
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.identityzones._KeyInformation {
    String signingKey;
    @JsonProperty("signingKey")
    public void setSigningKey(@Nullable String signingKey) {
      this.signingKey = signingKey;
    }
    @Override
    public String getSigningKey() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static KeyInformation fromJson(Json json) {
    KeyInformation.Builder builder = KeyInformation.builder();
    if (json.signingKey != null) {
      builder.signingKey(json.signingKey);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link KeyInformation KeyInformation}.
   * @return A new KeyInformation builder
   */
  public static KeyInformation.Builder builder() {
    return new KeyInformation.Builder();
  }

  /**
   * Builds instances of type {@link KeyInformation KeyInformation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String signingKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeyInformation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(KeyInformation instance) {
      return from((_KeyInformation) instance);
    }

    /**
     * Copy abstract value type {@code _KeyInformation} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_KeyInformation instance) {
      Objects.requireNonNull(instance, "instance");
      String signingKeyValue = instance.getSigningKey();
      if (signingKeyValue != null) {
        signingKey(signingKeyValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _KeyInformation#getSigningKey() signingKey} attribute.
     * @param signingKey The value for signingKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder signingKey(@Nullable String signingKey) {
      this.signingKey = signingKey;
      return this;
    }

    /**
     * Builds a new {@link KeyInformation KeyInformation}.
     * @return An immutable instance of KeyInformation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public KeyInformation build() {
      return new KeyInformation(this);
    }
  }
}
