package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _TokenPolicy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code TokenPolicy.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_TokenPolicy"})
public final class TokenPolicy extends org.cloudfoundry.uaa.identityzones._TokenPolicy {
  private final @Nullable Integer accessTokenValidity;
  private final @Nullable String activeKeyId;
  private final @Nullable Boolean jwtRevokable;
  private final @Nullable Map<String, KeyInformation> keys;
  private final @Nullable Integer refreshTokenValidity;

  private TokenPolicy(TokenPolicy.Builder builder) {
    this.accessTokenValidity = builder.accessTokenValidity;
    this.activeKeyId = builder.activeKeyId;
    this.jwtRevokable = builder.jwtRevokable;
    this.keys = builder.keys == null ? null : createUnmodifiableMap(false, false, builder.keys);
    this.refreshTokenValidity = builder.refreshTokenValidity;
  }

  /**
   * Time in seconds between when a access token is issued and when it expires
   */
  @JsonProperty("accessTokenValidity")
  @Override
  public @Nullable Integer getAccessTokenValidity() {
    return accessTokenValidity;
  }

  /**
   * The ID of the key that is used to sign tokens
   */
  @JsonProperty("activeKeyId")
  @Override
  public @Nullable String getActiveKeyId() {
    return activeKeyId;
  }

  /**
   * @return The value of the {@code jwtRevokable} attribute
   */
  @JsonProperty("jwtRevocable")
  @Override
  public @Nullable Boolean getJwtRevokable() {
    return jwtRevokable;
  }

  /**
   * The keys of the token policy
   */
  @JsonProperty("keys")
  @Override
  public @Nullable Map<String, KeyInformation> getKeys() {
    return keys;
  }

  /**
   * Time in seconds between when a refresh token is issued and when it expires
   */
  @JsonProperty("refreshTokenValidity")
  @Override
  public @Nullable Integer getRefreshTokenValidity() {
    return refreshTokenValidity;
  }

  /**
   * This instance is equal to all instances of {@code TokenPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TokenPolicy
        && equalTo((TokenPolicy) another);
  }

  private boolean equalTo(TokenPolicy another) {
    return Objects.equals(accessTokenValidity, another.accessTokenValidity)
        && Objects.equals(activeKeyId, another.activeKeyId)
        && Objects.equals(jwtRevokable, another.jwtRevokable)
        && Objects.equals(keys, another.keys)
        && Objects.equals(refreshTokenValidity, another.refreshTokenValidity);
  }

  /**
   * Computes a hash code from attributes: {@code accessTokenValidity}, {@code activeKeyId}, {@code jwtRevokable}, {@code keys}, {@code refreshTokenValidity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(accessTokenValidity);
    h = h * 17 + Objects.hashCode(activeKeyId);
    h = h * 17 + Objects.hashCode(jwtRevokable);
    h = h * 17 + Objects.hashCode(keys);
    h = h * 17 + Objects.hashCode(refreshTokenValidity);
    return h;
  }

  /**
   * Prints the immutable value {@code TokenPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TokenPolicy{"
        + "accessTokenValidity=" + accessTokenValidity
        + ", activeKeyId=" + activeKeyId
        + ", jwtRevokable=" + jwtRevokable
        + ", keys=" + keys
        + ", refreshTokenValidity=" + refreshTokenValidity
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.identityzones._TokenPolicy {
    Integer accessTokenValidity;
    String activeKeyId;
    Boolean jwtRevokable;
    Map<String, KeyInformation> keys;
    Integer refreshTokenValidity;
    @JsonProperty("accessTokenValidity")
    public void setAccessTokenValidity(@Nullable Integer accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
    }
    @JsonProperty("activeKeyId")
    public void setActiveKeyId(@Nullable String activeKeyId) {
      this.activeKeyId = activeKeyId;
    }
    @JsonProperty("jwtRevocable")
    public void setJwtRevokable(@Nullable Boolean jwtRevokable) {
      this.jwtRevokable = jwtRevokable;
    }
    @JsonProperty("keys")
    public void setKeys(@Nullable Map<String, KeyInformation> keys) {
      this.keys = keys;
    }
    @JsonProperty("refreshTokenValidity")
    public void setRefreshTokenValidity(@Nullable Integer refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
    }
    @Override
    public Integer getAccessTokenValidity() { throw new UnsupportedOperationException(); }
    @Override
    public String getActiveKeyId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getJwtRevokable() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, KeyInformation> getKeys() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getRefreshTokenValidity() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static TokenPolicy fromJson(Json json) {
    TokenPolicy.Builder builder = TokenPolicy.builder();
    if (json.accessTokenValidity != null) {
      builder.accessTokenValidity(json.accessTokenValidity);
    }
    if (json.activeKeyId != null) {
      builder.activeKeyId(json.activeKeyId);
    }
    if (json.jwtRevokable != null) {
      builder.jwtRevokable(json.jwtRevokable);
    }
    if (json.keys != null) {
      builder.putAllKeys(json.keys);
    }
    if (json.refreshTokenValidity != null) {
      builder.refreshTokenValidity(json.refreshTokenValidity);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TokenPolicy TokenPolicy}.
   * @return A new TokenPolicy builder
   */
  public static TokenPolicy.Builder builder() {
    return new TokenPolicy.Builder();
  }

  /**
   * Builds instances of type {@link TokenPolicy TokenPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer accessTokenValidity;
    private String activeKeyId;
    private Boolean jwtRevokable;
    private Map<String, KeyInformation> keys = null;
    private Integer refreshTokenValidity;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TokenPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TokenPolicy instance) {
      return from((_TokenPolicy) instance);
    }

    /**
     * Copy abstract value type {@code _TokenPolicy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TokenPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      Integer accessTokenValidityValue = instance.getAccessTokenValidity();
      if (accessTokenValidityValue != null) {
        accessTokenValidity(accessTokenValidityValue);
      }
      String activeKeyIdValue = instance.getActiveKeyId();
      if (activeKeyIdValue != null) {
        activeKeyId(activeKeyIdValue);
      }
      Boolean jwtRevokableValue = instance.getJwtRevokable();
      if (jwtRevokableValue != null) {
        jwtRevokable(jwtRevokableValue);
      }
      Map<String, KeyInformation> keysValue = instance.getKeys();
      if (keysValue != null) {
        putAllKeys(keysValue);
      }
      Integer refreshTokenValidityValue = instance.getRefreshTokenValidity();
      if (refreshTokenValidityValue != null) {
        refreshTokenValidity(refreshTokenValidityValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getAccessTokenValidity() accessTokenValidity} attribute.
     * @param accessTokenValidity The value for accessTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder accessTokenValidity(@Nullable Integer accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getActiveKeyId() activeKeyId} attribute.
     * @param activeKeyId The value for activeKeyId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder activeKeyId(@Nullable String activeKeyId) {
      this.activeKeyId = activeKeyId;
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getJwtRevokable() jwtRevokable} attribute.
     * @param jwtRevokable The value for jwtRevokable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jwtRevokable(@Nullable Boolean jwtRevokable) {
      this.jwtRevokable = jwtRevokable;
      return this;
    }

    /**
     * Put one entry to the {@link _TokenPolicy#getKeys() keys} map.
     * @param key The key in the keys map
     * @param value The associated value in the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key, KeyInformation value) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, KeyInformation>();
      }
      this.keys.put(
          Objects.requireNonNull(key, "keys key"),
          Objects.requireNonNull(value, "keys value"));
      return this;
    }

    /**
     * Put one entry to the {@link _TokenPolicy#getKeys() keys} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(Map.Entry<String, ? extends KeyInformation> entry) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, KeyInformation>();
      }
      String k = entry.getKey();
      KeyInformation v = entry.getValue();
      this.keys.put(
          Objects.requireNonNull(k, "keys key"),
          Objects.requireNonNull(v, "keys value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _TokenPolicy#getKeys() keys} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param keys The entries that will be added to the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keys(@Nullable Map<String, ? extends KeyInformation> keys) {
      if (keys == null) {
        this.keys = null;
        return this;
      }
      this.keys = new LinkedHashMap<String, KeyInformation>();
      return putAllKeys(keys);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _TokenPolicy#getKeys() keys} map. Nulls are not permitted
     * @param keys The entries that will be added to the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllKeys(Map<String, ? extends KeyInformation> keys) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, KeyInformation>();
      }
      for (Map.Entry<String, ? extends KeyInformation> entry : keys.entrySet()) {
        String k = entry.getKey();
        KeyInformation v = entry.getValue();
        this.keys.put(
            Objects.requireNonNull(k, "keys key"),
            Objects.requireNonNull(v, "keys value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getRefreshTokenValidity() refreshTokenValidity} attribute.
     * @param refreshTokenValidity The value for refreshTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder refreshTokenValidity(@Nullable Integer refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
      return this;
    }

    /**
     * Builds a new {@link TokenPolicy TokenPolicy}.
     * @return An immutable instance of TokenPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TokenPolicy build() {
      return new TokenPolicy(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
