package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _ListTokenKeysResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ListTokenKeysResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ListTokenKeysResponse"})
public final class ListTokenKeysResponse extends org.cloudfoundry.uaa.tokens._ListTokenKeysResponse {
  private final List<TokenKey> keys;

  private ListTokenKeysResponse(ListTokenKeysResponse.Builder builder) {
    this.keys = createUnmodifiableList(true, builder.keys);
  }

  /**
   * The token keys
   */
  @JsonProperty("keys")
  @Override
  public List<TokenKey> getKeys() {
    return keys;
  }

  /**
   * This instance is equal to all instances of {@code ListTokenKeysResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListTokenKeysResponse
        && equalTo((ListTokenKeysResponse) another);
  }

  private boolean equalTo(ListTokenKeysResponse another) {
    return keys.equals(another.keys);
  }

  /**
   * Computes a hash code from attributes: {@code keys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + keys.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListTokenKeysResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListTokenKeysResponse{"
        + "keys=" + keys
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.tokens._ListTokenKeysResponse {
    List<TokenKey> keys = Collections.emptyList();
    @JsonProperty("keys")
    public void setKeys(List<TokenKey> keys) {
      this.keys = keys;
    }
    @Override
    public List<TokenKey> getKeys() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ListTokenKeysResponse fromJson(Json json) {
    ListTokenKeysResponse.Builder builder = ListTokenKeysResponse.builder();
    if (json.keys != null) {
      builder.addAllKeys(json.keys);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListTokenKeysResponse ListTokenKeysResponse}.
   * @return A new ListTokenKeysResponse builder
   */
  public static ListTokenKeysResponse.Builder builder() {
    return new ListTokenKeysResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListTokenKeysResponse ListTokenKeysResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<TokenKey> keys = new ArrayList<TokenKey>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListTokenKeysResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListTokenKeysResponse instance) {
      return from((_ListTokenKeysResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListTokenKeysResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListTokenKeysResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllKeys(instance.getKeys());
      return this;
    }

    /**
     * Adds one element to {@link _ListTokenKeysResponse#getKeys() keys} list.
     * @param element A keys element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(TokenKey element) {
      this.keys.add(Objects.requireNonNull(element, "keys element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListTokenKeysResponse#getKeys() keys} list.
     * @param elements An array of keys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(TokenKey... elements) {
      for (TokenKey element : elements) {
        this.keys.add(Objects.requireNonNull(element, "keys element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListTokenKeysResponse#getKeys() keys} list.
     * @param elements An iterable of keys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keys(Iterable<? extends TokenKey> elements) {
      this.keys.clear();
      return addAllKeys(elements);
    }

    /**
     * Adds elements to {@link _ListTokenKeysResponse#getKeys() keys} list.
     * @param elements An iterable of keys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllKeys(Iterable<? extends TokenKey> elements) {
      for (TokenKey element : elements) {
        this.keys.add(Objects.requireNonNull(element, "keys element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListTokenKeysResponse ListTokenKeysResponse}.
     * @return An immutable instance of ListTokenKeysResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListTokenKeysResponse build() {
      return new ListTokenKeysResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
