package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _DeleteUserResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteUserResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DeleteUserResponse"})
public final class DeleteUserResponse extends org.cloudfoundry.uaa.users._DeleteUserResponse {
  private final List<Approval> approval;
  private final String externalId;
  private final List<Group> group;
  private final Boolean active;
  private final List<Email> email;
  private final Meta meta;
  private final Name name;
  private final String passwordLastModified;
  private final List<String> schemas;
  private final Boolean verified;
  private final String zoneId;
  private final String id;
  private final String origin;
  private final String userName;

  private DeleteUserResponse(DeleteUserResponse.Builder builder) {
    this.approval = createUnmodifiableList(true, builder.approval);
    this.externalId = builder.externalId;
    this.group = createUnmodifiableList(true, builder.group);
    this.active = builder.active;
    this.email = createUnmodifiableList(true, builder.email);
    this.meta = builder.meta;
    this.name = builder.name;
    this.passwordLastModified = builder.passwordLastModified;
    this.schemas = createUnmodifiableList(true, builder.schemas);
    this.verified = builder.verified;
    this.zoneId = builder.zoneId;
    this.id = builder.id;
    this.origin = builder.origin;
    this.userName = builder.userName;
  }

  /**
   * The approvals for the user
   */
  @JsonProperty("approvals")
  @Override
  public List<Approval> getApproval() {
    return approval;
  }

  /**
   * The external id
   */
  @JsonProperty("externalId")
  @Override
  public String getExternalId() {
    return externalId;
  }

  /**
   * The groups for the user
   */
  @JsonProperty("groups")
  @Override
  public List<Group> getGroup() {
    return group;
  }

  /**
   * Whether the user is active
   */
  @JsonProperty("active")
  @Override
  public Boolean getActive() {
    return active;
  }

  /**
   * The emails for the user
   */
  @JsonProperty("emails")
  @Override
  public List<Email> getEmail() {
    return email;
  }

  /**
   * Metadata for the result
   */
  @JsonProperty("meta")
  @Override
  public Meta getMeta() {
    return meta;
  }

  /**
   * The user's name
   */
  @JsonProperty("name")
  @Override
  public Name getName() {
    return name;
  }

  /**
   * The timestamp when the user's password was last modified
   */
  @JsonProperty("passwordLastModified")
  @Override
  public String getPasswordLastModified() {
    return passwordLastModified;
  }

  /**
   * The schemas
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * Whether the user's email is verified
   */
  @JsonProperty("verified")
  @Override
  public Boolean getVerified() {
    return verified;
  }

  /**
   * The zone id the user belongs to
   */
  @JsonProperty("zoneId")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * The id
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The identity provider that authenticated this user
   */
  @JsonProperty("origin")
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * The user name
   */
  @JsonProperty("userName")
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * This instance is equal to all instances of {@code DeleteUserResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteUserResponse
        && equalTo((DeleteUserResponse) another);
  }

  private boolean equalTo(DeleteUserResponse another) {
    return approval.equals(another.approval)
        && externalId.equals(another.externalId)
        && group.equals(another.group)
        && active.equals(another.active)
        && email.equals(another.email)
        && meta.equals(another.meta)
        && name.equals(another.name)
        && passwordLastModified.equals(another.passwordLastModified)
        && schemas.equals(another.schemas)
        && verified.equals(another.verified)
        && zoneId.equals(another.zoneId)
        && id.equals(another.id)
        && origin.equals(another.origin)
        && userName.equals(another.userName);
  }

  /**
   * Computes a hash code from attributes: {@code approval}, {@code externalId}, {@code group}, {@code active}, {@code email}, {@code meta}, {@code name}, {@code passwordLastModified}, {@code schemas}, {@code verified}, {@code zoneId}, {@code id}, {@code origin}, {@code userName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + approval.hashCode();
    h = h * 17 + externalId.hashCode();
    h = h * 17 + group.hashCode();
    h = h * 17 + active.hashCode();
    h = h * 17 + email.hashCode();
    h = h * 17 + meta.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + passwordLastModified.hashCode();
    h = h * 17 + schemas.hashCode();
    h = h * 17 + verified.hashCode();
    h = h * 17 + zoneId.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + origin.hashCode();
    h = h * 17 + userName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteUserResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteUserResponse{"
        + "approval=" + approval
        + ", externalId=" + externalId
        + ", group=" + group
        + ", active=" + active
        + ", email=" + email
        + ", meta=" + meta
        + ", name=" + name
        + ", passwordLastModified=" + passwordLastModified
        + ", schemas=" + schemas
        + ", verified=" + verified
        + ", zoneId=" + zoneId
        + ", id=" + id
        + ", origin=" + origin
        + ", userName=" + userName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.users._DeleteUserResponse {
    List<Approval> approval = Collections.emptyList();
    String externalId;
    List<Group> group = Collections.emptyList();
    Boolean active;
    List<Email> email = Collections.emptyList();
    Meta meta;
    Name name;
    String passwordLastModified;
    List<String> schemas = Collections.emptyList();
    Boolean verified;
    String zoneId;
    String id;
    String origin;
    String userName;
    @JsonProperty("approvals")
    public void setApproval(List<Approval> approval) {
      this.approval = approval;
    }
    @JsonProperty("externalId")
    public void setExternalId(String externalId) {
      this.externalId = externalId;
    }
    @JsonProperty("groups")
    public void setGroup(List<Group> group) {
      this.group = group;
    }
    @JsonProperty("active")
    public void setActive(Boolean active) {
      this.active = active;
    }
    @JsonProperty("emails")
    public void setEmail(List<Email> email) {
      this.email = email;
    }
    @JsonProperty("meta")
    public void setMeta(Meta meta) {
      this.meta = meta;
    }
    @JsonProperty("name")
    public void setName(Name name) {
      this.name = name;
    }
    @JsonProperty("passwordLastModified")
    public void setPasswordLastModified(String passwordLastModified) {
      this.passwordLastModified = passwordLastModified;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("verified")
    public void setVerified(Boolean verified) {
      this.verified = verified;
    }
    @JsonProperty("zoneId")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("origin")
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    @JsonProperty("userName")
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @Override
    public List<Approval> getApproval() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Group> getGroup() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public List<Email> getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public Name getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPasswordLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getVerified() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static DeleteUserResponse fromJson(Json json) {
    DeleteUserResponse.Builder builder = DeleteUserResponse.builder();
    if (json.approval != null) {
      builder.addAllApproval(json.approval);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.group != null) {
      builder.addAllGroup(json.group);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.email != null) {
      builder.addAllEmail(json.email);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.passwordLastModified != null) {
      builder.passwordLastModified(json.passwordLastModified);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.verified != null) {
      builder.verified(json.verified);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DeleteUserResponse DeleteUserResponse}.
   * @return A new DeleteUserResponse builder
   */
  public static DeleteUserResponse.Builder builder() {
    return new DeleteUserResponse.Builder();
  }

  /**
   * Builds instances of type {@link DeleteUserResponse DeleteUserResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL_ID = 0x1L;
    private static final long INIT_BIT_ACTIVE = 0x2L;
    private static final long INIT_BIT_META = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_PASSWORD_LAST_MODIFIED = 0x10L;
    private static final long INIT_BIT_VERIFIED = 0x20L;
    private static final long INIT_BIT_ZONE_ID = 0x40L;
    private static final long INIT_BIT_ID = 0x80L;
    private static final long INIT_BIT_ORIGIN = 0x100L;
    private static final long INIT_BIT_USER_NAME = 0x200L;
    private long initBits = 0x3ffL;

    private List<Approval> approval = new ArrayList<Approval>();
    private String externalId;
    private List<Group> group = new ArrayList<Group>();
    private Boolean active;
    private List<Email> email = new ArrayList<Email>();
    private Meta meta;
    private Name name;
    private String passwordLastModified;
    private List<String> schemas = new ArrayList<String>();
    private Boolean verified;
    private String zoneId;
    private String id;
    private String origin;
    private String userName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUserSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUserId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteUserResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteUserResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DeleteUserResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteUserResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractUserSummary) {
        AbstractUserSummary instance = (AbstractUserSummary) object;
        meta(instance.getMeta());
        addAllSchemas(instance.getSchemas());
        verified(instance.getVerified());
        name(instance.getName());
        active(instance.getActive());
        zoneId(instance.getZoneId());
        passwordLastModified(instance.getPasswordLastModified());
        addAllEmail(instance.getEmail());
      }
      if (object instanceof AbstractUserId) {
        AbstractUserId instance = (AbstractUserId) object;
        userName(instance.getUserName());
        origin(instance.getOrigin());
        id(instance.getId());
      }
      if (object instanceof AbstractUser) {
        AbstractUser instance = (AbstractUser) object;
        externalId(instance.getExternalId());
        addAllApproval(instance.getApproval());
        addAllGroup(instance.getGroup());
      }
    }

    /**
     * Adds one element to {@link _DeleteUserResponse#getApproval() approval} list.
     * @param element A approval element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder approval(Approval element) {
      this.approval.add(Objects.requireNonNull(element, "approval element"));
      return this;
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getApproval() approval} list.
     * @param elements An array of approval elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder approval(Approval... elements) {
      for (Approval element : elements) {
        this.approval.add(Objects.requireNonNull(element, "approval element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _DeleteUserResponse#getApproval() approval} list.
     * @param elements An iterable of approval elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder approval(Iterable<? extends Approval> elements) {
      this.approval.clear();
      return addAllApproval(elements);
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getApproval() approval} list.
     * @param elements An iterable of approval elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApproval(Iterable<? extends Approval> elements) {
      for (Approval element : elements) {
        this.approval.add(Objects.requireNonNull(element, "approval element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getExternalId() externalId} attribute.
     * @param externalId The value for externalId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalId(String externalId) {
      this.externalId = Objects.requireNonNull(externalId, "externalId");
      initBits &= ~INIT_BIT_EXTERNAL_ID;
      return this;
    }

    /**
     * Adds one element to {@link _DeleteUserResponse#getGroup() group} list.
     * @param element A group element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder group(Group element) {
      this.group.add(Objects.requireNonNull(element, "group element"));
      return this;
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getGroup() group} list.
     * @param elements An array of group elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder group(Group... elements) {
      for (Group element : elements) {
        this.group.add(Objects.requireNonNull(element, "group element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _DeleteUserResponse#getGroup() group} list.
     * @param elements An iterable of group elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder group(Iterable<? extends Group> elements) {
      this.group.clear();
      return addAllGroup(elements);
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getGroup() group} list.
     * @param elements An iterable of group elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroup(Iterable<? extends Group> elements) {
      for (Group element : elements) {
        this.group.add(Objects.requireNonNull(element, "group element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getActive() active} attribute.
     * @param active The value for active 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(Boolean active) {
      this.active = Objects.requireNonNull(active, "active");
      initBits &= ~INIT_BIT_ACTIVE;
      return this;
    }

    /**
     * Adds one element to {@link _DeleteUserResponse#getEmail() email} list.
     * @param element A email element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email element) {
      this.email.add(Objects.requireNonNull(element, "email element"));
      return this;
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getEmail() email} list.
     * @param elements An array of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email... elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _DeleteUserResponse#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Iterable<? extends Email> elements) {
      this.email.clear();
      return addAllEmail(elements);
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmail(Iterable<? extends Email> elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getMeta() meta} attribute.
     * @param meta The value for meta 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(Meta meta) {
      this.meta = Objects.requireNonNull(meta, "meta");
      initBits &= ~INIT_BIT_META;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(Name name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getPasswordLastModified() passwordLastModified} attribute.
     * @param passwordLastModified The value for passwordLastModified 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passwordLastModified(String passwordLastModified) {
      this.passwordLastModified = Objects.requireNonNull(passwordLastModified, "passwordLastModified");
      initBits &= ~INIT_BIT_PASSWORD_LAST_MODIFIED;
      return this;
    }

    /**
     * Adds one element to {@link _DeleteUserResponse#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _DeleteUserResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link _DeleteUserResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getVerified() verified} attribute.
     * @param verified The value for verified 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verified(Boolean verified) {
      this.verified = Objects.requireNonNull(verified, "verified");
      initBits &= ~INIT_BIT_VERIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserResponse#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Builds a new {@link DeleteUserResponse DeleteUserResponse}.
     * @return An immutable instance of DeleteUserResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteUserResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteUserResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_EXTERNAL_ID) != 0) attributes.add("externalId");
      if ((initBits & INIT_BIT_ACTIVE) != 0) attributes.add("active");
      if ((initBits & INIT_BIT_META) != 0) attributes.add("meta");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PASSWORD_LAST_MODIFIED) != 0) attributes.add("passwordLastModified");
      if ((initBits & INIT_BIT_VERIFIED) != 0) attributes.add("verified");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build DeleteUserResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
