package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _Email}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Email.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Email"})
public final class Email extends org.cloudfoundry.uaa.users._Email {
  private final String value;
  private final Boolean primary;

  private Email(Email.Builder builder) {
    this.value = builder.value;
    this.primary = builder.primary;
  }

  /**
   * The email address
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Whether this email address is the primary
   */
  @JsonProperty("primary")
  @Override
  public Boolean getPrimary() {
    return primary;
  }

  /**
   * This instance is equal to all instances of {@code Email} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Email
        && equalTo((Email) another);
  }

  private boolean equalTo(Email another) {
    return value.equals(another.value)
        && primary.equals(another.primary);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code primary}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + value.hashCode();
    h = h * 17 + primary.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Email} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Email{"
        + "value=" + value
        + ", primary=" + primary
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.users._Email {
    String value;
    Boolean primary;
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("primary")
    public void setPrimary(Boolean primary) {
      this.primary = primary;
    }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPrimary() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Email fromJson(Json json) {
    Email.Builder builder = Email.builder();
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.primary != null) {
      builder.primary(json.primary);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Email Email}.
   * @return A new Email builder
   */
  public static Email.Builder builder() {
    return new Email.Builder();
  }

  /**
   * Builds instances of type {@link Email Email}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_PRIMARY = 0x2L;
    private long initBits = 0x3L;

    private String value;
    private Boolean primary;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Email} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Email instance) {
      return from((_Email) instance);
    }

    /**
     * Copy abstract value type {@code _Email} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Email instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      primary(instance.getPrimary());
      return this;
    }

    /**
     * Initializes the value for the {@link _Email#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link _Email#getPrimary() primary} attribute.
     * @param primary The value for primary 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder primary(Boolean primary) {
      this.primary = Objects.requireNonNull(primary, "primary");
      initBits &= ~INIT_BIT_PRIMARY;
      return this;
    }

    /**
     * Builds a new {@link Email Email}.
     * @return An immutable instance of Email
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Email build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Email(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_PRIMARY) != 0) attributes.add("primary");
      return "Cannot build Email, some of required attributes are not set " + attributes;
    }
  }
}
