package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _Name}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Name.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Name"})
public final class Name extends org.cloudfoundry.uaa.users._Name {
  private final String familyName;
  private final String givenName;

  private Name(Name.Builder builder) {
    this.familyName = builder.familyName;
    this.givenName = builder.givenName;
  }

  /**
   * The family name
   */
  @JsonProperty("familyName")
  @Override
  public String getFamilyName() {
    return familyName;
  }

  /**
   * The given name
   */
  @JsonProperty("givenName")
  @Override
  public String getGivenName() {
    return givenName;
  }

  /**
   * This instance is equal to all instances of {@code Name} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Name
        && equalTo((Name) another);
  }

  private boolean equalTo(Name another) {
    return familyName.equals(another.familyName)
        && givenName.equals(another.givenName);
  }

  /**
   * Computes a hash code from attributes: {@code familyName}, {@code givenName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + familyName.hashCode();
    h = h * 17 + givenName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Name} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Name{"
        + "familyName=" + familyName
        + ", givenName=" + givenName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends org.cloudfoundry.uaa.users._Name {
    String familyName;
    String givenName;
    @JsonProperty("familyName")
    public void setFamilyName(String familyName) {
      this.familyName = familyName;
    }
    @JsonProperty("givenName")
    public void setGivenName(String givenName) {
      this.givenName = givenName;
    }
    @Override
    public String getFamilyName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGivenName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Name fromJson(Json json) {
    Name.Builder builder = Name.builder();
    if (json.familyName != null) {
      builder.familyName(json.familyName);
    }
    if (json.givenName != null) {
      builder.givenName(json.givenName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Name Name}.
   * @return A new Name builder
   */
  public static Name.Builder builder() {
    return new Name.Builder();
  }

  /**
   * Builds instances of type {@link Name Name}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_FAMILY_NAME = 0x1L;
    private static final long INIT_BIT_GIVEN_NAME = 0x2L;
    private long initBits = 0x3L;

    private String familyName;
    private String givenName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Name} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Name instance) {
      return from((_Name) instance);
    }

    /**
     * Copy abstract value type {@code _Name} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Name instance) {
      Objects.requireNonNull(instance, "instance");
      familyName(instance.getFamilyName());
      givenName(instance.getGivenName());
      return this;
    }

    /**
     * Initializes the value for the {@link _Name#getFamilyName() familyName} attribute.
     * @param familyName The value for familyName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder familyName(String familyName) {
      this.familyName = Objects.requireNonNull(familyName, "familyName");
      initBits &= ~INIT_BIT_FAMILY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _Name#getGivenName() givenName} attribute.
     * @param givenName The value for givenName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder givenName(String givenName) {
      this.givenName = Objects.requireNonNull(givenName, "givenName");
      initBits &= ~INIT_BIT_GIVEN_NAME;
      return this;
    }

    /**
     * Builds a new {@link Name Name}.
     * @return An immutable instance of Name
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Name build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Name(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_FAMILY_NAME) != 0) attributes.add("familyName");
      if ((initBits & INIT_BIT_GIVEN_NAME) != 0) attributes.add("givenName");
      return "Cannot build Name, some of required attributes are not set " + attributes;
    }
  }
}
