package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Restage an App operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RestageApplicationRequest"})
public final class RestageApplicationRequest
    extends org.cloudfoundry.client.v2.applications._RestageApplicationRequest {
  private final String applicationId;

  private RestageApplicationRequest(RestageApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * This instance is equal to all instances of {@code RestageApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RestageApplicationRequest
        && equalTo((RestageApplicationRequest) another);
  }

  private boolean equalTo(RestageApplicationRequest another) {
    return applicationId.equals(another.applicationId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RestageApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RestageApplicationRequest{"
        + "applicationId=" + applicationId
        + "}";
  }

  /**
   * Creates a builder for {@link RestageApplicationRequest RestageApplicationRequest}.
   * @return A new RestageApplicationRequest builder
   */
  public static RestageApplicationRequest.Builder builder() {
    return new RestageApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RestageApplicationRequest RestageApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RestageApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RestageApplicationRequest instance) {
      return from((_RestageApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RestageApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RestageApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link _RestageApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Builds a new {@link RestageApplicationRequest RestageApplicationRequest}.
     * @return An immutable instance of RestageApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RestageApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RestageApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build RestageApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
