package org.cloudfoundry.client.v2.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List Events operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListEventsRequest"})
public final class ListEventsRequest extends org.cloudfoundry.client.v2.events._ListEventsRequest {
  private final @Nullable List<String> actees;
  private final @Nullable List<String> timestamps;
  private final @Nullable List<String> types;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListEventsRequest(ListEventsRequest.Builder builder) {
    this.actees = builder.actees == null ? null : createUnmodifiableList(true, builder.actees);
    this.timestamps = builder.timestamps == null ? null : createUnmodifiableList(true, builder.timestamps);
    this.types = builder.types == null ? null : createUnmodifiableList(true, builder.types);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The actees
   */
  @Override
  public @Nullable List<String> getActees() {
    return actees;
  }

  /**
   * The timestamps
   */
  @Override
  public @Nullable List<String> getTimestamps() {
    return timestamps;
  }

  /**
   * The types
   */
  @Override
  public @Nullable List<String> getTypes() {
    return types;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListEventsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListEventsRequest
        && equalTo((ListEventsRequest) another);
  }

  private boolean equalTo(ListEventsRequest another) {
    return Objects.equals(actees, another.actees)
        && Objects.equals(timestamps, another.timestamps)
        && Objects.equals(types, another.types)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code actees}, {@code timestamps}, {@code types}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(actees);
    h = h * 17 + Objects.hashCode(timestamps);
    h = h * 17 + Objects.hashCode(types);
    h = h * 17 + Objects.hashCode(orderDirection);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListEventsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListEventsRequest{"
        + "actees=" + actees
        + ", timestamps=" + timestamps
        + ", types=" + types
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListEventsRequest ListEventsRequest}.
   * @return A new ListEventsRequest builder
   */
  public static ListEventsRequest.Builder builder() {
    return new ListEventsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListEventsRequest ListEventsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> actees = null;
    private List<String> timestamps = null;
    private List<String> types = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListEventsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListEventsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.events._ListEventsRequest) {
        org.cloudfoundry.client.v2.events._ListEventsRequest instance = (org.cloudfoundry.client.v2.events._ListEventsRequest) object;
        List<String> typesValue = instance.getTypes();
        if (typesValue != null) {
          addAllTypes(typesValue);
        }
        List<String> timestampsValue = instance.getTimestamps();
        if (timestampsValue != null) {
          addAllTimestamps(timestampsValue);
        }
        List<String> acteesValue = instance.getActees();
        if (acteesValue != null) {
          addAllActees(acteesValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListEventsRequest#getActees() actees} list.
     * @param element A actees element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actee(String element) {
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      this.actees.add(Objects.requireNonNull(element, "actees element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListEventsRequest#getActees() actees} list.
     * @param elements An array of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actee(String... elements) {
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actees.add(Objects.requireNonNull(element, "actees element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListEventsRequest#getActees() actees} list.
     * @param elements An iterable of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actees(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.actees = null;
        return this;
      }
      this.actees = new ArrayList<String>();
      return addAllActees(elements);
    }

    /**
     * Adds elements to {@link _ListEventsRequest#getActees() actees} list.
     * @param elements An iterable of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActees(Iterable<String> elements) {
      Objects.requireNonNull(elements, "actees element");
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actees.add(Objects.requireNonNull(element, "actees element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListEventsRequest#getTimestamps() timestamps} list.
     * @param element A timestamps element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(String element) {
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListEventsRequest#getTimestamps() timestamps} list.
     * @param elements An array of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(String... elements) {
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      for (String element : elements) {
        this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListEventsRequest#getTimestamps() timestamps} list.
     * @param elements An iterable of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamps(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.timestamps = null;
        return this;
      }
      this.timestamps = new ArrayList<String>();
      return addAllTimestamps(elements);
    }

    /**
     * Adds elements to {@link _ListEventsRequest#getTimestamps() timestamps} list.
     * @param elements An iterable of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTimestamps(Iterable<String> elements) {
      Objects.requireNonNull(elements, "timestamps element");
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      for (String element : elements) {
        this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListEventsRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String element) {
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListEventsRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String... elements) {
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.types = null;
        return this;
      }
      this.types = new ArrayList<String>();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link _ListEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "types element");
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListEventsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListEventsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListEventsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListEventsRequest ListEventsRequest}.
     * @return An immutable instance of ListEventsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListEventsRequest build() {
      return new ListEventsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
