package org.cloudfoundry.client.v2.organizationquotadefinitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Creating a Organization Quota Definition operation
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "_CreateOrganizationQuotaDefinitionRequest"})
public final class CreateOrganizationQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.organizationquotadefinitions._CreateOrganizationQuotaDefinitionRequest {
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer applicationTaskLimit;
  private final Integer instanceMemoryLimit;
  private final Integer memoryLimit;
  private final String name;
  private final Boolean nonBasicServicesAllowed;
  private final @Nullable Integer totalPrivateDomains;
  private final Integer totalRoutes;
  private final @Nullable Integer totalServiceKeys;
  private final Integer totalServices;
  private final @Nullable Boolean trialDatabaseAllowed;

  private CreateOrganizationQuotaDefinitionRequest(CreateOrganizationQuotaDefinitionRequest.Builder builder) {
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.applicationTaskLimit = builder.applicationTaskLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
    this.totalPrivateDomains = builder.totalPrivateDomains;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceKeys = builder.totalServiceKeys;
    this.totalServices = builder.totalServices;
    this.trialDatabaseAllowed = builder.trialDatabaseAllowed;
  }

  /**
   * The application instance limit
   */
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The application task limit
   */
  @Override
  public @Nullable Integer getApplicationTaskLimit() {
    return applicationTaskLimit;
  }

  /**
   * The instance memory limit
   */
  @Override
  public Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The memory limit
   */
  @Override
  public Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The non basic services allowed
   */
  @Override
  public Boolean getNonBasicServicesAllowed() {
    return nonBasicServicesAllowed;
  }

  /**
   * The total private domains
   */
  @Override
  public @Nullable Integer getTotalPrivateDomains() {
    return totalPrivateDomains;
  }

  /**
   * The total routes
   */
  @Override
  public Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total service keys
   */
  @Override
  public @Nullable Integer getTotalServiceKeys() {
    return totalServiceKeys;
  }

  /**
   * The total services
   */
  @Override
  public Integer getTotalServices() {
    return totalServices;
  }

  /**
   * The trial db allowed
   */
  @Deprecated
  @Override
  public @Nullable Boolean getTrialDatabaseAllowed() {
    return trialDatabaseAllowed;
  }

  /**
   * This instance is equal to all instances of {@code CreateOrganizationQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateOrganizationQuotaDefinitionRequest
        && equalTo((CreateOrganizationQuotaDefinitionRequest) another);
  }

  private boolean equalTo(CreateOrganizationQuotaDefinitionRequest another) {
    return Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(applicationTaskLimit, another.applicationTaskLimit)
        && instanceMemoryLimit.equals(another.instanceMemoryLimit)
        && memoryLimit.equals(another.memoryLimit)
        && name.equals(another.name)
        && nonBasicServicesAllowed.equals(another.nonBasicServicesAllowed)
        && Objects.equals(totalPrivateDomains, another.totalPrivateDomains)
        && totalRoutes.equals(another.totalRoutes)
        && Objects.equals(totalServiceKeys, another.totalServiceKeys)
        && totalServices.equals(another.totalServices)
        && Objects.equals(trialDatabaseAllowed, another.trialDatabaseAllowed);
  }

  /**
   * Computes a hash code from attributes: {@code applicationInstanceLimit}, {@code applicationTaskLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code nonBasicServicesAllowed}, {@code totalPrivateDomains}, {@code totalRoutes}, {@code totalServiceKeys}, {@code totalServices}, {@code trialDatabaseAllowed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applicationInstanceLimit);
    h = h * 17 + Objects.hashCode(applicationTaskLimit);
    h = h * 17 + instanceMemoryLimit.hashCode();
    h = h * 17 + memoryLimit.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + nonBasicServicesAllowed.hashCode();
    h = h * 17 + Objects.hashCode(totalPrivateDomains);
    h = h * 17 + totalRoutes.hashCode();
    h = h * 17 + Objects.hashCode(totalServiceKeys);
    h = h * 17 + totalServices.hashCode();
    h = h * 17 + Objects.hashCode(trialDatabaseAllowed);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateOrganizationQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateOrganizationQuotaDefinitionRequest{"
        + "applicationInstanceLimit=" + applicationInstanceLimit
        + ", applicationTaskLimit=" + applicationTaskLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", nonBasicServicesAllowed=" + nonBasicServicesAllowed
        + ", totalPrivateDomains=" + totalPrivateDomains
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceKeys=" + totalServiceKeys
        + ", totalServices=" + totalServices
        + ", trialDatabaseAllowed=" + trialDatabaseAllowed
        + "}";
  }

  /**
   * Creates a builder for {@link CreateOrganizationQuotaDefinitionRequest CreateOrganizationQuotaDefinitionRequest}.
   * @return A new CreateOrganizationQuotaDefinitionRequest builder
   */
  public static CreateOrganizationQuotaDefinitionRequest.Builder builder() {
    return new CreateOrganizationQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateOrganizationQuotaDefinitionRequest CreateOrganizationQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_INSTANCE_MEMORY_LIMIT = 0x1L;
    private static final long INIT_BIT_MEMORY_LIMIT = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_NON_BASIC_SERVICES_ALLOWED = 0x8L;
    private static final long INIT_BIT_TOTAL_ROUTES = 0x10L;
    private static final long INIT_BIT_TOTAL_SERVICES = 0x20L;
    private long initBits = 0x3fL;

    private Integer applicationInstanceLimit;
    private Integer applicationTaskLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Boolean nonBasicServicesAllowed;
    private Integer totalPrivateDomains;
    private Integer totalRoutes;
    private Integer totalServiceKeys;
    private Integer totalServices;
    private Boolean trialDatabaseAllowed;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateOrganizationQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateOrganizationQuotaDefinitionRequest instance) {
      return from((_CreateOrganizationQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateOrganizationQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateOrganizationQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer applicationTaskLimitValue = instance.getApplicationTaskLimit();
      if (applicationTaskLimitValue != null) {
        applicationTaskLimit(applicationTaskLimitValue);
      }
      instanceMemoryLimit(instance.getInstanceMemoryLimit());
      memoryLimit(instance.getMemoryLimit());
      name(instance.getName());
      nonBasicServicesAllowed(instance.getNonBasicServicesAllowed());
      Integer totalPrivateDomainsValue = instance.getTotalPrivateDomains();
      if (totalPrivateDomainsValue != null) {
        totalPrivateDomains(totalPrivateDomainsValue);
      }
      totalRoutes(instance.getTotalRoutes());
      Integer totalServiceKeysValue = instance.getTotalServiceKeys();
      if (totalServiceKeysValue != null) {
        totalServiceKeys(totalServiceKeysValue);
      }
      totalServices(instance.getTotalServices());
      Boolean trialDatabaseAllowedValue = instance.getTrialDatabaseAllowed();
      if (trialDatabaseAllowedValue != null) {
        trialDatabaseAllowed(trialDatabaseAllowedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit} attribute.
     * @param applicationTaskLimit The value for applicationTaskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = Objects.requireNonNull(instanceMemoryLimit, "instanceMemoryLimit");
      initBits &= ~INIT_BIT_INSTANCE_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(Integer memoryLimit) {
      this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
      initBits &= ~INIT_BIT_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed} attribute.
     * @param nonBasicServicesAllowed The value for nonBasicServicesAllowed 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = Objects.requireNonNull(nonBasicServicesAllowed, "nonBasicServicesAllowed");
      initBits &= ~INIT_BIT_NON_BASIC_SERVICES_ALLOWED;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getTotalPrivateDomains() totalPrivateDomains} attribute.
     * @param totalPrivateDomains The value for totalPrivateDomains (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalPrivateDomains(@Nullable Integer totalPrivateDomains) {
      this.totalPrivateDomains = totalPrivateDomains;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(Integer totalRoutes) {
      this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
      initBits &= ~INIT_BIT_TOTAL_ROUTES;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys} attribute.
     * @param totalServiceKeys The value for totalServiceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(Integer totalServices) {
      this.totalServices = Objects.requireNonNull(totalServices, "totalServices");
      initBits &= ~INIT_BIT_TOTAL_SERVICES;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationQuotaDefinitionRequest#getTrialDatabaseAllowed() trialDatabaseAllowed} attribute.
     * @param trialDatabaseAllowed The value for trialDatabaseAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder trialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
      this.trialDatabaseAllowed = trialDatabaseAllowed;
      return this;
    }

    /**
     * Builds a new {@link CreateOrganizationQuotaDefinitionRequest CreateOrganizationQuotaDefinitionRequest}.
     * @return An immutable instance of CreateOrganizationQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateOrganizationQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateOrganizationQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_INSTANCE_MEMORY_LIMIT) != 0) attributes.add("instanceMemoryLimit");
      if ((initBits & INIT_BIT_MEMORY_LIMIT) != 0) attributes.add("memoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NON_BASIC_SERVICES_ALLOWED) != 0) attributes.add("nonBasicServicesAllowed");
      if ((initBits & INIT_BIT_TOTAL_ROUTES) != 0) attributes.add("totalRoutes");
      if ((initBits & INIT_BIT_TOTAL_SERVICES) != 0) attributes.add("totalServices");
      return "Cannot build CreateOrganizationQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
