package org.cloudfoundry.client.v2.privatedomains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Private Domain operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetPrivateDomainRequest"})
public final class GetPrivateDomainRequest
    extends org.cloudfoundry.client.v2.privatedomains._GetPrivateDomainRequest {
  private final String privateDomainId;

  private GetPrivateDomainRequest(GetPrivateDomainRequest.Builder builder) {
    this.privateDomainId = builder.privateDomainId;
  }

  /**
   * The private domain id
   */
  @Override
  public String getPrivateDomainId() {
    return privateDomainId;
  }

  /**
   * This instance is equal to all instances of {@code GetPrivateDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetPrivateDomainRequest
        && equalTo((GetPrivateDomainRequest) another);
  }

  private boolean equalTo(GetPrivateDomainRequest another) {
    return privateDomainId.equals(another.privateDomainId);
  }

  /**
   * Computes a hash code from attributes: {@code privateDomainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + privateDomainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetPrivateDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetPrivateDomainRequest{"
        + "privateDomainId=" + privateDomainId
        + "}";
  }

  /**
   * Creates a builder for {@link GetPrivateDomainRequest GetPrivateDomainRequest}.
   * @return A new GetPrivateDomainRequest builder
   */
  public static GetPrivateDomainRequest.Builder builder() {
    return new GetPrivateDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetPrivateDomainRequest GetPrivateDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PRIVATE_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private String privateDomainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetPrivateDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetPrivateDomainRequest instance) {
      return from((_GetPrivateDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetPrivateDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetPrivateDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      privateDomainId(instance.getPrivateDomainId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetPrivateDomainRequest#getPrivateDomainId() privateDomainId} attribute.
     * @param privateDomainId The value for privateDomainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder privateDomainId(String privateDomainId) {
      this.privateDomainId = Objects.requireNonNull(privateDomainId, "privateDomainId");
      initBits &= ~INIT_BIT_PRIVATE_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link GetPrivateDomainRequest GetPrivateDomainRequest}.
     * @return An immutable instance of GetPrivateDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetPrivateDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetPrivateDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PRIVATE_DOMAIN_ID) != 0) attributes.add("privateDomainId");
      return "Cannot build GetPrivateDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
