package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Routes operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListRoutesRequest"})
public final class ListRoutesRequest extends org.cloudfoundry.client.v2.routes._ListRoutesRequest {
  private final @Nullable List<String> domainIds;
  private final @Nullable List<String> hosts;
  private final @Nullable String organizationId;
  private final @Nullable List<String> paths;
  private final @Nullable Integer port;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListRoutesRequest(ListRoutesRequest.Builder builder) {
    this.domainIds = builder.domainIds == null ? null : createUnmodifiableList(true, builder.domainIds);
    this.hosts = builder.hosts == null ? null : createUnmodifiableList(true, builder.hosts);
    this.organizationId = builder.organizationId;
    this.paths = builder.paths == null ? null : createUnmodifiableList(true, builder.paths);
    this.port = builder.port;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The domain ids
   */
  @Override
  public @Nullable List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The hosts
   */
  @Override
  public @Nullable List<String> getHosts() {
    return hosts;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The paths
   */
  @Override
  public @Nullable List<String> getPaths() {
    return paths;
  }

  /**
   * The port
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRoutesRequest
        && equalTo((ListRoutesRequest) another);
  }

  private boolean equalTo(ListRoutesRequest another) {
    return Objects.equals(domainIds, another.domainIds)
        && Objects.equals(hosts, another.hosts)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(paths, another.paths)
        && Objects.equals(port, another.port)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code domainIds}, {@code hosts}, {@code organizationId}, {@code paths}, {@code port}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(domainIds);
    h = h * 17 + Objects.hashCode(hosts);
    h = h * 17 + Objects.hashCode(organizationId);
    h = h * 17 + Objects.hashCode(paths);
    h = h * 17 + Objects.hashCode(port);
    h = h * 17 + Objects.hashCode(orderDirection);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRoutesRequest{"
        + "domainIds=" + domainIds
        + ", hosts=" + hosts
        + ", organizationId=" + organizationId
        + ", paths=" + paths
        + ", port=" + port
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListRoutesRequest ListRoutesRequest}.
   * @return A new ListRoutesRequest builder
   */
  public static ListRoutesRequest.Builder builder() {
    return new ListRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRoutesRequest ListRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> domainIds = null;
    private List<String> hosts = null;
    private String organizationId;
    private List<String> paths = null;
    private Integer port;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRoutesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.routes._ListRoutesRequest) {
        org.cloudfoundry.client.v2.routes._ListRoutesRequest instance = (org.cloudfoundry.client.v2.routes._ListRoutesRequest) object;
        String organizationIdValue = instance.getOrganizationId();
        if (organizationIdValue != null) {
          organizationId(organizationIdValue);
        }
        List<String> domainIdsValue = instance.getDomainIds();
        if (domainIdsValue != null) {
          addAllDomainIds(domainIdsValue);
        }
        Integer portValue = instance.getPort();
        if (portValue != null) {
          port(portValue);
        }
        List<String> hostsValue = instance.getHosts();
        if (hostsValue != null) {
          addAllHosts(hostsValue);
        }
        List<String> pathsValue = instance.getPaths();
        if (pathsValue != null) {
          addAllPaths(pathsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListRoutesRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String... elements) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainIds = null;
        return this;
      }
      this.domainIds = new ArrayList<String>();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link _ListRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainIds element");
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListRoutesRequest#getHosts() hosts} list.
     * @param element A hosts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String element) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListRoutesRequest#getHosts() hosts} list.
     * @param elements An array of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String... elements) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.hosts = null;
        return this;
      }
      this.hosts = new ArrayList<String>();
      return addAllHosts(elements);
    }

    /**
     * Adds elements to {@link _ListRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllHosts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "hosts element");
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRoutesRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Adds one element to {@link _ListRoutesRequest#getPaths() paths} list.
     * @param element A paths element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(String element) {
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      this.paths.add(Objects.requireNonNull(element, "paths element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListRoutesRequest#getPaths() paths} list.
     * @param elements An array of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(String... elements) {
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paths(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.paths = null;
        return this;
      }
      this.paths = new ArrayList<String>();
      return addAllPaths(elements);
    }

    /**
     * Adds elements to {@link _ListRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPaths(Iterable<String> elements) {
      Objects.requireNonNull(elements, "paths element");
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRoutesRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRoutesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRoutesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRoutesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListRoutesRequest ListRoutesRequest}.
     * @return An immutable instance of ListRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRoutesRequest build() {
      return new ListRoutesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
