package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Delete Security Group Running Default operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteSecurityGroupRunningDefaultRequest"})
public final class DeleteSecurityGroupRunningDefaultRequest
    extends org.cloudfoundry.client.v2.securitygroups._DeleteSecurityGroupRunningDefaultRequest {
  private final String securityGroupRunningDefaultId;

  private DeleteSecurityGroupRunningDefaultRequest(DeleteSecurityGroupRunningDefaultRequest.Builder builder) {
    this.securityGroupRunningDefaultId = builder.securityGroupRunningDefaultId;
  }

  /**
   * The security group running default id
   */
  @Override
  public String getSecurityGroupRunningDefaultId() {
    return securityGroupRunningDefaultId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteSecurityGroupRunningDefaultRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteSecurityGroupRunningDefaultRequest
        && equalTo((DeleteSecurityGroupRunningDefaultRequest) another);
  }

  private boolean equalTo(DeleteSecurityGroupRunningDefaultRequest another) {
    return securityGroupRunningDefaultId.equals(another.securityGroupRunningDefaultId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupRunningDefaultId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + securityGroupRunningDefaultId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteSecurityGroupRunningDefaultRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteSecurityGroupRunningDefaultRequest{"
        + "securityGroupRunningDefaultId=" + securityGroupRunningDefaultId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteSecurityGroupRunningDefaultRequest DeleteSecurityGroupRunningDefaultRequest}.
   * @return A new DeleteSecurityGroupRunningDefaultRequest builder
   */
  public static DeleteSecurityGroupRunningDefaultRequest.Builder builder() {
    return new DeleteSecurityGroupRunningDefaultRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteSecurityGroupRunningDefaultRequest DeleteSecurityGroupRunningDefaultRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_RUNNING_DEFAULT_ID = 0x1L;
    private long initBits = 0x1L;

    private String securityGroupRunningDefaultId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteSecurityGroupRunningDefaultRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteSecurityGroupRunningDefaultRequest instance) {
      return from((_DeleteSecurityGroupRunningDefaultRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteSecurityGroupRunningDefaultRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteSecurityGroupRunningDefaultRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupRunningDefaultId(instance.getSecurityGroupRunningDefaultId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteSecurityGroupRunningDefaultRequest#getSecurityGroupRunningDefaultId() securityGroupRunningDefaultId} attribute.
     * @param securityGroupRunningDefaultId The value for securityGroupRunningDefaultId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupRunningDefaultId(String securityGroupRunningDefaultId) {
      this.securityGroupRunningDefaultId = Objects.requireNonNull(securityGroupRunningDefaultId, "securityGroupRunningDefaultId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_RUNNING_DEFAULT_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteSecurityGroupRunningDefaultRequest DeleteSecurityGroupRunningDefaultRequest}.
     * @return An immutable instance of DeleteSecurityGroupRunningDefaultRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteSecurityGroupRunningDefaultRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteSecurityGroupRunningDefaultRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_RUNNING_DEFAULT_ID) != 0) attributes.add("securityGroupRunningDefaultId");
      return "Cannot build DeleteSecurityGroupRunningDefaultRequest, some of required attributes are not set " + attributes;
    }
  }
}
